function yy = runT6_getChr()
% updated on 190717 to read multi-channel z stacks. The 488 bead images are
% Channel 3 in the 3-channel z stacks

% updated on 190711 to analyze the correltion between gene expression and
% comparmentalization; also save chromosome list to facilitate joint 
% analysis of multiple datasets.

% updated on 190704 to extract the lamina profile and caculate the lamina
% association ratio

% updated on 190612 to include nucleolar abstraction and analysis of
% association with nucleolus

% updated on 190529 to include the consitutive LAD coordinates from Bas van
% Steensel's work and ask if they are in B compartments; also if the
% constitutive LADs have different surface ratio in comparison to all other
% TADs or other TADs in B.

% updated on 190526 to calculate the change in surface ratio for TAD that
% switched A-B compartment in different cell types, and also the change in
% gene expression in those TADs.

% updated on 190524 to search for genes correlated with AB scores and
% chromosome surface indices; also generate normalized matrix with the
% running average method to calcualte expected distances between genomic
% loci

% updated on 190521 to perform compartment polarization analysis
% updated on 190508 to add compartment anlaysis

% clear all
close all
parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end

%% load in chromosome traces
n = 0;
for jj = 0:NFOV-1    
    if exist(['TracingResults\TraceArrayRefined' num2str(jj) '.mat'])==2 
        load(['TracingResults\TraceArrayRefined' num2str(jj) '.mat']);
        
        for i = 1:length(TraceArray)
            n = n+1;
            Chr(n).x = NaN(NumLoci,1);
            Chr(n).y = NaN(NumLoci,1);
            Chr(n).z = NaN(NumLoci,1);
            Chr(n).r = zeros(NumLoci,1);
            Chr(n).x(TraceArray{i}(:,end)) = TraceArray{i}(:,1);
            Chr(n).y(TraceArray{i}(:,end)) = TraceArray{i}(:,2);
            Chr(n).z(TraceArray{i}(:,end)) = TraceArray{i}(:,3);
            Chr(n).r(TraceArray{i}(:,end)) = 1;
                        
            x = TraceArray{i}(:,1)/UmPerPxl;
            y = TraceArray{i}(:,2)/UmPerPxl;
            
            Chr(n).FOV = jj;            
        end
    end
end
save('ChrList.mat','Chr') %added on 190711 to facilitate joint analysis of multiple datasets.

% Plot mean spatial distance matrix

for i = 1:NumLoci 
    for j = 1:NumLoci 
        DisList = [];
        for k = 1:length(Chr)
            if Chr(k).r(i) == 1 && Chr(k).r(j) == 1
                DisList = [DisList ((Chr(k).x(i)-Chr(k).x(j))^2+(Chr(k).y(i)-Chr(k).y(j))^2+(Chr(k).z(i)-Chr(k).z(j))^2)^0.5];
            end
        end
        Mean(i,j) = mean(DisList);
        Std(i,j) = std(DisList);
        SEM(i,j) = std(DisList)/(length(DisList))^0.5;
        NofData(i,j) = length(DisList);
        DisListAll{i,j} = DisList;
    end
end
figure(2)
imagesc(Mean)
colorbar
title('Mean spatial distance');
xlabel('ID # of imaged genomic loci');
ylabel('ID # of imaged genomic loci');
ColorMap = load('RedBlue.txt');
colormap(ColorMap/255);
axis square
saveas(gcf, 'Mean spatial distance.jpg')
% savefig(['Mean spatial distance.fig']);
