function yy = runM3_compare_single_MAv5()
% updated on 210804 to generate the MolList without single cell analysis
% updated on 210208 to be compatible with the MERLIN algorithm output (v5 of MERFISH analysis)

% clear all
close all
parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end

load([MERFISHcodebookPath MERFISHcodebook]);

%%
N = length(Codebook); % number of genes
load([MERFISHcodebookPath 'AllCodes.mat'])
NumCodesAll = length(GoodCodes); % number of all posible codes

%%
CopyNumbers = zeros(NumCodesAll,1);
FPKMs = [Codebook.FPKM]';
for jj = 0:NFOV-1    
    for kk = 1:NumSteps
        if exist(['MerfishResults/stats_' num2str(jj) '_' num2str(kk) '.mat']) % updated on 210208 
            load(['MerfishResults/stats_' num2str(jj) '_' num2str(kk) '.mat']); % updated on 210208 
            delete(['MerfishResults/ImageStack_' num2str(jj) '_' num2str(kk) '.mat']); % clean up % updated on 210208 
            for ii = 1:NumCodesAll
                CopyNumbers(ii) = CopyNumbers(ii) + length(stats{ii}); % updated on 210208 
            end
        end
    end
end

figure(1)
CopyNumbers_Gene = CopyNumbers(1:N);
Ind = find(FPKMs>0 & CopyNumbers_Gene>0);
loglog(FPKMs(Ind), CopyNumbers_Gene(Ind), 'ko','MarkerFaceColor', 'k');
title(['Count = ' num2str(sum(CopyNumbers_Gene(Ind))) ', R = ' num2str(corr(log10(FPKMs(Ind)), log10(CopyNumbers_Gene(Ind))))])

xlabel('FPKM');
ylabel('Copy number (MHD4)')
saveas(gcf, 'Correlation coefficient between MERFISH (MHD4) and RNA seq.jpg')
TotalRNAcount = sum(CopyNumbers_Gene(Ind))


if exist('figures_MERFISH')
    delete figures_MERFISH/*
end
mkdir figures_MERFISH

m = 0; % total molecule count 
MolOutput{1,1} = 'GeneID';
MolOutput{1,2} = 'MoleculeX';
MolOutput{1,3} = 'MoleculeY';
MolOutput{1,4} = 'FieldOfView';
for jj = 0:NFOV-1
    for i = 1:N
        MolPositions{i} = [];
    end
    for kk = 1:NumSteps
        if exist(['MerfishResults/stats_' num2str(jj) '_' num2str(kk) '.mat']) % updated on 210208 
            load(['MerfishResults/stats_' num2str(jj) '_' num2str(kk) '.mat']); % updated on 210208 
            for i = 1:N
                NewPosition = round(cat(1,stats{i}.Centroid)); % updated on 210208 
                MolPositions{i} = [MolPositions{i}; NewPosition];
            end
        end
    end
    
    A = ones(ImageSize,ImageSize);
    A(ImageSize,ImageSize)=0;
    figure(5)
    imshow(A)
    axis equal
    colormap gray
    hold on
    for i = 1:N
        if ~isempty(MolPositions{i})
            plot(MolPositions{i}(:,1), MolPositions{i}(:,2), '.')
        end
    end
    hold off
    title('MHD4 mode; all molecules') % updated on 210208 
    saveas(gcf, ['figures_MERFISH/figure5_' num2str(jj) '.jpg']) 
    
    for j = 1:N
        for k = 1:size(MolPositions{j},1)
            MolY = round(MolPositions{j}(k,2));
            MolX = round(MolPositions{j}(k,1));
            if MolY>0 && MolY<=ImageSize && MolX>0 && MolX<=ImageSize
                m = m+1;
                MolList(m).GeneID = j;
                MolList(m).MoleculeX = MolX;
                MolList(m).MoleculeY = MolY;
                MolList(m).FieldOfView = jj;
                
                MolOutput{m+1,1} = num2str(j);
                MolOutput{m+1,2} = num2str(MolX);
                MolOutput{m+1,3} = num2str(MolY);
                MolOutput{m+1,4} = num2str(jj);
            end
        end
    end
end
save('SingleCellAnalysisResults.mat','MolList')
if exist('MolList.csv') == 2
    delete MolList.csv
end
T = cell2table(MolOutput(2:end,:));
T.Properties.VariableNames = MolOutput(1,:);
writetable(T,'MolList.csv');

% if exist('MolList.xlsx') == 2
%     delete MolList.xlsx
% end
% xlswrite('MolList.xlsx', MolOutput);




