function yy = runM2_decode_MAv5()
% updated on 210804
% updated on 210208
% This version is dratically different from the previous versions as it
% uses the MERLIN algorithm described int the Chenglong Xia 2019 PNAS paper
% for MERFISH decoding.

clear all
close all

parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end

load([MERFISHcodebookPath MERFISHcodebook]);
NumGenes = length(Codebook); % number of genes (used codes)
load([MERFISHcodebookPath 'AllCodes.mat'])
NumCodesAll = length(GoodCodes);% number of all codes
NumcodesBlank = NumCodesAll-NumGenes; % number of blank control codes

%% These are the dirft correct transformation matrix file names. Empty means the bit is imaged in hyb0 and there is no drift.
for i = 1:16
    Pos = strfind(FileNameForBit{i},'_');
    Pos1 = Pos(end-1)+1;
    Pos2 = Pos(end)-1;
    if str2num(FileNameForBit{i}(Pos1:Pos2)) == 0
        TformForBit{i} = '';
    else
        TformForBit{i} = ['tformsMERFISH/tform_' num2str(str2num(FileNameForBit{i}(Pos1:Pos2))) '_'];     
    end
end

%%
if exist('MerfishResults')
    delete('MerfishResults/*')
end
mkdir('MerfishResults');
% NormalizationVector = [];
% for iii = 1:10 % 10 iterations to reach convergence
    VoxelL2_all = [];
    VectorDistance_all = [];
    Area_all = [];
%     StdS2_all = [];
    VoxelL2_blank = [];
    VectorDistance_blank = [];
    Area_blank = [];
%     StdS2_blank = [];
    
    for jj = 0:NFOV-1
        N = 0;
		XDrifts = [];
		YDrifts = [];
        for ii = 1:RoundsOfHybs
            if exist(['tformsMERFISH/tform_' num2str(ii) '_' num2str(jj) '.mat'])
				load(['tformsMERFISH/tform_' num2str(ii) '_' num2str(jj) '.mat']);
                N = N+1;
				% record the drift along x and y
				XDrifts = [XDrifts tform.T(3,1)];
				YDrifts = [YDrifts tform.T(3,2)];
            end
        end
		% find the maximum drift in each direction to define excluded border pixels
		LeftBorder = max([ceil(max(XDrifts)) 0]); % >=0 unit pixel
		RightBorder = -min([floor(min(XDrifts)) 0]); % >=0 unit pixel
		TopBorder = max([ceil(max(YDrifts)) 0]); % >=0 unit pixel
		BottomBorder = -min([floor(min(YDrifts)) 0]); % >=0 unit pixel
        if N == RoundsOfHybs
            for kk = 1:NumSteps
                StartFrame = (kk-1)*FramesToAverage+3; %updated 181204 from +2 to +3
                EndFrame = (kk-1)*FramesToAverage+FramesToAverage+1; 
                ImageStack = zeros(ImageSize,ImageSize,16);
%                 if isempty(NormalizationVector)
                    for ii = 1:16
                        if exist([FileNameForBit{ii} num2str(jj) '.dax'])
                            FileName1 = [FileNameForBit{ii} num2str(jj)];
                        elseif exist([FileNameForBit{ii} '0' num2str(jj) '.dax'])
                            FileName1 = [FileNameForBit{ii} '0' num2str(jj)];
                        end
                        [MovieFP, InfoFile] = ReadDax([FileName1, '.dax'],'startFrame', StartFrame, 'endFrame', EndFrame);
                        Image1 = mean(MovieFP,3);
                        if length(TformForBit{ii})>0 
                            load([TformForBit{ii} num2str(jj) '.mat']);
                            MeanX =tform.T(3,1);
                            MeanY =tform.T(3,2);
                            Image1 = imtranslate(Image1, [MeanX MeanY]);
                        end
                        background = imopen(Image1, strel('disk', 5));
                        Image2 = Image1-background;
                        Image2(find(Image2<1)) = 1;
						% clear the borders due to drift
						if LeftBorder>0
							Image2(:,1:LeftBorder) = 1;
						end
						if RightBorder>0
							Image2(:,end-RightBorder+1:end) = 1;
						end
						if TopBorder>0
							Image2(1:TopBorder,:) = 1;
						end
						if BottomBorder>0
							Image2(end-BottomBorder+1:end,:) = 1;
						end	
                        ImageStack(:,:,ii) = Image2;     
                    end
%                 else
%                     load(['MerfishResults/ImageStack_' num2str(jj) '_' num2str(kk) '.mat']);
%                     for ii = 1:16
%                         ImageStack(:,:,ii) = ImageStack(:,:,ii)/NormalizationVector(ii);
%                     end
%                 end
            
                UnitImageStack = ImageStack;
                L2 = (sum(ImageStack.^2,3)).^0.5;
%                 Mu = mean(ImageStack,3);
%                 S2  = (sum((ImageStack-Mu).^2,3)/15).^0.5;% record the std of each vector
                for ii = 1:16
                    UnitImageStack(:,:,ii) = UnitImageStack(:,:,ii)./L2;
                end
                
                Dis = zeros(ImageSize, ImageSize, NumCodesAll);
                for ii = 1:NumCodesAll
                    load([MERFISHcodebookPath 'CodeMatrices\CodeMatrix' num2str(ii) '.mat']);
                    Dis(:,:,ii) = (sum((UnitImageStack-CodeMatrix/2).^2,3)).^0.5;
                end
                [M, I] = min(Dis,[],3);
                Ind = find(M>=0.6058); % sqrt(1/6+1/6+4*(1/sqrt(6)-1/2)^2) = 0.6058
                I(Ind) = 0;
                for ii = 1:NumCodesAll
                    BW = zeros(ImageSize,ImageSize);
                    BW(find(I==ii)) = 1;
                    CC(ii) = bwconncomp(BW,8);
                    stats{ii} = regionprops(CC(ii),'Centroid','Area','PixelIdxList'); % Area is the voxel number
                    for i = 1:length(stats{ii})
                        % calculate voxel intensity
                        stats{ii}(i).VoxelL2 = mean(L2(stats{ii}(i).PixelIdxList));
                        % caluclate vector distance
                        stats{ii}(i).VectorDistance = min(M(stats{ii}(i).PixelIdxList));
                        % record the std of the pixel vector
%                         stats{ii}(i).StdS2 = mean(S2(stats{ii}(i).PixelIdxList));
                    end
                end
                save(['MerfishResults/ImageStack_' num2str(jj) '_' num2str(kk) '.mat'],'ImageStack');
                save(['MerfishResults/stats_original_' num2str(jj) '_' num2str(kk) '.mat'],'stats');   
                for ii = 1:NumCodesAll
                    VoxelL2_all = [VoxelL2_all [stats{ii}.VoxelL2]];
                    VectorDistance_all = [VectorDistance_all [stats{ii}.VectorDistance]];
                    Area_all = [Area_all [stats{ii}.Area]];
%                     StdS2_all = [StdS2_all [stats{ii}.StdS2]];
                    if ii > NumGenes
                        VoxelL2_blank = [VoxelL2_blank [stats{ii}.VoxelL2]];
                        VectorDistance_blank = [VectorDistance_blank [stats{ii}.VectorDistance]];
                        Area_blank = [Area_blank [stats{ii}.Area]];
%                         StdS2_blank = [StdS2_blank [stats{ii}.StdS2]];
                    end
                end
            end
        end
    end
    
    save('FociCharacteristicsList.mat', 'VoxelL2_all', 'VectorDistance_all', 'Area_all', 'VoxelL2_blank', 'VectorDistance_blank', 'Area_blank');
    
    %% determine 3D parameter space with <5% mis-identification rate
    load('FociCharacteristicsList.mat');
    % Area range 1:1:25
    % VectorDistance range 0:0.01:0.61
    % VoxelL2 range 0:20:400
    % StdS2 range 0:10:250 % not used
%     ParameterSpace = zeros(25,61,30,25);

% use an adaptive procedure to determine the cutoff false positive rate for rejecting each parameter bin,
% so that the final flase positive rate is 0.05
flag = 0;
CutoffFlasePositiveRate = 0.05;
while flag == 0
    ParameterSpace = zeros(25,61,20);
    ParameterSpace_next = zeros(25,61,20);
    AcceptedCountAll = 0;
    AcceptedCountBlank = 0;
    AcceptedCountAll_next = 0;
    AcceptedCountBlank_next = 0;
    display(['CutoffFlasePositiveRate = ', num2str(CutoffFlasePositiveRate)]);
    for i = 1:25
        display(['i = ', num2str(i)]);
        for j = 1:61
            for k = 1:20
                % for n = 1:25
                    Area_min = i;
                    Area_max = i+1;
                    if i == 25
                        Area_max = Inf;
                    end
                    VectorDistance_min = (j-1)*0.01;
                    VectorDistance_max = (j)*0.01;
                    if j ==61
                        VectorDistance_max = Inf;
                    end
                    VoxelL2_min = (k-1)*20;
                    VoxelL2_max = (k)*20;
                    if k == 20
                        VoxelL2_max = Inf;
                    end
%                     StdS2_min = (n-1)*10;
%                     StdS2_max = (n)*10;
%                     if n == 25
%                         StdS2_max = Inf;
%                     end
                    Ind1 = find(Area_all>=Area_min & Area_all<Area_max ...
                        & VectorDistance_all>=VectorDistance_min & VectorDistance_all<VectorDistance_max ...
                        & VoxelL2_all>=VoxelL2_min & VoxelL2_all<VoxelL2_max); % ...
                        % & StdS2_all>=StdS2_min & StdS2_all<StdS2_max);
                    Ind2 = find(Area_blank>=Area_min & Area_blank<Area_max ...
                        & VectorDistance_blank>=VectorDistance_min & VectorDistance_blank<VectorDistance_max ...
                        & VoxelL2_blank>=VoxelL2_min & VoxelL2_blank<VoxelL2_max); % ...
                        % & StdS2_blank>=StdS2_min & StdS2_blank<StdS2_max);
                    if length(Ind2)/NumcodesBlank*NumCodesAll/length(Ind1) < CutoffFlasePositiveRate
%                          ParameterSpace(i,j,k,n) = 1;
                         ParameterSpace(i,j,k) = 1;
                         AcceptedCountAll = AcceptedCountAll+ length(Ind1);
                         AcceptedCountBlank = AcceptedCountBlank+ length(Ind2);
                    end
                    if length(Ind2)/NumcodesBlank*NumCodesAll/length(Ind1) < CutoffFlasePositiveRate+0.01
%                          ParameterSpace(i,j,k,n) = 1;
                         ParameterSpace_next(i,j,k) = 1;
                         AcceptedCountAll_next = AcceptedCountAll_next+ length(Ind1);
                         AcceptedCountBlank_next = AcceptedCountBlank_next+ length(Ind2);
                    end
                    
                    OverallFalsePositiveRate_next = AcceptedCountBlank_next/NumcodesBlank*NumCodesAll/AcceptedCountAll_next;
                    OverallFalsePositiveRate = AcceptedCountBlank/NumcodesBlank*NumCodesAll/AcceptedCountAll;
                    
                % end
            end
        end
    end
    if OverallFalsePositiveRate_next > 0.05 || CutoffFlasePositiveRate >= 0.2 
        flag = 1;
    else
        CutoffFlasePositiveRate = CutoffFlasePositiveRate + 0.01;
    end
end
save('ParameterSpace.mat', 'ParameterSpace','CutoffFlasePositiveRate','OverallFalsePositiveRate');

    %% Refine the stats cell array to get the identified spots in the good range of ParameterSpace
%     BitIntensities = zeros(16,1);
%     BitAreas = zeros(16,1);
    for jj = 0:NFOV-1
        N = 0;
        for ii = 1:RoundsOfHybs
            if exist(['tformsMERFISH/tform_' num2str(ii) '_' num2str(jj) '.mat'])
                N = N+1;
            end
        end
        if N == RoundsOfHybs
            for kk = 1:NumSteps
                load(['MerfishResults/stats_original_' num2str(jj) '_' num2str(kk) '.mat']);
                for ii = 1:NumCodesAll
                    if ~isempty(stats{ii})
%                         n_list = floor([stats{ii}.StdS2]/10+1);
%                         n_list(find(n_list>25)) = 25;
                        k_list = floor([stats{ii}.VoxelL2]/20+1);
                        k_list(find(k_list>20)) = 20;
                        j_list = floor([stats{ii}.VectorDistance]/0.01+1);
                        j_list(find(j_list>61)) = 61;
                        i_list = [stats{ii}.Area];
                        i_list(find(i_list>25)) = 25;
%                         LinearInd = sub2ind(size(ParameterSpace),i_list, j_list, k_list, n_list);
                        LinearInd = sub2ind(size(ParameterSpace),i_list, j_list, k_list);
                        stats{ii} = stats{ii}(find(ParameterSpace(LinearInd)==1));
                    end
                end
                
                save(['MerfishResults/stats_' num2str(jj) '_' num2str(kk) '.mat'],'stats');   

%                 load(['MerfishResults/ImageStack_' num2str(jj) '_' num2str(kk) '.mat']);
%                 for ii = 1:NumGenes
%                     Ind  = find(Codebook(ii).Code == '1');
%                     for i = 1:length(Ind)
%                         SingleImage = ImageStack(:,:,Ind(i));
%                         BitAreas(Ind(i)) = BitAreas(Ind(i)) + sum([stats{ii}.Area]);
%                         BitIntensities(Ind(i))= BitIntensities(Ind(i)) + sum(SingleImage(cat(1,stats{ii}.PixelIdxList)));
%                     end
%                 end                   
            end
        end
    end
%     NormalizationVector  = BitIntensities./BitAreas;
%     NormalizationVector  = NormalizationVector/NormalizationVector(1);
%     figure(1)
%     plot(ones(16,1)*iii, NormalizationVector, '*');
%     hold on
% end
% hold off




