function yy = runT3_foci_allFOV_MA()
% updated on 190717 to read multi-channel z stacks. The 488 bead images are
% Channel 3 in the 3-channel z stacks

% updated on 190314.

% updated on 190221: use adaptive thresholding to try to fit as high as MaxNumFociToFit
% foci per FOV. Later I can use the foci clustering information from all
% hybs to determine which foci are real and which foci are noise.

% clear all
close all
parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end
AdjrsquareThreshold = 0.7;
FociAreaThreshold = 20; % this threshold elimiates large patches of fluorescence

%% 
if exist('TracingResults')
    delete TracingResults/*
end
mkdir('TracingResults')
load('DeltaZ.mat');
load('tform.mat');
for jj = 0:NFOV-1
    if exist(['TracingDriftParams/DriftParams' num2str(jj) '.mat'])==2
        load(['TracingDriftParams/DriftParams' num2str(jj) '.mat']);
        for i = 1:NumLoci 
            if exist([FileNameForLocus{i} num2str(jj) '.dax'])
                FileName = [FileNameForLocus{i} num2str(jj)];
            elseif exist([FileNameForLocus{i} '0' num2str(jj) '.dax'])
                FileName = [FileNameForLocus{i} '0' num2str(jj)];
            end
            [ImageStack, InfoFile] = ReadZStack_MultiChannel(FileName,NumImage,FramesToWait,TotalNumChannels,ChannelIDforLocus(i)); % updated on 190717
            % use adaptive thresholding to try to get MaxNumFociToFit foci
            LocalMaxThresh = InitialLocalMaxThresh_tracing;
            ImageMax = medfilt2(max(ImageStack, [],3)); 
            background = imopen(ImageMax, strel('disk', 4));
            ImageMax = ImageMax-background;
            ImageMax(find(ImageMax<0)) = 0;
            BW = imextendedmax(ImageMax,LocalMaxThresh);
            CC = bwconncomp(BW, 8);
            S = regionprops(CC, 'Area');
            Ind = find([S.Area]<FociAreaThreshold);
            S = S(Ind);
            while length(S)<MaxNumFociToFit && LocalMaxThresh>15
                LocalMaxThresh = LocalMaxThresh-10;
                BW = imextendedmax(ImageMax,LocalMaxThresh);
                CC = bwconncomp(BW, 8);
                S = regionprops(CC, 'Area');
                Ind = find([S.Area]<FociAreaThreshold);
                S = S(Ind);
            end
            % Here warp the Cy5 image into the Cy3 channel.
            if ChannelIDforLocus(i) == 1
                for j = 1:size(ImageStack,3)
                    ImageStack(:,:,j) = imtransform(ImageStack(:,:,j), tform, 'XData', [1 ImageSize], 'Ydata', [1 ImageSize]);
                end
            end
            [Xfit, Yfit, Zfit, Xgof, Ygof, Zgof, Intensity, Xwidth, Ywidth, Zwidth] = fitMultipleFoci(ImageStack,LocalMaxThresh,MaxNumFociToFit);
            if length(Xfit)>0
                Ind = find([Xgof.adjrsquare]>AdjrsquareThreshold & ...
                    [Ygof.adjrsquare]>AdjrsquareThreshold & ...
                    [Zgof.adjrsquare]>AdjrsquareThreshold);
                Pos = strfind(FileNameForLocus{i},'_');
                Pos1 = Pos(end-1)+1;
                Pos2 = Pos(end)-1;
                if str2num(FileNameForLocus{i}(Pos1:Pos2)) ~= 0
                    j = str2num(FileNameForLocus{i}(Pos1:Pos2));
                    XfitList{i} = Xfit(Ind)- Xdrift(j);
                    YfitList{i} = Yfit(Ind)- Ydrift(j);
                    ZfitList{i} = Zfit(Ind)- Zdrift(j);
                else
                    XfitList{i} = Xfit(Ind);
                    YfitList{i} = Yfit(Ind);
                    ZfitList{i} = Zfit(Ind);
                end
                if ChannelIDforLocus(i) == 1
                    ZfitList{i} = ZfitList{i}-DeltaZ; % cancel the color shift in Z
                end
                XgofList{i} = Xgof(Ind);
                YgofList{i} = Ygof(Ind);
                ZgofList{i} = Zgof(Ind);
                IntensityList{i} = Intensity(Ind);
                XwidthList{i} = Xwidth(Ind); 
                YwidthList{i} = Ywidth(Ind); 
                ZwidthList{i} = Zwidth(Ind);
%                 figure(200)
%                 plot(XfitList{i},YfitList{i},'.');
            else
                XfitList{i} = [];
                YfitList{i} = [];
                ZfitList{i} = [];
                XgofList{i} = [];
                YgofList{i} = [];
                ZgofList{i} = [];
                IntensityList{i} = [];
                XwidthList{i} = []; 
                YwidthList{i} = []; 
                ZwidthList{i} = [];
            end
            display(['Successfully fit ' num2str(length(XfitList{i})) ' foci.'])
        end
%         figure(200)
%         hold off
%         savefig(['figs/FociFitting_' FOVid '.fig']);
        save(['TracingResults/result' num2str(jj) '.mat'], 'XfitList', 'YfitList', 'ZfitList', 'XgofList', 'YgofList', 'ZgofList','IntensityList','XwidthList','YwidthList','ZwidthList');
    end
end

    

