function yy = runT5_refineTraces_MA()
% updated on 190717 to read multi-channel z stacks. The 488 bead images are
% Channel 3 in the 3-channel z stacks

% updated on 190314.

% This program refine the traces identified by runT4_linkTraces: For each 
% round of imaging, it looks for missing foci among the traces, and try to
% re-fit the missing foci in the chromosome territory defined by the fitted
% foci in each trace. 

% updated on 181203 to replace ReadZStack_medfilt with ReadZStack, 
% because the new fitFoci functions perform the median filtering inside.

% clear all
close all
parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end

WidthThreshMax = 4; % this threshold removes fitted "foci" that are too wide.
WidthThreshMin = 1; % this threshold removes fitted "foci" that are too narrow.
AdjrsquareThreshold = 0.7;

%%
FinalFociCount = zeros(NumLoci,1); % final count of foci in the traces
TotalNumTraces = 0; % total number of traces
se = strel('disk',5);
load('DeltaZ.mat');
load('tform.mat');
% find foci that are missing in each identified chromosome territory and refit them
for jj = 0:NFOV-1
    if exist(['TracingResults\TraceArray' num2str(jj) '.mat'])==2
        load(['TracingResults\TraceArray' num2str(jj) '.mat']);
        load(['TracingDriftParams/DriftParams' num2str(jj) '.mat']);        
        for i = 1:NumLoci
            if exist([FileNameForLocus{i} num2str(jj) '.dax'])
                FileName = [FileNameForLocus{i} num2str(jj)];
            elseif exist([FileNameForLocus{i} '0' num2str(jj) '.dax'])
                FileName = [FileNameForLocus{i} '0' num2str(jj)];
            end
            [ImageStack, InfoFile] = ReadZStack_MultiChannel(FileName,NumImage,FramesToWait,TotalNumChannels,ChannelIDforLocus(i)); % updated on 190717
            Pos = strfind(FileNameForLocus{i},'_');
            Pos1 = Pos(end-1)+1;
            Pos2 = Pos(end)-1;
            if str2num(FileNameForLocus{i}(Pos1:Pos2)) ~= 0
                j = str2num(FileNameForLocus{i}(Pos1:Pos2));
                Yd = Ydrift(j);
                Xd = Xdrift(j);
                Zd = Zdrift(j);
            else
                Yd = 0;
                Xd = 0;
                Zd = 0;
            end
            
            if ChannelIDforLocus(i) == 1
                % Here warp the Cy5 image into the Cy3 channel.
                for j = 1:size(ImageStack,3)
                    ImageStack(:,:,j) = imtransform(ImageStack(:,:,j), tform, 'XData', [1 ImageSize], 'Ydata', [1 ImageSize]);
                end
                display('Finished warping')
            end
            % determine if the traces are missing foci in this image
            m = 0;
            jList = [];% corrected on 190610
            for j = 1:length(TraceArray)
                if isempty(find(TraceArray{j}(:,end)==i)) % indeed missing, then refit
                    Ichr = zeros(ImageSize,ImageSize);
                    % define chromosome territory
                    r = round(TraceArray{j}(:,2)/UmPerPxl+Yd);
                    c = round(TraceArray{j}(:,1)/UmPerPxl+Xd);
                    Ind = find(r>=1 & r<=ImageSize & c>=1 & c<=ImageSize);
                    r = r(Ind);
                    c = c(Ind);
                    if ChannelIDforLocus(i) == 1
                        z = round(TraceArray{j}(:,3)/StepSize+Zd+DeltaZ); % corrected on 190612
                    else
                        z = round(TraceArray{j}(:,3)/StepSize+Zd);
                    end
                    z = z(Ind);
                    LinearInd = sub2ind([ImageSize, ImageSize], r, c);
                    Ichr(LinearInd) = 1;
                    Ichr = imdilate(Ichr,se);
                    Ichr(1:7,:) = 0;
                    Ichr(:,1:7) = 0;
                    Ichr(end-6:end,:) = 0;
                    Ichr(:,end-6:end) = 0;
                    if length(find(Ichr == 1))>0 % corrected on 190607
                        m = m+1;
                        jList = [jList j];% corrected on 190610
                        IchrIndex{m} = find(Ichr == 1);
                        Zrange{m}(1) = min(max(1, min(z)-2),36); % corrected on 190606
                        Zrange{m}(2) = max(1,min(36, max(z)+2)); % corrected on 190606
                    end
                end
            end
            display('finished preparing Ichr')
            % fit focus in this chromosome territory
            if m>0
                [Xfit, Yfit, Zfit, Xgof, Ygof, Zgof, Intensity, Xwidth, Ywidth, Zwidth] = ...
                    fitFociInChr(ImageStack,IchrIndex,Zrange);
                display('finsihed fitting foci in Ichr')
                clear IchrIndex
                clear Zrange % corrected on 190606
            end
            n = 0;
            for j = 1:length(TraceArray)
                if length(find(jList == j))>0 % corrected on 190610
                    n = n+1;
                    if ~isnan(Xfit(n)) && Xgof(n).adjrsquare>AdjrsquareThreshold ...
                            && Ygof(n).adjrsquare>AdjrsquareThreshold ...
                            && Zgof(n).adjrsquare>AdjrsquareThreshold ...
                            && Xwidth(n)<WidthThreshMax && Ywidth(n)<WidthThreshMax ...
                            && Xwidth(n)>WidthThreshMin && Ywidth(n)>WidthThreshMin
                        if ChannelIDforLocus(i) == 1
                            TraceArray{j}(end+1,:) = [(Xfit(n)-Xd)*UmPerPxl, ...
                                (Yfit(n)-Yd)*UmPerPxl, (Zfit(n)-Zd-DeltaZ)*StepSize, ...
                                Intensity(n), Xwidth(n), Ywidth(n), Zwidth(n), Xgof(n).adjrsquare, ...
                                Ygof(n).adjrsquare, Zgof(n).adjrsquare, i]; % corrected on 190612
                        else
                            TraceArray{j}(end+1,:) = [(Xfit(n)-Xd)*UmPerPxl, ...
                                (Yfit(n)-Yd)*UmPerPxl, (Zfit(n)-Zd)*StepSize, ...
                                Intensity(n), Xwidth(n), Ywidth(n), Zwidth(n), Xgof(n).adjrsquare, ...
                                Ygof(n).adjrsquare, Zgof(n).adjrsquare, i];
                        end
                    end
                end
            end
            display(['Tried to fit ' num2str(n) ' new foci for FOV' num2str(jj) ' hyb' num2str(i)])
        end
        % sort the order of foci in traces
        figure(200)
        for j = 1:length(TraceArray)
            [B, Ind] = sort(TraceArray{j}(:,end));
            TraceArray{j} = TraceArray{j}(Ind,:);
            % plot new traces in each FOV
            plot(TraceArray{j}(:,1), TraceArray{j}(:,2),'.-');
            hold on
            FinalFociCount(TraceArray{j}(:,end)) = FinalFociCount(TraceArray{j}(:,end))+1;
            TotalNumTraces = TotalNumTraces+1;
        end
        hold off
        axis equal
        axis ij
        xlabel('x (um)');
        ylabel('y (um)');
        savefig(['figures_Tracing\TracesRefined_' num2str(jj) '.fig']);
        save(['TracingResults\TraceArrayRefined' num2str(jj) '.mat'],'TraceArray');
    end
end
% figure(4)
% bar(FinalFociCount)
% xlabel('Hyb number')
% ylabel('Foci count after refinement')
% savefig(['TracingFociCount_final.fig']);
figure(5)
bar(FinalFociCount/TotalNumTraces)
xlabel('ID # of imaged genomic loci')
ylabel('Detection efficiency in traces')
saveas(gcf, 'Chromatin tracing locus detection efficiency.jpg')


