function yy = runM3_compare_single_MAv5()
% updated on 210208 to be compatible with the MERLIN algorithm output (v5 of MERFISH analysis)

% clear all
close all
parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end

load([MERFISHcodebookPath MERFISHcodebook]);

%%
N = length(Codebook); % number of genes
load([MERFISHcodebookPath 'AllCodes.mat'])
NumCodesAll = length(GoodCodes); % number of all posible codes

%%
CopyNumbers = zeros(NumCodesAll,1);
FPKMs = [Codebook.FPKM]';
for jj = 0:NFOV-1    
    for kk = 1:NumSteps
        if exist(['MerfishResults/stats_' num2str(jj) '_' num2str(kk) '.mat']) % updated on 210208 
            load(['MerfishResults/stats_' num2str(jj) '_' num2str(kk) '.mat']); % updated on 210208 
            delete(['MerfishResults/ImageStack_' num2str(jj) '_' num2str(kk) '.mat']); % clean up % updated on 210208 
            for ii = 1:NumCodesAll
                CopyNumbers(ii) = CopyNumbers(ii) + length(stats{ii}); % updated on 210208 
            end
        end
    end
end

figure(1)
CopyNumbers_Gene = CopyNumbers(1:N);
Ind = find(FPKMs>0 & CopyNumbers_Gene>0);
loglog(FPKMs(Ind), CopyNumbers_Gene(Ind), 'ko','MarkerFaceColor', 'k');
title(['Count = ' num2str(sum(CopyNumbers_Gene(Ind))) ', R = ' num2str(corr(log10(FPKMs(Ind)), log10(CopyNumbers_Gene(Ind))))])

xlabel('FPKM');
ylabel('Copy number (MHD4)')
saveas(gcf, 'Correlation coefficient between MERFISH (MHD4) and RNA seq.jpg')
TotalRNAcount = sum(CopyNumbers_Gene(Ind))

