function yy = runM2_decode_MAv5()
% updated on 210208
% This version is dratically different from the previous versions as it
% uses the MERLIN algorithm described int the Chenglong Xia 2019 PNAS paper
% for MERFISH decoding.

clear all
close all

parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end

load([MERFISHcodebookPath MERFISHcodebook]);
NumGenes = length(Codebook); % number of genes (used codes)
load([MERFISHcodebookPath 'AllCodes.mat'])
NumCodesAll = length(GoodCodes);% number of all codes
NumcodesBlank = NumCodesAll-NumGenes; % number of blank control codes

%% These are the dirft correct transformation matrix file names. Empty means the bit is imaged in hyb0 and there is no drift.
for i = 1:RoundsOfHybs
    Pos = strfind(FileNameForBit{i},'_');
    Pos1 = Pos(end-1)+1;
    Pos2 = Pos(end)-1;
    if str2num(FileNameForBit{i}(Pos1:Pos2)) == 0
        TformForBit{i} = '';
    else
        TformForBit{i} = ['tformsMERFISH/tform_' num2str(str2num(FileNameForBit{i}(Pos1:Pos2))) '_'];     
    end
end

%%
if exist('MerfishResults')
    delete('MerfishResults/*')
end
mkdir('MerfishResults');
% NormalizationVector = [];
% for iii = 1:10 % 10 iterations to reach convergence
    VoxelL2_all = [];
    VectorDistance_all = [];
    Area_all = [];
    VoxelL2_blank = [];
    VectorDistance_blank = [];
    Area_blank = [];
    
    for jj = 0:NFOV-1
        N = 0;
        for ii = 1:RoundsOfHybs-1
            if exist(['tformsMERFISH/tform_' num2str(ii) '_' num2str(jj) '.mat'])
                N = N+1;
            end
        end
        if N == RoundsOfHybs-1
            for kk = 1:NumSteps
                StartFrame = (kk-1)*FramesToAverage+3; %updated 181204 from +2 to +3
                EndFrame = (kk-1)*FramesToAverage+FramesToAverage+1; 
                ImageStack = zeros(ImageSize,ImageSize,16);
%                 if isempty(NormalizationVector)
                    for ii = 1:16
                        if exist([FileNameForBit{ii} num2str(jj) '.dax'])
                            FileName1 = [FileNameForBit{ii} num2str(jj)];
                        elseif exist([FileNameForBit{ii} '0' num2str(jj) '.dax'])
                            FileName1 = [FileNameForBit{ii} '0' num2str(jj)];
                        end
                        [MovieFP, InfoFile] = ReadDax([FileName1, '.dax'],'startFrame', StartFrame, 'endFrame', EndFrame);
                        Image1 = mean(MovieFP,3);
                        if length(TformForBit{ii})>0 
                            load([TformForBit{ii} num2str(jj) '.mat']);
                            MeanX =tform.T(3,1);
                            MeanY =tform.T(3,2);
                            Image1 = imtranslate(Image1, [MeanX MeanY]);
                        end
                        background = imopen(Image1, strel('disk', 5));
                        Image2 = Image1-background;
                        Image2(find(Image2<1)) = 1;
                        ImageStack(:,:,ii) = Image2;     
                    end
%                 else
%                     load(['MerfishResults/ImageStack_' num2str(jj) '_' num2str(kk) '.mat']);
%                     for ii = 1:16
%                         ImageStack(:,:,ii) = ImageStack(:,:,ii)/NormalizationVector(ii);
%                     end
%                 end
            
                UnitImageStack = ImageStack;
                L2 = (sum(ImageStack.^2,3)).^0.5;
                for ii = 1:16
                    UnitImageStack(:,:,ii) = UnitImageStack(:,:,ii)./L2;
                end
                
                Dis = zeros(ImageSize, ImageSize, NumCodesAll);
                for ii = 1:NumCodesAll
                    load([MERFISHcodebookPath 'CodeMatrices\CodeMatrix' num2str(ii) '.mat']);
                    Dis(:,:,ii) = (sum((UnitImageStack-CodeMatrix/2).^2,3)).^0.5;
                end
                [M, I] = min(Dis,[],3);
                Ind = find(M>=0.6058); % sqrt(1/6+1/6+4*(1/sqrt(6)-1/2)^2) = 0.6058
                I(Ind) = 0;
                for ii = 1:NumCodesAll
                    BW = zeros(ImageSize,ImageSize);
                    BW(find(I==ii)) = 1;
                    CC(ii) = bwconncomp(BW,8);
                    stats{ii} = regionprops(CC(ii),'Centroid','Area','PixelIdxList'); % Area is the voxel number
                    for i = 1:length(stats{ii})
                        % calculate voxel intensity
                        stats{ii}(i).VoxelL2 = mean(L2(stats{ii}(i).PixelIdxList));
                        % caluclate vector distance
                        stats{ii}(i).VectorDistance = min(M(stats{ii}(i).PixelIdxList));
                    end
                end
                save(['MerfishResults/ImageStack_' num2str(jj) '_' num2str(kk) '.mat'],'ImageStack');
                save(['MerfishResults/stats_' num2str(jj) '_' num2str(kk) '.mat'],'stats');   
                for ii = 1:NumCodesAll
                    VoxelL2_all = [VoxelL2_all [stats{ii}.VoxelL2]];
                    VectorDistance_all = [VectorDistance_all [stats{ii}.VectorDistance]];
                    Area_all = [Area_all [stats{ii}.Area]];
                    if ii > NumGenes
                        VoxelL2_blank = [VoxelL2_blank [stats{ii}.VoxelL2]];
                        VectorDistance_blank = [VectorDistance_blank [stats{ii}.VectorDistance]];
                        Area_blank = [Area_blank [stats{ii}.Area]];
                    end
                end
            end
        end
    end
    %% determine 3D parameter space with <5% mis-identification rate
    % Area range 1:1:25
    % VectorDistance range 0:0.1:0.61
    % VoxelL2 range 0:10:300
    ParameterSpace = zeros(25,61,30);
    for i = 1:25
        for j = 1:61
            for k = 1:30
                Area_min = i;
                Area_max = i+1;
                if i == 25
                    Area_max = Inf;
                end
                VectorDistance_min = (j-1)*0.1;
                VectorDistance_max = (j)*0.1;
                if j ==61
                    VectorDistance_max = Inf;
                end
                VoxelL2_min = (k-1)*10;
                VoxelL2_max = (k)*10;
                if k == 30
                    VoxelL2_max = Inf;
                end
                Ind1 = find(Area_all>=Area_min & Area_all<Area_max ...
                    & VectorDistance_all>=VectorDistance_min & VectorDistance_all<VectorDistance_max ...
                    & VoxelL2_all>=VoxelL2_min & VoxelL2_all<VoxelL2_max);
                Ind2 = find(Area_blank>=Area_min & Area_blank<Area_max ...
                    & VectorDistance_blank>=VectorDistance_min & VectorDistance_blank<VectorDistance_max ...
                    & VoxelL2_blank>=VoxelL2_min & VoxelL2_blank<VoxelL2_max);
                if length(Ind2)/NumcodesBlank*NumCodesAll/length(Ind1) <0.05
                     ParameterSpace(i,j,k) = 1;
                end
            end
        end
    end
    %% Refine the stats cell array to get the identified spots in the good range of ParameterSpace
%     BitIntensities = zeros(16,1);
%     BitAreas = zeros(16,1);
    for jj = 0:NFOV-1
        N = 0;
        for ii = 1:RoundsOfHybs-1
            if exist(['tformsMERFISH/tform_' num2str(ii) '_' num2str(jj) '.mat'])
                N = N+1;
            end
        end
        if N == RoundsOfHybs-1
            for kk = 1:NumSteps
                load(['MerfishResults/stats_' num2str(jj) '_' num2str(kk) '.mat']);
                for ii = 1:NumCodesAll
                    k_list = floor([stats{ii}.VoxelL2]/10+1);
                    k_list(find(k_list>30)) = 30;
                    j_list = floor([stats{ii}.VectorDistance]/0.1+1);
                    j_list(find(j_list>61)) = 61;
                    i_list = [stats{ii}.Area];
                    i_list(find(i_list>25)) = 25;
                    LinearInd = sub2ind(size(ParameterSpace),i_list, j_list, k_list);
                    stats{ii} = stats{ii}(find(ParameterSpace(LinearInd)==1));
                end
                save(['MerfishResults/stats_' num2str(jj) '_' num2str(kk) '.mat'],'stats');   
%                 load(['MerfishResults/ImageStack_' num2str(jj) '_' num2str(kk) '.mat']);
%                 for ii = 1:NumGenes
%                     Ind  = find(Codebook(ii).Code == '1');
%                     for i = 1:length(Ind)
%                         SingleImage = ImageStack(:,:,Ind(i));
%                         BitAreas(Ind(i)) = BitAreas(Ind(i)) + sum([stats{ii}.Area]);
%                         BitIntensities(Ind(i))= BitIntensities(Ind(i)) + sum(SingleImage(cat(1,stats{ii}.PixelIdxList)));
%                     end
%                 end                   
            end
        end
    end
%     NormalizationVector  = BitIntensities./BitAreas;
%     NormalizationVector  = NormalizationVector/NormalizationVector(1);
%     figure(1)
%     plot(ones(16,1)*iii, NormalizationVector, '*');
%     hold on
% end
% hold off




