function yy = runM3_2_compare_single_MA()
% updated on 201126 to test the effect of including error correction by
% only accepting 1 bit error of 0->1 error, or only accepting 1 bit error
% of 1->0 error.

% updated on 190220 for the combined analysis the RNA MERFISH and DNA
% tracing. The RNA MERFISH uses 16 rounds of readout hybs and all readout
% hybs are in one (Cy7) fluorescent channel.

% clear all
close all
parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end
load([MERFISHcodebookPath MERFISHcodebook]);

%%
N = length(Codebook); % number of genes
load([MERFISHcodebookPath 'AllCodes.mat'])
NumCodesAll = length(GoodCodes); % number of all posible codes
load('BestParameterSet.mat');
iii = BestParameterSet

%%
CopyNumbers = zeros(NumCodesAll,1);
FPKMs = [Codebook.FPKM]';
CopyNumbers_perfect = zeros(NumCodesAll,1);
% added on 201126
CopyNumbers_plus = zeros(NumCodesAll,1);
CopyNumbers_minus = zeros(NumCodesAll,1);
for jj = 0:NFOV-1    
    for kk = 1:NumSteps
        if exist(['MerfishResults' num2str(iii) '/CC_' num2str(jj) '_' num2str(kk) '.mat'])
            load(['MerfishResults' num2str(iii) '/CC_' num2str(jj) '_' num2str(kk) '.mat']);
            load(['MerfishResults' num2str(iii) '/CC_perfect_' num2str(jj) '_' num2str(kk) '.mat']);
            CopyNumbers = CopyNumbers + [CC.NumObjects]';
            CopyNumbers_perfect = CopyNumbers_perfect + [CC_perfect.NumObjects]';
            
            % added on 201126
            load(['MerfishResults' num2str(iii) '/CC_plus_' num2str(jj) '_' num2str(kk) '.mat']);
            load(['MerfishResults' num2str(iii) '/CC_minus_' num2str(jj) '_' num2str(kk) '.mat']);
            CopyNumbers_plus = CopyNumbers_plus + [CC_plus.NumObjects]';
            CopyNumbers_minus = CopyNumbers_minus + [CC_minus.NumObjects]';
        end
    end
end

figure(1)
CopyNumbers_Gene = CopyNumbers(1:N);
Ind = find(FPKMs>0 & CopyNumbers_Gene>0);
loglog(FPKMs(Ind), CopyNumbers_Gene(Ind), 'ko','MarkerFaceColor', 'k');
title(['Count = ' num2str(sum(CopyNumbers_Gene(Ind))) ', R = ' num2str(corr(log10(FPKMs(Ind)), log10(CopyNumbers_Gene(Ind))))])

xlabel('FPKM');
ylabel('Copy number (MHD4)')
saveas(gcf, 'Correlation coefficient for best parameter set (MHD4).jpg')
TotalRNAcount = sum(CopyNumbers_Gene(Ind))

figure(2)
CopyNumbers_perfect_Gene = CopyNumbers_perfect(1:N);
Ind = find(FPKMs>0 & CopyNumbers_perfect_Gene>0);
loglog(FPKMs(Ind), CopyNumbers_perfect_Gene(Ind), 'ko','MarkerFaceColor', 'k');
title(['Count = ' num2str(sum(CopyNumbers_perfect_Gene(Ind))) ', R = ' num2str(corr(log10(FPKMs(Ind)), log10(CopyNumbers_perfect_Gene(Ind))))])

xlabel('FPKM');
ylabel('Copy number (perfect match)')
% save('FPKMandCopyNumbers.mat','FPKMs','CopyNumbers','CopyNumbers_Gene','CopyNumbers_perfect','CopyNumbers_perfect_Gene');
saveas(gcf, 'Correlation coefficient for best parameter set (perfect match).jpg')
TotalRNAcount_perfect = sum(CopyNumbers_perfect_Gene(Ind))

% added on 201126
figure(3)
CopyNumbers_plus_Gene = CopyNumbers_plus(1:N);
Ind = find(FPKMs>0 & CopyNumbers_plus_Gene>0);
loglog(FPKMs(Ind), CopyNumbers_plus_Gene(Ind), 'ko','MarkerFaceColor', 'k');
title(['Count = ' num2str(sum(CopyNumbers_plus_Gene(Ind))) ', R = ' num2str(corr(log10(FPKMs(Ind)), log10(CopyNumbers_plus_Gene(Ind))))])

xlabel('FPKM');
ylabel('Copy number (plus)')
saveas(gcf, 'Correlation coefficient for best parameter set (plus).jpg')
TotalRNAcount_plus = sum(CopyNumbers_plus_Gene(Ind))

figure(4)
CopyNumbers_minus_Gene = CopyNumbers_minus(1:N);
Ind = find(FPKMs>0 & CopyNumbers_minus_Gene>0);
loglog(FPKMs(Ind), CopyNumbers_minus_Gene(Ind), 'ko','MarkerFaceColor', 'k');
title(['Count = ' num2str(sum(CopyNumbers_minus_Gene(Ind))) ', R = ' num2str(corr(log10(FPKMs(Ind)), log10(CopyNumbers_minus_Gene(Ind))))])

xlabel('FPKM');
ylabel('Copy number (minus)')
saveas(gcf, 'Correlation coefficient for best parameter set (minus).jpg')
TotalRNAcount_minus = sum(CopyNumbers_minus_Gene(Ind))


