function yy = runM3_1_compare_MA()
% updated on 201126 to test the effect of including error correction by
% only accepting 1 bit error of 0->1 error, or only accepting 1 bit error
% of 1->0 error.

% updated on 190220 for the combined analysis the RNA MERFISH and DNA
% tracing. The RNA MERFISH uses 16 rounds of readout hybs and all readout
% hybs are in one (Cy7) fluorescent channel.

% clear all
close all
parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end
load([MERFISHcodebookPath MERFISHcodebook]);

%%
N = length(Codebook); % number of genes
load([MERFISHcodebookPath 'AllCodes.mat'])
NumCodesAll = length(GoodCodes); % number of all posible codes

FPKMs = [Codebook.FPKM]';

%%
Fig1Corr = [];
Fig2Corr = [];
% added on 201126
Fig3Corr = [];
Fig4Corr = [];
Fig1Count = [];
Fig2Count = [];
Fig3Count = [];
Fig4Count = [];
for iii = ParameterRange
    CopyNumbers = zeros(NumCodesAll,1);
    CopyNumbers_perfect = zeros(NumCodesAll,1);
    % added on 201126
    CopyNumbers_plus = zeros(NumCodesAll,1);
    CopyNumbers_minus = zeros(NumCodesAll,1);
    for jj = 0:NFOV-1      
        for kk = 1:NumSteps
            if exist(['MerfishResults' num2str(iii) '/CC_' num2str(jj) '_' num2str(kk) '.mat'])
                load(['MerfishResults' num2str(iii) '/CC_' num2str(jj) '_' num2str(kk) '.mat']);
                load(['MerfishResults' num2str(iii) '/CC_perfect_' num2str(jj) '_' num2str(kk) '.mat']);
                CopyNumbers = CopyNumbers + [CC.NumObjects]';
                CopyNumbers_perfect = CopyNumbers_perfect + [CC_perfect.NumObjects]';
                
                % added on 201126
                load(['MerfishResults' num2str(iii) '/CC_plus_' num2str(jj) '_' num2str(kk) '.mat']);
                load(['MerfishResults' num2str(iii) '/CC_minus_' num2str(jj) '_' num2str(kk) '.mat']);
                CopyNumbers_plus = CopyNumbers_plus + [CC_plus.NumObjects]';
                CopyNumbers_minus = CopyNumbers_minus + [CC_minus.NumObjects]';
            end
        end
    end

    
    CopyNumbers_Gene = CopyNumbers(1:N);
    Ind = find(FPKMs>0 & CopyNumbers_Gene>0);
%     figure(1)
%     loglog(FPKMs(Ind), CopyNumbers_Gene(Ind), 'o');
%     title(['R = ' num2str(corr(log10(FPKMs(Ind)), log10(CopyNumbers_Gene(Ind))))])
%     xlabel('FPKM');
%     ylabel('Copy number')
    
    Fig1Corr =[Fig1Corr corr(log10(FPKMs(Ind)), log10(CopyNumbers_Gene(Ind)))];
    Fig1Count = [Fig1Count sum(CopyNumbers_Gene(Ind))];
    
    CopyNumbers_perfect_Gene = CopyNumbers_perfect(1:N);
    Ind = find(FPKMs>0 & CopyNumbers_perfect_Gene>0);
%     figure(2)
%     loglog(FPKMs(Ind), CopyNumbers_perfect_Gene(Ind), 'o');
%     title(['R = ' num2str(corr(log10(FPKMs(Ind)), log10(CopyNumbers_perfect_Gene(Ind))))])
%     xlabel('FPKM');
%     ylabel('Copy number (perfect match)')
    
    Fig2Corr =[Fig2Corr corr(log10(FPKMs(Ind)), log10(CopyNumbers_perfect_Gene(Ind)))];
    Fig2Count = [Fig2Count sum(CopyNumbers_perfect_Gene(Ind))];
    
    % added on 201126
    CopyNumbers_plus_Gene = CopyNumbers_plus(1:N);
    Ind = find(FPKMs>0 & CopyNumbers_plus_Gene>0);
    Fig3Corr =[Fig3Corr corr(log10(FPKMs(Ind)), log10(CopyNumbers_plus_Gene(Ind)))];
    Fig3Count = [Fig3Count sum(CopyNumbers_plus_Gene(Ind))];
    
    CopyNumbers_minus_Gene = CopyNumbers_minus(1:N);
    Ind = find(FPKMs>0 & CopyNumbers_minus_Gene>0);
    Fig4Corr =[Fig4Corr corr(log10(FPKMs(Ind)), log10(CopyNumbers_minus_Gene(Ind)))];
    Fig4Count = [Fig4Count sum(CopyNumbers_minus_Gene(Ind))];
    
end
figure(4)
subplot(1,2,1)
plot(ParameterRange,Fig1Corr)
xlabel('Parameter set');
ylabel('Correlation coefficient');
title('MHD4');
subplot(1,2,2)
plot(ParameterRange,Fig1Count)
xlabel('Parameter set');
ylabel('Cout');
saveas(gcf, 'Correlation coefficients for different parameter sets (MHD4).jpg')

figure(5)
subplot(1,2,1)
plot(ParameterRange,Fig2Corr)
xlabel('Parameter set');
ylabel('Correlation coefficient');
title('perfect match');
subplot(1,2,2)
plot(ParameterRange,Fig2Count)
xlabel('Parameter set');
ylabel('Cout');
saveas(gcf, 'Correlation coefficients for different parameter sets (perfect match).jpg')

% added on 201126
figure(6)
subplot(1,2,1)
plot(ParameterRange,Fig3Corr)
xlabel('Parameter set');
ylabel('Correlation coefficient');
title('Correct codes with an extra 1-bit');
subplot(1,2,2)
plot(ParameterRange,Fig3Count)
xlabel('Parameter set');
ylabel('Cout');
saveas(gcf, 'Correlation coefficients for different parameter sets (plus).jpg')

figure(7)
subplot(1,2,1)
plot(ParameterRange,Fig4Corr)
xlabel('Parameter set');
ylabel('Correlation coefficient');
title('Correct codes missing a 1-bit');
subplot(1,2,2)
plot(ParameterRange,Fig4Count)
xlabel('Parameter set');
ylabel('Cout');
saveas(gcf, 'Correlation coefficients for different parameter sets (minus).jpg')

[M, I] = max(Fig3Corr);

BestParameterSet = ParameterRange(I(1));
save('BestParameterSet.mat','BestParameterSet');



