function yy = runM2_1_findThreshold_MA()
% clear all
close all
% updated on 190220 for the combined analysis the RNA MERFISH and DNA
% tracing. The RNA MERFISH uses 16 rounds of readout hybs and all readout
% hybs are in one (Cy7) fluorescent channel.

parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end
ThreshOriginal = 100; % orignal threshold for MERFISH foci detection (MERFISH)
% load bulk sequencing results
load([MERFISHcodebookPath MERFISHcodebook]);

%%
N = length(Codebook); % number of genes

FPKMs = [Codebook.FPKM];

%% calculate the expected foci number ratio in each image
ExpectedFociRatio = zeros(RoundsOfHybs,1);
for i = 1:N
    for j = 1:RoundsOfHybs
        if Codebook(i).Code(j) == '1';
            ExpectedFociRatio(j) = ExpectedFociRatio(j)+FPKMs(i);
        end
    end
end
ExpectedFociRatio =ExpectedFociRatio/ExpectedFociRatio(1);
% figure(1)
% bar(ExpectedFociRatio)

%% count foci in the first round of imaging
FociCount = 0;
for jj = 0:NFOV-1
    N = 0;
    for ii = 1:RoundsOfHybs-1
        if exist(['tformsMERFISH/tform_' num2str(ii) '_' num2str(jj) '.mat'])
            N = N+1;
        end
    end
    if N == RoundsOfHybs-1
        if exist([FileNameForBit{1} num2str(jj) '.dax'])
            FileName1 = [FileNameForBit{1} num2str(jj)];
        elseif exist([FileNameForBit{1} '0' num2str(jj) '.dax'])
            FileName1 = [FileNameForBit{1} '0' num2str(jj)];
        end
        
        Thresh = ThreshOriginal;
        [MovieFP, InfoFile] = ReadDax([FileName1, '.dax'],'startFrame', 1, 'endFrame', FramesToAverage);
        Image1 = mean(MovieFP,3);

        background = imopen(Image1, strel('disk', 5));
        Image2 = Image1-background;
        RM = imregionalmax(Image2);
        RM2 = imextendedmax(RM.*Image2,Thresh);
        I = RM2.*Image2;
        I2 = I(find(I>0));
        FociCount = FociCount+ length(I2);
    end
end
ExpectedFociNumber =  ExpectedFociRatio*FociCount;
Thresholds(1) = Thresh;

%% try to find best thresholds for Imaging Round 2-16, so that the observed foci number match the expected
for ii = 2:RoundsOfHybs
    if ExpectedFociNumber(ii) == 0
        Thresholds(ii) = nan;
    else

        Thresh = ThreshOriginal;

        FociCount = 0;
        AllFOVImages = [];
        for jj = 0:NFOV-1            
            N = 0;
            for kk = 1:RoundsOfHybs-1
                if exist(['tformsMERFISH/tform_' num2str(kk) '_' num2str(jj) '.mat'])
                    N = N+1;
                end
            end
            if N == RoundsOfHybs-1        
                if exist([FileNameForBit{ii} num2str(jj) '.dax'])
                    FileName1 = [FileNameForBit{ii} num2str(jj)];
                elseif exist([FileNameForBit{ii} '0' num2str(jj) '.dax'])
                    FileName1 = [FileNameForBit{ii} '0' num2str(jj)];
                end
                [MovieFP, InfoFile] = ReadDax([FileName1, '.dax'],'startFrame', 1, 'endFrame', FramesToAverage);
                Image1 = mean(MovieFP,3);

                background = imopen(Image1, strel('disk', 5));
                Image2 = Image1-background;
                AllFOVImages = cat(3, AllFOVImages, Image2);
                RM = imregionalmax(Image2);
                RM2 = imextendedmax(RM.*Image2,Thresh);
                I = RM2.*Image2;
                I2 = I(find(I>0));
                FociCount = FociCount+ length(I2);
            end
        end
        if FociCount>ExpectedFociNumber(ii)
            DeltaThresh = 10;
            flag = 0;
        elseif FociCount<ExpectedFociNumber(ii)
            DeltaThresh = -10;
            flag = 0;
        else
            flag = 1;
            Thresholds(ii) = Thresh;
        end
        while flag == 0
            PreviousFociCount = FociCount;
            FociCount = 0;
            PreviousThresh = Thresh;
            Thresh = Thresh + DeltaThresh
            for jj = 1:size(AllFOVImages,3)
                Image2 = AllFOVImages(:,:,jj);
                RM = imregionalmax(Image2);
                RM2 = imextendedmax(RM.*Image2,Thresh);
                I = RM2.*Image2;
                I2 = I(find(I>0));
                FociCount = FociCount+ length(I2);
            end
            if (PreviousFociCount>ExpectedFociNumber(ii) && FociCount<=ExpectedFociNumber(ii)) || ...
                    (PreviousFociCount<ExpectedFociNumber(ii) && FociCount>=ExpectedFociNumber(ii))
                flag = 1;
                if abs(PreviousFociCount-ExpectedFociNumber(ii)) < abs(FociCount-ExpectedFociNumber(ii))
                    Thresholds(ii) = PreviousThresh;
                else
                    Thresholds(ii) = Thresh;
                end
            end
        end
    end
end
for ii = 2:RoundsOfHybs
    if isnan(Thresholds(ii))

        Thresholds(ii) = mean(Thresholds(find(Thresholds>0)));
    end
end
save('Thresholds.mat', 'Thresholds');