function yy = runMT8_MA()
% updated on 190717 to read multi-channel z stacks. The 488 bead images are
% Channel 3 in the 3-channel z stacks

% updated on 190711 to analyze the correltion between gene expression and
% comparmentalization; also save chromosome list to facilitate joint 
% analysis of multiple datasets.

% updated on 190704 to extract the lamina profile and caculate the lamina
% association ratio

% updated on 190612 to include nucleolar abstraction and analysis of
% association with nucleolus

% updated on 190529 to include the consitutive LAD coordinates from Bas van
% Steensel's work and ask if they are in B compartments; also if the
% constitutive LADs have different surface ratio in comparison to all other
% TADs or other TADs in B.

% updated on 190526 to calculate the change in surface ratio for TAD that
% switched A-B compartment in different cell types, and also the change in
% gene expression in those TADs.

% updated on 190524 to search for genes correlated with AB scores and
% chromosome surface indices; also generate normalized matrix with the
% running average method to calcualte expected distances between genomic
% loci

% updated on 190521 to perform compartment polarization analysis
% updated on 190508 to add compartment anlaysis

% clear all
close all
parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end

%% make new folder
if exist('figures_Nucleolus')
    delete figures_Nucleolus/*
end
if exist('figures_Lamina')
    delete figures_Lamina/*
end
mkdir figures_Nucleolus % this folder stores the nucleolus abstraction 
mkdir figures_Lamina % this folder stores the lamina abstraction

%% load in chromosome traces
load('SingleCellAnalysisResults.mat');
n = 0;
for jj = 0:NFOV-1    
    if IncludeNucleoliAnalysis == 1
        % here extract nucleolar coordinates
        if exist([NucleolarImageHeader num2str(jj) '.dax'])
            FileName = [NucleolarImageHeader num2str(jj)];
        elseif exist([NucleolarImageHeader '0' num2str(jj) '.dax'])
            FileName = [NucleolarImageHeader '0' num2str(jj)];
        end
        [ImageStack, InfoFile] = ReadZStack_MultiChannel(FileName,NumImage,FramesToWait,TotalNumChannels,NucleolarChannelID); % updated on 190717
        ImageMax = medfilt2(max(ImageStack, [],3));
        figure(1000)
        subplot(1,2,1)
        imagesc(ImageMax)
        colormap gray
        axis equal
        NormalizationFactor = max(max(ImageMax));
        T = adaptthresh(ImageMax/NormalizationFactor,AdaptiveThresholdingSensitivity);
        Nucleolus = zeros(size(ImageStack));
        load('DeltaZ.mat');
        load('tform.mat');
        for i = 1:size(ImageStack,3)
            CurrentImage = medfilt2(ImageStack(:,:,i));
            BW = imbinarize(CurrentImage/NormalizationFactor,T);
            % Here warp the Cy5 image into the Cy3 channel.
            if NucleolarChannelID == 1
                BW = imtransform(BW, tform, 'XData', [1 ImageSize], 'Ydata', [1 ImageSize]);
                BW(find(BW<0.5))=0;
                BW(find(BW>=0.5))=1;
            end
            Nucleolus(:,:,i) = BW;
        end
        subplot(1,2,2)
        imagesc(max(Nucleolus, [],3))
        colormap gray
        axis equal
        saveas(gcf, ['figures_Nucleolus/Nucelolus' num2str(jj) '.jpg']);
        Ind = find(Nucleolus);
        [row,col,z] = ind2sub(size(Nucleolus),Ind);
        if NucleolarChannelID == 1
            z = z-DeltaZ; % cancel the color shift in Z
        end
        NucelolarZ = z*StepSize;
        NucelolarX = col*UmPerPxl;
        NucelolarY = row*UmPerPxl;
        figure(1001)
        scatter3(NucelolarX,NucelolarY,NucelolarZ,'.');
        axis equal
        xlabel('x')
        ylabel('y')
        zlabel('z')
        axis ij
        savefig(['figures_Nucleolus/Nucelolus3D' num2str(jj) '.fig']);
        save(['figures_Nucleolus/Nucelolus3D' num2str(jj) '.mat'],'NucelolarZ','NucelolarX', 'NucelolarY');
    end
    
    if IncludeLaminaAnalysis == 1
        % load drift parameters between the lamina images and the hyb0 images
        if exist(['LaminaDriftParams/DriftParams' num2str(jj) '.mat'])==2
            load(['LaminaDriftParams/DriftParams' num2str(jj) '.mat']);
            
            % here extract lamina coordinates
            if exist([NuclearImagePath num2str(jj) '.dax'])
                FileName = [NuclearImagePath num2str(jj)];
            elseif exist([NuclearImagePath '0' num2str(jj) '.dax'])
                FileName = [NuclearImagePath '0' num2str(jj)];
            end
            [ImageStack, InfoFile] = ReadZStack_MultiChannel(FileName,NuclearNumImage,FramesToWait,1,1);
            I = mean(ImageStack,3);
            I = I/max(max(I));
            figure(2000)
            subplot(2,2,1)
            imagesc(I) % plot mean
            colormap gray
            axis equal
            T = adaptthresh(I);
            I = I./T;
            Min = quantile(I(:), 0.25);
            Max = quantile(I(:), 0.75);
            I = (I-Min)/(Max-Min);
            I(find(I<0)) = 0;
            I(find(I>1)) = 1;
            subplot(2,2,2)
            imagesc(I) % plot mean with adaptive background removal
            colormap gray
            axis equal
            se = strel('disk', 25);
            Ie = imerode(I,se);
            I = imreconstruct(Ie,I);
            subplot(2,2,3)
            imagesc(I) % plot the openned image
            colormap gray
            axis equal
            hy = fspecial('sobel');
            hx = hy';
            EdgeStack = [];
            for i  = 1:size(ImageStack,3)
                I = ImageStack(:,:,i);
                I = I/max(max(I));
                T = adaptthresh(I);
                I = I./T;
                Min = quantile(I(:), 0.25);
                Max = quantile(I(:), 0.75);
                I = (I-Min)/(Max-Min);
                I(find(I<0)) = 0;
                I(find(I>1)) = 1;
                Ie = imerode(I,se);
                I = imreconstruct(Ie,I);
                Iy = imfilter(double(I), hy, 'replicate');% calculate gradient image
                Ix = imfilter(double(I), hx, 'replicate');% calculate gradient image
                gradmag = sqrt(Ix.^2 + Iy.^2);% calculate gradient image
                gradmag_filtered = imgaussfilt(gradmag,5); % guassian filter
                bwedge = imbinarize(gradmag_filtered,'adaptive','Sensitivity', 0.1);% binarize
                EdgeStack = cat(3, EdgeStack, bwedge);
            end
            subplot(2,2,4)
            imagesc(mean(EdgeStack,3))
            colormap gray
            axis equal
            saveas(gcf, ['figures_Lamina/Lamina' num2str(jj) '.jpg']);
            Ind = find(EdgeStack);
            [row,col,z] = ind2sub(size(EdgeStack),Ind);
            % apply drift correction and convert to real distance
            LaminaZ = (z- Zdrift)*StepSize;
            LaminaX = (col- Xdrift)*UmPerPxl;
            LaminaY = (row- Ydrift)*UmPerPxl;
            figure(2001)
            scatter3(LaminaX,LaminaY,LaminaZ,'.');
            axis equal
            xlabel('x')
            ylabel('y')
            zlabel('z')
            axis ij
            savefig(['figures_Lamina/Lamina3D' num2str(jj) '.fig']);
            save(['figures_Lamina/Lamina3D' num2str(jj) '.mat'],'LaminaZ','LaminaX', 'LaminaY');
        end
    end

    if exist(['TracingResults\TraceArrayRefined' num2str(jj) '.mat'])==2 && exist(['tformsWGA/tformWGA_' num2str(jj) '.mat'])==2
        load(['TracingResults\TraceArrayRefined' num2str(jj) '.mat']);
        load(['tformsWGA/tformWGA_' num2str(jj) '.mat']);
        
        %find the cell group types in this FOV.
        I2 = zeros(ImageSize);
        Ind = find([CellList.FOV] == jj);
        CellsInFOV = CellList(Ind);
        for i = 1:length(CellsInFOV)
            I2(CellsInFOV(i).PixelList) = CellsInFOV(i).CellID;
        end
        
        for i = 1:length(TraceArray)
            n = n+1;
            Chr(n).x = NaN(NumLoci,1);
            Chr(n).y = NaN(NumLoci,1);
            Chr(n).z = NaN(NumLoci,1);
            Chr(n).r = zeros(NumLoci,1);
            Chr(n).x(TraceArray{i}(:,end)) = TraceArray{i}(:,1);
            Chr(n).y(TraceArray{i}(:,end)) = TraceArray{i}(:,2);
            Chr(n).z(TraceArray{i}(:,end)) = TraceArray{i}(:,3);
            Chr(n).r(TraceArray{i}(:,end)) = 1;
            
            if IncludeNucleoliAnalysis == 1
                % calculate the minimum distance to nucleolar pixels
                Chr(n).MinDisToNucleolar = (pdist2([NucelolarX, NucelolarY,NucelolarZ],[Chr(n).x, Chr(n).y, Chr(n).z],'euclidean','Smallest',1))';
            end
            if IncludeLaminaAnalysis == 1
                % calculate the minimum distance to lamina pixels
                if exist(['LaminaDriftParams/DriftParams' num2str(jj) '.mat'])==2
                    Chr(n).MinDisToLamina = (pdist2([LaminaX, LaminaY,LaminaZ],[Chr(n).x, Chr(n).y, Chr(n).z],'euclidean','Smallest',1))';
                else
                    Chr(n).MinDisToLamina = NaN;
                end
            end
            
            x = TraceArray{i}(:,1)/UmPerPxl;
            y = TraceArray{i}(:,2)/UmPerPxl;
            % take into account the WGA image drift
            [X,Y] = transformPointsInverse(tform,x,y);
            
            %find the corresponding cell group type of this trace.
            MeanY = round(mean(Y));
            MeanX = round(mean(X));
            if MeanY>0 && MeanY<=ImageSize && MeanX>0 && MeanX<=ImageSize 
                Chr(n).CellID = I2(MeanY,MeanX);
            else
                Chr(n).CellID = NaN;          
            end
            
            % this section was added on 190725 to facilitate the combined
            % analysis of mutliple folders (datasets)
            Chr(n).MeanYWGA = MeanY;
            Chr(n).MeanXWGA = MeanX;
            Chr(n).FOV = jj;            
        end
    end
end
save('ChrList.mat','Chr') %added on 190711 to facilitate joint analysis of multiple datasets.

% Plot mean spatial distance matrix

for i = 1:NumLoci 
    for j = 1:NumLoci 
        DisList = [];
        for k = 1:length(Chr)
            if Chr(k).r(i) == 1 && Chr(k).r(j) == 1
                DisList = [DisList ((Chr(k).x(i)-Chr(k).x(j))^2+(Chr(k).y(i)-Chr(k).y(j))^2+(Chr(k).z(i)-Chr(k).z(j))^2)^0.5];
            end
        end
        Mean(i,j) = mean(DisList);
        Std(i,j) = std(DisList);
        SEM(i,j) = std(DisList)/(length(DisList))^0.5;
        NofData(i,j) = length(DisList);
        DisListAll{i,j} = DisList;
    end
end
figure(2)
imagesc(Mean)
colorbar
title('Mean spatial distance');
xlabel('ID # of imaged genomic loci');
ylabel('ID # of imaged genomic loci');
ColorMap = load('RedBlue.txt');
colormap(ColorMap/255);
axis square
saveas(gcf, 'Mean spatial distance.jpg')
% savefig(['Mean spatial distance.fig']);
