function yy = runM3_1_compare_MA()

% updated on 190220 for the combined analysis the RNA MERFISH and DNA
% tracing. The RNA MERFISH uses 16 rounds of readout hybs and all readout
% hybs are in one (Cy7) fluorescent channel.

% clear all
close all
parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end
load([MERFISHcodebookPath MERFISHcodebook]);

%%
N = length(Codebook); % number of genes
load([MERFISHcodebookPath 'AllCodes.mat'])
NumCodesAll = length(GoodCodes); % number of all posible codes

FPKMs = [Codebook.FPKM]';

%%
Fig1Corr = [];
Fig2Corr = [];
% Fig3Corr = [];
for iii = ParameterRange
    CopyNumbers = zeros(NumCodesAll,1);
    CopyNumbers_perfect = zeros(NumCodesAll,1);
    for jj = 0:NFOV-1      
        for kk = 1:NumSteps
            if exist(['MerfishResults' num2str(iii) '/CC_' num2str(jj) '_' num2str(kk) '.mat'])
                load(['MerfishResults' num2str(iii) '/CC_' num2str(jj) '_' num2str(kk) '.mat']);
                load(['MerfishResults' num2str(iii) '/CC_perfect_' num2str(jj) '_' num2str(kk) '.mat']);
                CopyNumbers = CopyNumbers + [CC.NumObjects]';
                CopyNumbers_perfect = CopyNumbers_perfect + [CC_perfect.NumObjects]';
            end
        end
    end

    
    CopyNumbers_Gene = CopyNumbers(1:N);
    Ind = find(FPKMs>0 & CopyNumbers_Gene>0);
%     figure(1)
%     loglog(FPKMs(Ind), CopyNumbers_Gene(Ind), 'o');
%     title(['R = ' num2str(corr(log10(FPKMs(Ind)), log10(CopyNumbers_Gene(Ind))))])
%     xlabel('FPKM');
%     ylabel('Copy number')
    
    Fig1Corr =[Fig1Corr corr(log10(FPKMs(Ind)), log10(CopyNumbers_Gene(Ind)))];

    
    CopyNumbers_perfect_Gene = CopyNumbers_perfect(1:N);
    Ind = find(FPKMs>0 & CopyNumbers_perfect_Gene>0);
%     figure(2)
%     loglog(FPKMs(Ind), CopyNumbers_perfect_Gene(Ind), 'o');
%     title(['R = ' num2str(corr(log10(FPKMs(Ind)), log10(CopyNumbers_perfect_Gene(Ind))))])
%     xlabel('FPKM');
%     ylabel('Copy number (perfect match)')
    
    Fig2Corr =[Fig2Corr corr(log10(FPKMs(Ind)), log10(CopyNumbers_perfect_Gene(Ind)))];


end
figure(4)
plot(ParameterRange,Fig1Corr)
xlabel('Parameter set');
ylabel('Correlation coefficient');
title('MHD4');
saveas(gcf, 'Correlation coefficients for different parameter sets (MHD4).jpg')

figure(5)
plot(ParameterRange,Fig2Corr)
xlabel('Parameter set');
ylabel('Correlation coefficient');
title('perfect match');
saveas(gcf, 'Correlation coefficients for different parameter sets (perfect match).jpg')


[M, I] = max(Fig1Corr);

BestParameterSet = ParameterRange(I(1));
save('BestParameterSet.mat','BestParameterSet');



