function yy = runM2_2_decode_MA()
% updated on 190220 for the combined analysis the RNA MERFISH and DNA
% tracing. The RNA MERFISH uses 16 rounds of readout hybs and all readout
% hybs are in one (Cy7) fluorescent channel.

% updated 181204 to read in the correct images at each imaging height -
% excluding the frame during piezo stage movement.
% clear all
close all

parameters_default
if exist('parameters.mat');
    load('parameters.mat');
end
 % This is the dirft correct transformation matrix file name for bit 1. Empty means the bit is the first imaged and there is no drift.
for i = 1:RoundsOfHybs
    Pos = strfind(FileNameForBit{i},'_');
    Pos1 = Pos(end-1)+1;
    Pos2 = Pos(end)-1;
    if str2num(FileNameForBit{i}(Pos1:Pos2)) == 0
        TformForBit{i} = '';
    else
        TformForBit{i} = ['tformsMERFISH/tform_' num2str(str2num(FileNameForBit{i}(Pos1:Pos2))) '_'];     
    end
end

%%
SE = strel('square',3); % size of RNA foci in the identified image matrix
load([MERFISHcodebookPath 'AllCodes.mat'])
NumCodesAll = length(GoodCodes);
%%
for iii = ParameterRange
    load('Thresholds.mat');
    Thresholds = Thresholds/Thresholds(1)*(iii*20);
    if exist(['MerfishResults' num2str(iii)])
        delete(['MerfishResults' num2str(iii) '/*'])
    end
    mkdir(['MerfishResults' num2str(iii)]);
    
    for jj = 0:NFOV-1
        N = 0;
        for ii = 1:RoundsOfHybs-1
            if exist(['tformsMERFISH/tform_' num2str(ii) '_' num2str(jj) '.mat'])
                N = N+1;
            end
        end
        if N == RoundsOfHybs-1
            for kk = 1:NumSteps
                StartFrame = (kk-1)*FramesToAverage+3; %updated 181204 from +2 to +3

                EndFrame = (kk-1)*FramesToAverage+FramesToAverage+1; 
                ImageStack = zeros(ImageSize,ImageSize,16);
                for ii = 1:16
                    if exist([FileNameForBit{ii} num2str(jj) '.dax'])
                        FileName1 = [FileNameForBit{ii} num2str(jj)];
                    elseif exist([FileNameForBit{ii} '0' num2str(jj) '.dax'])
                        FileName1 = [FileNameForBit{ii} '0' num2str(jj)];
                    end
                    Thresh = Thresholds(ii);
                    [MovieFP, InfoFile] = ReadDax([FileName1, '.dax'],'startFrame', StartFrame, 'endFrame', EndFrame);
                    Image1 = mean(MovieFP,3);

                    if length(TformForBit{ii})>0 
                        load([TformForBit{ii} num2str(jj) '.mat']);
                        MeanX =tform.T(3,1);
                        MeanY =tform.T(3,2);
                        Image1 = imtranslate(Image1, [MeanX MeanY]);
                    end

                    background = imopen(Image1, strel('disk', 5));

                    Image2 = Image1-background;

                    RM = imregionalmax(Image2);

                    RM2 = imextendedmax(RM.*Image2,Thresh);

                    LPFImage = imdilate(RM2,SE);

                    ImageStack(:,:,ii) = LPFImage;         
                end
            
                UnitImageStack = ImageStack;

                for ii = 1:NumCodesAll
                    load([MERFISHcodebookPath 'CodeMatrices\CodeMatrix' num2str(ii) '.mat']);
                    Dis = (sum((UnitImageStack-CodeMatrix).^2,3)).^0.5;
                    Ind = find(Dis<=1);

                    % now count the molecules
                    BW = zeros(ImageSize,ImageSize);
                    BW(Ind) = 1;
                    CC(ii) = bwconncomp(BW,8);
                    
                    Ind = find(Dis==0);
                    BW = zeros(ImageSize,ImageSize);
                    BW(Ind) = 1;
                    CC_perfect(ii) = bwconncomp(BW,8);
                end
                save(['MerfishResults' num2str(iii) '/CC_' num2str(jj) '_' num2str(kk) '.mat'],'CC');
                save(['MerfishResults' num2str(iii) '/CC_perfect_' num2str(jj) '_' num2str(kk) '.mat'],'CC_perfect');
            end
        end
    end
end




