% This files stores all default parameters for MERFISH, chromatin tracing,
% cell segmentation, lamina abstraction, and nucleolar abstraction
% analyses.

CommonFilePath = 'G:\Miao\190725\';
NFOV = 14; % Number of fields of views 
NumImage = 541; % Number of images in each dax 
ImageSize = 1536; % Number of pxls 
FramesToWait = 5; % Frames to wait at each z height for each channel 
MultiChannelZStackHeader = 'sequential/STORM2'; % Mutli channel z stack header 
Hyb0BeadImageHeader = 'sequential/STORM2_00_'; % File header that contains the hyb0 bead images 
TotalNumChannels = 3; % Total number of channels in the multi-channel z stack 
BeadChannelID = 3; % Channel ID in z stack for fiducial beads 
InitialLocalMaxThresh = 100; % Initial brightness threshold for bead identification 

% MERFISH specfic parameters
MERFISHcodebookPath = []; % Folder path of MERFISH codebook; empty means current folder.
RoundsOfHybs = 16;% Total number of MERFISH hybs 
MERFISHcodebook = 'CodeBook.mat'; % MERFISH codebook 
FramesToAverage = 15; % Frames to average for MERFISH analysis 
NumSteps = 11; % Number of z steps in MERFISH analysis. NumSteps*FramesToAverage is the total number of images analyzed 
ParameterRange = 2:7; % MERFISH analysis foci fitting parameter range 
WGAFileHeader = 'sequential/STORM2_31_'; % File header for cell boundary image (WGA labeling) drift correction 
WGAChannelID = 2; % Channel index in the composite z stack 

% Chromatin tracing specific parameters
NumImage_calib = 131; % Number of images of in the 561nm and 647nm fluorescence channel color shift calibration 
CalibFileHeader_561 = ['calib/movie_0001_561']; % 561nm channel file header for the color shift calibration 
CalibFileHeader_647 = ['calib/movie_0001_647']; % 647nm channel file header for the color shift calibration 
RoundsOfHybs_tracing = 40; % Number of secondary hybs in chromatin tracing 
InitialLocalMaxThresh_tracing = 50; % Initial brightness threshold for DNA foci identification 
MaxNumFociToFit = 500; % Maxium number of DNA foci to fit per FOV 
NumLoci = 50; % Number of traced genomic loci in chromatin tracing 
UmPerPxl = 0.108; % Pixel size in the unit of um 
StepSize = 0.2; % Z stack step size in the unit of um 
EstimatedTraceRadius = 2; %um, distance threshold between new focus and the average position of all previous identified foci in the trace 
TraceLengthThreshold = 10; % remove traces that are shorter than this length 

% Optional parameters for lamina and nucleolar abstractions 
IncludeNucleoliAnalysis = 1; % Whether to include nucleoar associaaiton analysis
IncludeLaminaAnalysis = 1; % Whether to include lamina associaaiton analysis
NuclearNumImage = 181; % Number of images in nuclear stack
NuclearBeadPath = 'sequential/STORM2_0_'; % Path of the bead images in the nuclear (DAPI) imaging round 
NuclearImagePath = 'sequential/Laser405_0_'; % Path of the nuclear (DAPI) images
AdaptiveThresholdingSensitivity = 0.5; % Adaptive thresholding sensitivity for nucleolar abstraction
NucleolarImageHeader = 'sequential/STORM2_00_'; % File header that contains the mucleolar images 
NucleolarChannelID = 1; % Channel ID in z stack for nucleolar labeling 

% The follwoing headers are the file headers for MERFISH images for each 
% bit of the 16-bit MERFISH barcode:
FileNameForBit{1} = 'sequential/STORM1_00_';
FileNameForBit{2} = 'sequential/STORM1_08_';
FileNameForBit{3} = 'sequential/STORM1_09_';
FileNameForBit{4} = 'sequential/STORM1_01_';
FileNameForBit{5} = 'sequential/STORM1_02_';
FileNameForBit{6} = 'sequential/STORM1_10_';
FileNameForBit{7} = 'sequential/STORM1_03_';
FileNameForBit{8} = 'sequential/STORM1_11_';
FileNameForBit{9} = 'sequential/STORM1_12_';
FileNameForBit{10} = 'sequential/STORM1_04_';
FileNameForBit{11} = 'sequential/STORM1_05_';
FileNameForBit{12} = 'sequential/STORM1_13_';
FileNameForBit{13} = 'sequential/STORM1_06_';
FileNameForBit{14} = 'sequential/STORM1_14_';
FileNameForBit{15} = 'sequential/STORM1_15_';
FileNameForBit{16} = 'sequential/STORM1_07_';

% The follwing headers are the file headers for chromatin tracing images
% for each traced genomic locus; also here we list the fluorescence channel 
% for each traced genomic locus:
FileNameForLocus{1} = 'sequential/STORM2_01_'; ChannelIDforLocus(1) = 1;
FileNameForLocus{2} = 'sequential/STORM2_02_'; ChannelIDforLocus(2) = 1;
FileNameForLocus{3} = 'sequential/STORM2_03_'; ChannelIDforLocus(3) = 1;
FileNameForLocus{4} = 'sequential/STORM2_04_'; ChannelIDforLocus(4) = 1;
FileNameForLocus{5} = 'sequential/STORM2_05_'; ChannelIDforLocus(5) = 1;
FileNameForLocus{6} = 'sequential/STORM2_06_'; ChannelIDforLocus(6) = 1;
FileNameForLocus{7} = 'sequential/STORM2_07_'; ChannelIDforLocus(7) = 1;
FileNameForLocus{8} = 'sequential/STORM2_08_'; ChannelIDforLocus(8) = 1;
FileNameForLocus{9} = 'sequential/STORM2_09_'; ChannelIDforLocus(9) = 1;
FileNameForLocus{10} = 'sequential/STORM2_10_'; ChannelIDforLocus(10) = 1;
FileNameForLocus{11} = 'sequential/STORM2_11_'; ChannelIDforLocus(11) = 1;
FileNameForLocus{12} = 'sequential/STORM2_12_'; ChannelIDforLocus(12) = 1;
FileNameForLocus{13} = 'sequential/STORM2_13_'; ChannelIDforLocus(13) = 1;
FileNameForLocus{14} = 'sequential/STORM2_14_'; ChannelIDforLocus(14) = 1;
FileNameForLocus{15} = 'sequential/STORM2_15_'; ChannelIDforLocus(15) = 1;
FileNameForLocus{16} = 'sequential/STORM2_16_'; ChannelIDforLocus(16) = 1;
FileNameForLocus{17} = 'sequential/STORM2_17_'; ChannelIDforLocus(17) = 1;
FileNameForLocus{18} = 'sequential/STORM2_18_'; ChannelIDforLocus(18) = 1;
FileNameForLocus{19} = 'sequential/STORM2_19_'; ChannelIDforLocus(19) = 1;
FileNameForLocus{20} = 'sequential/STORM2_20_'; ChannelIDforLocus(20) = 1;
FileNameForLocus{21} = 'sequential/STORM2_21_'; ChannelIDforLocus(21) = 1;
FileNameForLocus{22} = 'sequential/STORM2_22_'; ChannelIDforLocus(22) = 1;
FileNameForLocus{23} = 'sequential/STORM2_23_'; ChannelIDforLocus(23) = 1;
FileNameForLocus{24} = 'sequential/STORM2_24_'; ChannelIDforLocus(24) = 1;
FileNameForLocus{25} = 'sequential/STORM2_25_'; ChannelIDforLocus(25) = 1;
FileNameForLocus{26} = 'sequential/STORM2_26_'; ChannelIDforLocus(26) = 1;
FileNameForLocus{27} = 'sequential/STORM2_27_'; ChannelIDforLocus(27) = 1;
FileNameForLocus{28} = 'sequential/STORM2_28_'; ChannelIDforLocus(28) = 1;
FileNameForLocus{29} = 'sequential/STORM2_29_'; ChannelIDforLocus(29) = 1;
FileNameForLocus{30} = 'sequential/STORM2_30_'; ChannelIDforLocus(30) = 1;
FileNameForLocus{31} = 'sequential/STORM2_31_'; ChannelIDforLocus(31) = 1;
FileNameForLocus{32} = 'sequential/STORM2_32_'; ChannelIDforLocus(32) = 1;
FileNameForLocus{33} = 'sequential/STORM2_33_'; ChannelIDforLocus(33) = 1;
FileNameForLocus{34} = 'sequential/STORM2_34_'; ChannelIDforLocus(34) = 1;
FileNameForLocus{35} = 'sequential/STORM2_35_'; ChannelIDforLocus(35) = 1;
FileNameForLocus{36} = 'sequential/STORM2_36_'; ChannelIDforLocus(36) = 1;
FileNameForLocus{37} = 'sequential/STORM2_37_'; ChannelIDforLocus(37) = 1;
FileNameForLocus{38} = 'sequential/STORM2_38_'; ChannelIDforLocus(38) = 1;
FileNameForLocus{39} = 'sequential/STORM2_39_'; ChannelIDforLocus(39) = 1;
FileNameForLocus{40} = 'sequential/STORM2_40_'; ChannelIDforLocus(40) = 1;
FileNameForLocus{41} = 'sequential/STORM2_21_'; ChannelIDforLocus(41) = 2;
FileNameForLocus{42} = 'sequential/STORM2_22_'; ChannelIDforLocus(42) = 2;
FileNameForLocus{43} = 'sequential/STORM2_23_'; ChannelIDforLocus(43) = 2;
FileNameForLocus{44} = 'sequential/STORM2_24_'; ChannelIDforLocus(44) = 2;
FileNameForLocus{45} = 'sequential/STORM2_25_'; ChannelIDforLocus(45) = 2;
FileNameForLocus{46} = 'sequential/STORM2_26_'; ChannelIDforLocus(46) = 2;
FileNameForLocus{47} = 'sequential/STORM2_27_'; ChannelIDforLocus(47) = 2;
FileNameForLocus{48} = 'sequential/STORM2_28_'; ChannelIDforLocus(48) = 2;
FileNameForLocus{49} = 'sequential/STORM2_29_'; ChannelIDforLocus(49) = 2;
FileNameForLocus{50} = 'sequential/STORM2_30_'; ChannelIDforLocus(50) = 2;

% Add the common file path to the file headers:
MultiChannelZStackHeader = [CommonFilePath MultiChannelZStackHeader];
WGAFileHeader = [CommonFilePath WGAFileHeader];
CalibFileHeader_561 = [CommonFilePath CalibFileHeader_561];
CalibFileHeader_647 = [CommonFilePath CalibFileHeader_647];
Hyb0BeadImageHeader = [CommonFilePath Hyb0BeadImageHeader];
NuclearBeadPath = [CommonFilePath NuclearBeadPath];
NuclearImagePath = [CommonFilePath NuclearImagePath];
NucleolarImageHeader = [CommonFilePath NucleolarImageHeader];
for i = 1:RoundsOfHybs
    FileNameForBit{i} = [CommonFilePath FileNameForBit{i}];
end
for i = 1:NumLoci
    FileNameForLocus{i} = [CommonFilePath FileNameForLocus{i}];
end
