clear all
close all

TotalNumChannel=4;
FirstPath = 'AllRowImages';
SecPath = dir(FirstPath);
PixelSize = 0.103*0.103; %um*um


%
Number_AllConditions = [];
Size_AllConditions = [];

for iii = 3:length(SecPath)
    CurrFolder = SecPath(iii).name;
    AllImages = dir([FirstPath '/' CurrFolder]);
    
    Size1 = [];
    Size2 = [];
    Num1 = [];
    Num2 = [];
    for jj=3:length(AllImages)
        CurrImg = AllImages(jj).name;
        Words = split(CurrImg,'.');
        FileName = [FirstPath '/' CurrFolder '/' CurrImg];
        %%
        load(['ROI/' CurrFolder '/' Words{1} '.mat'])
        ROI_Idx = find(ImageROI);
        Out_Idx = find(ImageROI==0);
        N = length(ROI_Idx);
        
        %%
        % load RNA blocks
        load(['RNA/' CurrFolder '/RNA1_' Words{1} '.mat'])
        L_RNA1 = zeros(2048,2048);
        L_RNA1 = zeros(2048,2048);
        for k=1:max(max(L))
            CurrPixels = find(L==k);
%             if length(CurrPixels)<5000 && sum(ImageROI(CurrPixels))>0
            if length(CurrPixels)<5000 && numel(intersect(Out_Idx,CurrPixels))==0
                L_RNA1(CurrPixels)=1;
            end
        end
%         figure
%         imagesc(L_RNA1)
%         axis equal
%         colormap gray
        
        
        load(['RNA/' CurrFolder '/RNA2_' Words{1} '.mat'])
        L_RNA2 = zeros(2048,2048);
        for k=1:max(max(L))
            CurrPixels = find(L==k);
%             if length(CurrPixels)<5000 && sum(ImageROI(CurrPixels))>0
            if length(CurrPixels)<5000 && numel(intersect(Out_Idx,CurrPixels))==0
                L_RNA2(CurrPixels)=1;
            end
        end
        %%
        RNA1_CC = bwconncomp(L_RNA1);
        RNA1_CC = RNA1_CC.PixelIdxList;
        RNA2_CC = bwconncomp(L_RNA2);
        RNA2_CC = RNA2_CC.PixelIdxList;
        
        Num1 = [Num1 length(RNA1_CC)/(PixelSize*length(find(ImageROI)))];
        Num2 = [Num2 length(RNA2_CC)/(PixelSize*length(find(ImageROI)))];
        Size1 = [Size1 cellfun('length',RNA1_CC)];
        Size2 = [Size2 cellfun('length',RNA2_CC)];
    end
    
    Size_AllConditions(iii-2).Size1 = Size1;
    Size_AllConditions(iii-2).Size2 = Size2;
    Number_AllConditions{iii-2} = [Num1' Num2'];
end
save('RNASizeNumResults_230428.mat','Size_AllConditions','Number_AllConditions')
%%
% F_ALL = [];
% for i=1:length(F1_AllConditions)
%     F_ALL{i} = [F1_AllConditions{i}' F2_AllConditions{i}' F_Geo_AllConditions{i}'];
% end
% 
% figure
% boxplotGroup(F_ALL,'PrimaryLabels', {'L1.2' 'L1' 'h9','L2b'},...
%     'SecondaryLabels', {'F1(Dnah5)', 'F2(Others)', 'F Geo Mean'},...
%     'interGroupSpace',2)
% ylabel('Overlap Fraction')
% 
% % EXAMPLES:
% data = {rand(100,4), rand(20,4)*.8, rand(1000,4)*1.2};
% %
% % Required inputs
%   boxplotGroup(data)
clear all
load('RNASizeNumResults_230428.mat')

Numbers = [];
for i=1:2
    Temp = Number_AllConditions{1};
    Numbers = [Numbers Temp(:,i)];
end
for i=1:2
    Temp = Number_AllConditions{2};
    n = length(Temp(:,2));
    Numbers(1:n,i+2) = Temp(:,i);
end
writematrix(Numbers,'DataExport/RNA_Num_2D.csv')

clear Size
n=0;
Names = {'h5 Ctrl', 'h9 Ctrl', 'h5 Mph', 'h9 Mph'};
Temp = Size_AllConditions(1).Size1;
for i=1:length(Temp)
    n=n+1;
    Size(n).RNA = Names{1};
    Size(n).Size = Temp(i);
end
Temp = Size_AllConditions(1).Size2;
for i=1:length(Temp)
    n=n+1;
    Size(n).RNA = Names{2};
    Size(n).Size = Temp(i);
end
Temp = Size_AllConditions(2).Size1;
for i=1:length(Temp)
    n=n+1;
    Size(n).RNA = Names{3};
    Size(n).Size = Temp(i);
end
Temp = Size_AllConditions(2).Size2;
for i=1:length(Temp)
    n=n+1;
    Size(n).RNA = Names{4};
    Size(n).Size = Temp(i);
end
writetable(struct2table(Size), 'DataExport/RNA_Size_2D.csv')
%%
Num2Plot = {};
Numbers = [];
for i=1:4
    Temp = Number_AllConditions{i};
    Numbers = [Numbers; Temp(:,1)];
end
Num2Plot{1} = Numbers;
for i=1:4
    Temp = Number_AllConditions{i};
    Num2Plot{i+1} = Temp(:,2);
end

figure
boxplotGroup(Num2Plot,'PrimaryLabels', {'h5', 'L1.2' 'L1' 'h9','L2b'})
title('RNA density per um^2')

Num2Plot = {};
Numbers = [];
for i=1:4
    Temp = Number_AllConditions{i};
    Numbers = [Numbers; Temp(:,1)];
end
Num2Plot{1} = Numbers';
for i=1:4
    Temp = Number_AllConditions{i};
    Num2Plot{i+1} = Temp(:,2)';
end
Position = [1 2 3 4 5];
figure
n=0;
for i=1:5
    n=n+1;
    CurrVec = Num2Plot{i};
    CurrVec = rmoutliers(CurrVec);
    violins(n) = Violin(CurrVec, Position(n));
end
set(gca, 'xtick', [1 2 3 4 5],'xticklabels', {'h5', 'L1.2' 'L1' 'h9','L2b'});
title('RNA density per um^2')
% figure
% boxplotGroup(Number_AllConditions,'PrimaryLabels', {'h5+L1.2' 'h5+L1' 'h5+h9','h5+L2b'},...
%     'SecondaryLabels', {'Dnah5 number', 'Others number'},...
%     'interGroupSpace',1)
% ylim([0 0.003])
%%
Size2Plot = {};
Sizes = [];
for i=1:4
    Temp = Size_AllConditions(i).Size1;
    Sizes = [Sizes Temp];
end
Size2Plot{1} = Sizes;
for i=1:4
    Temp = Size_AllConditions(i).Size2;
    Size2Plot{i+1} = Temp;
end

Position = [1 2 3 4 5];
figure
n=0;
for i=1:5
    n=n+1;
    CurrVec = Size2Plot{i};
    CurrVec = rmoutliers(CurrVec);
    violins(n) = Violin(CurrVec, Position(n));
end
set(gca, 'xtick', [1 2 3 4 5],'xticklabels', {'h5', 'L1.2' 'L1' 'h9','L2b'});
title('RNA Size (um^2)')

% P_All = [];
% for i=2:4
%     x = rmoutliers(Size_AllConditions(1).Size1);
%     y = rmoutliers(Size_AllConditions(i).Size1);
%     [h,p] = ttest2(x,y);
%     P_All = [P_All p];
% end
% 
% [h,p] = ttest2(Size_AllConditions(2).Size2,Size_AllConditions(4).Size2)



Size2Plot = {};
Sizes = [];
for i=1:4
    Temp = Size_AllConditions(i).Size1;
    Sizes = [Sizes Temp];
end
Size2Plot{1} = rmoutliers(Sizes'*PixelSize);
for i=1:4
    Temp = Size_AllConditions(i).Size2;
    Size2Plot{i+1} = rmoutliers(Temp'*PixelSize);
end
figure
boxplotGroup(Size2Plot,'PrimaryLabels', {'h5', 'L1.2' 'L1' 'h9','L2b'})
title('RNA size (um^2)')





















