clear all
close all

TotalNumChannel=4;
FirstPath = 'AllRowImages';
SecPath = dir(FirstPath);

if ~exist('RNA')
    mkdir('RNA')
end
if ~exist('RNA_Images')
    mkdir('RNA_Images')
end
%%
for iii = 3:length(SecPath)
    CurrFolder = SecPath(iii).name;
    AllImages = dir([FirstPath '/' CurrFolder]);
    
    if ~exist(['RNA/' CurrFolder])
        mkdir(['RNA/' CurrFolder])
    end
    if ~exist(['RNA_Images/' CurrFolder])
        mkdir(['RNA_Images/' CurrFolder])
    end
    
    for jj=3:length(AllImages)
        CurrImg = AllImages(jj).name;
        Words = split(CurrImg,'.');
        FileName = [FirstPath '/' CurrFolder '/' CurrImg];
        %%
        for k=2:1 % 2 channel for each czi
            ImageStack = ReadCzi(FileName,4,k);
            Image1 = max(ImageStack,[],3);
%             figure(1)
%             imagesc(Image1)
%             axis equal
%             colormap gray
%             caxis([1 1000])
%             title('Original image')
            %%
            % get BW
            SIG = stdfilt(Image1,ones(3,3));
%             figure
%             imagesc(SIG)
%             axis equal
%             colormap gray
            
            SIG = SIG/max(max(SIG));
%             figure
%             imagesc(SIG)
%             axis equal
%             colormap gray
            
            SIG = imfill(SIG,8);
%             figure(800)
%             imagesc(SIG)
%             colormap gray
%             axis equal
            
            BW = im2bw(SIG, graythresh(SIG));
%             figure
%             imagesc(BW)
%             axis equal
%             colormap gray  
            
            se = strel('disk', 3);
            Iobrd = imdilate(BW, se);
            Iobrcbr = imreconstruct(imcomplement(Iobrd), imcomplement(BW));
            Iobrcbr = imcomplement(Iobrcbr);
%             figure
%             imagesc(Iobrcbr)
%             axis equal
%             colormap gray
%             title('Opening-closing by reconstruction (Iobrcbr)')
            
            se = strel('disk', 1);
            Ie = imerode(BW, se);
            Iobr = imreconstruct(Ie, BW);
            BW = Iobr;
            figure
            imagesc(Iobr)
            colormap gray
            axis equal
            title('Opening-by-reconstruction (Iobr)')
            
            figure
            imagesc(Image1)
            axis equal
            colormap gray
            caxis([100 1500])
            hold on
            visboundaries(BW,'Color','g','LineWidth',1)
            %%
            % get fgm
            Img2D = Image1;
%             figure
%             imagesc(Img2D)
%             axis equal
%             colormap gray
%             title('Original image')
            
            Img2D = medfilt2(Img2D);
            BG = adaptthresh(Img2D/max(max(Img2D)),'NeighborhoodSize',101);
            Img2D = Img2D./BG;
%             figure
%             imagesc(Img2D)
%             axis equal
%             colormap gray
            
            I = medfilt2(Img2D);
            BG = adaptthresh(Img2D/max(max(Img2D)),'NeighborhoodSize',21);
%             figure
%             imagesc(BG)
%             axis equal
%             colormap gray
            
            Img2D2 = Img2D/max(max(Img2D))./BG;
%             figure
%             imagesc(Img2D2)
%             axis equal
%             colormap gray
            
            Img2D3 = Img2D2/max(max(Img2D2));
            fgm = imextendedmax(Img2D3,0.03);
%             figure
%             imagesc(fgm)
%             axis equal
%             colormap gray
%             figure
%             imagesc(Image1)
%             axis equal
%             colormap gray
%             hold on
%             visboundaries(fgm,'Color','g','LineWidth',1)
            
            % get Iobrcbr
            Img2D = Image1;
            Img2D = medfilt2(Img2D);
            BG = adaptthresh(Img2D/max(max(Img2D)),'NeighborhoodSize',101);
            Img2D = Img2D./BG;
            Img2D = medfilt2(Img2D);
%             figure
%             imagesc(Img2D)
%             axis equal
%             colormap gray
                                 
            Iobrcbr = Img2D;
            Iobrcbr_c = imcomplement(Iobrcbr);
%             figure
%             imagesc(Iobrcbr_c)
%             axis equal
%             colormap gray
            
            I_mod = imimposemin(Iobrcbr_c, ~BW | fgm);
%             figure
%             imagesc(I_mod)
%             axis equal
%             colormap gray
            
            L = watershed(I_mod);
            L = imopen(L,strel('disk',2));
%             figure(111)
%             imshow(label2rgb(Label))
%             axis equal
        
            figure(10)
            f(1)=subplot(1,2,1);
            imagesc(Image1)
            axis equal
            colormap gray
            caxis([100 1500])

            LDisplay = zeros(2048,2048);
            LDisplay(find(L>1))=1;
            SE = strel('disk',1);
            LDisplay=imerode(LDisplay,SE);
            figure(10)
            f(2)=subplot(1,2,2);
            imagesc(LDisplay)
            axis equal
            colormap gray
            
            set(f(1),'position',[-0.2 0 1 1])
            set(f(2),'position',[0.2 0 1 1])
            %%
%             saveas(gcf, ['RNA_Images/' CurrFolder '/RNA' num2str(k) '_' Words{1} '.jpg'])
            savefig(['RNA_Images/' CurrFolder '/RNA' num2str(k) '_' Words{1} '.fig'])
            save(['RNA/' CurrFolder '/RNA' num2str(k) '_' Words{1} '.mat'],'L')
        end        
        close all
    end
end


% figure(110)
% imagesc(Image1)
% axis equal
% colormap gray
% hold on
% visboundaries(LDisplay,'Color','g','LineWidth',1)





































