clear all
close all

TotalNumChannel=4;
FirstPath = 'AllRowImages';
SecPath = dir(FirstPath);

%%
for iii = 3:length(SecPath)
    CurrFolder = SecPath(iii).name;
    AllImages = dir([FirstPath '/' CurrFolder]);
    
    
    for jj=3:length(AllImages)
        CurrImg = AllImages(jj).name;
        FileName = [FirstPath '/' CurrFolder '/' CurrImg];
        
        %%
        % analysis area selection
        ImageStack = ReadCzi(FileName,4,3);
        Image1 = max(ImageStack,[],3);
        
        Words = split(CurrImg,'.');
        Img1 = imread(['ROI_Images/' CurrFolder '/Img2_' Words{1} '.jpg']);
        figure(1)
        subplot(1,2,1)
        image(Img1)
        hold on
        
        load(['ROI/' CurrFolder '/' Words{1} '.mat'])
        figure(1)
        subplot(1,2,2)
        imagesc(ImageROI)
        colormap gray
        axis square
        %%
        % select bad cells
        clear roiList
        NewROI = questdlg('Do you want to select regions?'); %ask question
        if(strcmp(NewROI, 'Yes'))
            selectROI
            
            
            CropPixelList = {};
            for i = 1:length(roiList)
                roiNOW = roiList(i);
                x1 = round(roiNOW.rect(1));
                x2 = round(roiNOW.rect(1)+roiNOW.rect(3));
                y1 = round(roiNOW.rect(2));
                y2 = round(roiNOW.rect(2)+roiNOW.rect(4));
                CurrPixelList = [];
                for x = x1:x2
                    for y = y1:y2
                        CurrPixel = 2048*(x-1)+y;
                        CurrPixelList = [CurrPixelList CurrPixel];
                    end
                end
                CropPixelList{i} = CurrPixelList;
            end
            
            ImageROI_new = zeros(2048,2048);
            CC = bwconncomp(ImageROI);
            PixelList = CC.PixelIdxList;
            for i = 1:length(CropPixelList)
                CurrPixelList = CropPixelList{i};
                for j = 1:length(PixelList)
                    Curr_PixelList = PixelList{j};
                    OverlapNum = length(intersect(CurrPixelList,Curr_PixelList));
                    if OverlapNum>0
                        ImageROI_new(Curr_PixelList) = 1;
                        continue
                    end
                end
            end
            
            ImageROI = ImageROI_new;            
            figure(2)
            imagesc(Image1)
            axis equal
            colormap gray
            hold on
            visboundaries(ImageROI,'Color','g','LineWidth',1)
            saveas(gcf, ['ROI_Images/' CurrFolder '/FinalROI_' Words{1} '.jpg'])
            save(['ROI/' CurrFolder '/' Words{1} '.mat'],'ImageROI')
            
        end
    end  
end








































