clear all
close all

TotalNumChannel=4;
FirstPath = 'AllRowImages';
SecPath = dir(FirstPath);

if ~exist('ROI')
    mkdir('ROI')
end
if ~exist('ROI_Images')
    mkdir('ROI_Images')
end
%%
for iii = 3:length(SecPath)
    CurrFolder = SecPath(iii).name;
    AllImages = dir([FirstPath '/' CurrFolder]);
    
    if ~exist(['ROI/' CurrFolder])
        mkdir(['ROI/' CurrFolder])
    end
    if ~exist(['ROI_Images/' CurrFolder])
        mkdir(['ROI_Images/' CurrFolder])
    end
    
    for jj=3:length(AllImages)
        CurrImg = AllImages(jj).name;
        FileName = [FirstPath '/' CurrFolder '/' CurrImg];
        
        %%
        % analysis area selection
%         ImageStack = ReadCzi(FileName,4,3);
%         Image1 = max(ImageStack,[],3);
        ImageStack = ReadCzi(FileName,4,1);
        Image1 = mean(ImageStack,3);
        ImageStack = ReadCzi(FileName,4,2);
        Image2 = mean(ImageStack,3);
%         figure
%         imagesc(Image1+Image2)
%         axis equal
%         colormap gray
%         caxis([100 1000])
%         title('Original image')
        %%
        Img2D = Image1+Image2;
        se = strel('disk',15);
        Img2D_original = imopen(Img2D,se);
%         figure
%         imagesc(Img2D_original)
%         axis equal
%         colormap gray
%         title('Background')
        
        ImgDAPI_original = medfilt2(Img2D);
        I_eq = ImgDAPI_original;
        I_eq = I_eq/max(max(I_eq));
%         figure
%         imagesc(I_eq)
%         axis equal
%         colormap gray
%         title('DAPI image (contrast adjusted)')
        
        % Erosion then reconstruction, this is to remove the small patches of
        % signals. By reconstruction, we are highlighting those eroded regions.
        se = strel('disk', 5);
        Ie = imerode(I_eq, se);
        Iobr = imreconstruct(Ie, I_eq);
%         figure
%         imagesc(Iobr)
%         colormap gray
%         axis equal
%         title('Opening-by-reconstruction (Iobr)')
        
        % Dilation then reconstruction, this is to remove the small patches of
        % black holes
        Iobrd = imdilate(Iobr, se);
        Iobrcbr = imreconstruct(imcomplement(Iobrd), imcomplement(Iobr));
        Iobrcbr = imcomplement(Iobrcbr);
%         figure
%         imagesc(Iobrcbr)
%         axis equal
%         colormap gray
%         title('Opening-closing by reconstruction (Iobrcbr)')
        
        % get BW
        SIG = stdfilt(Iobrcbr,ones(5,5));
%         figure
%         imagesc(SIG)
%         axis equal
%         colormap gray
        
        SIG = SIG/max(max(SIG));
%         figure
%         imagesc(SIG)
%         axis equal
%         colormap gray
        
        SIG = imfill(SIG,8);
%         figure(800)
%         imagesc(SIG)
%         colormap gray
%         axis equal
        
        BW = im2bw(SIG, graythresh(SIG));
%         figure
%         imagesc(BW)
%         axis equal
%         colormap gray
        
        se = strel('disk',7);
        BW_c = imclose(BW,se);
%         figure
%         imagesc(BW_c)
%         axis equal
%         colormap gray
        BW_co = imopen(BW_c,se);
%         figure
%         imagesc(BW_co)
%         axis equal
%         colormap gray
        
        Contour = activecontour(Img2D, BW_co,150);
%         figure
%         imagesc(Contour)
%         axis equal
%         colormap gray
        
        
        se = strel('disk', 60);
        ImageROI = imdilate(Contour,se);
        ImageROI = imfill(ImageROI,'holes');
        ImageROI = imerode(ImageROI,strel('disk',30));
%         figure
%         imagesc(ImageROI)
%         axis equal
%         colormap gray
        
        figure
        imagesc(Img2D)
        axis equal
        colormap gray
        hold on
        visboundaries(ImageROI,'Color','g','LineWidth',1)
        
        Words = split(CurrImg,'.');
        saveas(gcf, ['ROI_Images/' CurrFolder '/Img1_' Words{1} '.jpg'])
        save(['ROI/' CurrFolder '/' Words{1} '.mat'],'ImageROI')
        %%
%         ImageStack = ReadCzi(FileName,4,1);
%         RNAImage1 = max(ImageStack,[],3);
%         ImageStack = ReadCzi(FileName,4,2);
%         RNAImage2 = max(ImageStack,[],3);
        ImageStack = ReadCzi(FileName,4,3);
        AbImage = max(ImageStack,[],3);
        
        RGB = zeros(2048,2048,3);
        RGB(:,:,1) = Image1/max(max(Image1));
        RGB(:,:,2) = Image2/max(max(Image2));
        RGB(:,:,3) = AbImage/max(max(AbImage));
        figure
        imagesc(RGB);
        axis equal
        hold on
        visboundaries(ImageROI,'Color','c','LineWidth',1)
        
        saveas(gcf, ['ROI_Images/' CurrFolder '/Img2_' Words{1} '.jpg'])
        
        close all
    end
    
end








































