clear all
close all

TotalNumChannel=4;
FirstPath = 'AllRowImages';
SecPath = dir(FirstPath);


%%
iii = 5
CurrFolder = SecPath(iii).name;
AllImages = dir([FirstPath '/' CurrFolder]);


jj=4
CurrImg = AllImages(jj).name;
Words = split(CurrImg,'.');
FileName = [FirstPath '/' CurrFolder '/' CurrImg];
%%
ImageStack = ReadCzi(FileName,4,1);
ImgRNA1 = max(ImageStack,[],3);
ImageStack = ReadCzi(FileName,4,2);
ImgRNA2 = max(ImageStack,[],3);

CropRegion = [931 1230; 301 600];

Img_R1_Crop = ImgRNA1(CropRegion(1,1):CropRegion(1,2),CropRegion(2,1):CropRegion(2,2));
Img_R2_Crop = ImgRNA2(CropRegion(1,1):CropRegion(1,2),CropRegion(2,1):CropRegion(2,2));

J = uint16(Img_R1_Crop);
imwrite(J,'SlidesImgs/Img_R1_Crop.tiff')
J = uint16(Img_R2_Crop);
imwrite(J,'SlidesImgs/Img_R2_Crop.tiff')




%%
load(['ROI/' CurrFolder '/' Words{1} '.mat'])
ROI_Idx = find(ImageROI);
Out_Idx = find(ImageROI==0);
N = length(ROI_Idx);

load(['RNA/' CurrFolder '/RNA1_' Words{1} '.mat'])
L_RNA1 = zeros(2048,2048);
for k=1:max(max(L))
    CurrPixels = find(L==k);
    if length(CurrPixels)<5000 && numel(intersect(Out_Idx,CurrPixels))==0
        L_RNA1(CurrPixels)=1;
    end
end
SE = strel('disk',1);
L_RNA1=imerode(L_RNA1,SE);

load(['RNA/' CurrFolder '/RNA2_' Words{1} '.mat'])
L_RNA2 = zeros(2048,2048);
for k=1:max(max(L))
    CurrPixels = find(L==k);
    if length(CurrPixels)<5000 && numel(intersect(Out_Idx,CurrPixels))==0
        L_RNA2(CurrPixels)=1;
    end
end
SE = strel('disk',1);
L_RNA2=imerode(L_RNA2,SE);



Img_S1_Crop = L_RNA1(CropRegion(1,1):CropRegion(1,2),CropRegion(2,1):CropRegion(2,2));
Img_S2_Crop = L_RNA2(CropRegion(1,1):CropRegion(1,2),CropRegion(2,1):CropRegion(2,2));
imwrite(Img_S1_Crop,'SlidesImgs/Img_S1_Crop.tiff')
imwrite(Img_S2_Crop,'SlidesImgs/Img_S2_Crop.tiff')


J = uint16(Img_S1_Crop);
imwrite(J,'SlidesImgs/Img_S1_Crop.tiff')
J = uint16(Img_S2_Crop);
imwrite(J,'SlidesImgs/Img_S2_Crop.tiff')







































