clear all
close all

%% check final output oligo number
File = readcell('Final_Oligos.xlsx','FileType','spreadsheet');
Final = File(:,2);
display(['number of oligos = ' num2str(length(Final))])
n = 0;
for i = 1:length(Final)
    if strlength(Final{i}) == 150
        n = n+1;
    end
end
display(['number of oligos that are 150 base long = ' num2str(n)])

%% check final output primer usage

Universal{1} = 'GTGGTAAAGCTCCGCGGCTT';%ab20_423
Universal{2} = 'GATTGGTCAATGCGGAACGA';%ab20_433

Universal{3} = 'CCCGCGTTAACCATACACCG';%ab20_583
Universal{4} = 'GGTAGCCACACGCTTCGATG';%ab20_858

Universal{5} = 'GCGTCGTTATGGTGCAACGT'; %ab20_135
Universal{6} = 'CGACACCGAACGTGCGACAA'; %ab20_34

Universal{7} = 'ATTATTGGTCGACGCCGCGA'; %ab20_315
Universal{8} = 'CTTGCGAGATTACGCGGCAC'; %ab20_314

Universal{9} = 'CAATCGACTGCGAGGTACGG';%ab20_29085
Universal{10} = 'GCGAACGGAATCACGGACGT';%ab20_29124

Universal{11} = 'TAGGCATGCGAGCGACGGTT'; %ab20_29183
Universal{12} = 'AGGGCATCGTTACGCGGCAA'; %ab20_29231

Universal{13} = 'TGGATACGCCAGTCGGCCTT'; %ab20_29285
Universal{14} = 'GTCAATCGAAGTGTTGCGCA'; %ab20_29324

Universal_l{15} = 'TCTCGTCACCGATAGCGGAG'; %ab20_2133
Universal_r{16} = 'GTCGTAGCGCACAACTCGCT'; %ab20_2993

Universal_l{17} = 'GACAGATACCGCGCCGCTCC'; %ab20_3663
Universal_r{18} = 'ATTTCGCGTCGGTCTGAGGC'; %ab20_3800

Universal_l{19} = 'GACAATTTCGCGTGACGTCA'; %ab20_1063
Universal_r{20} = 'ATCTGCCTAGCGACGATGGC'; %ab20_1095

Universal_l{21} = 'CCGCATGCGAAGTCCCGATA'; %ab20_5291
Universal_r{22} = 'CTCGCCGAGACGGACTTCTC'; %ab20_2257


for i = 1:length(Universal)
    N = 0;
    for j = 1:length(Final)
        N = N+length(strfind(Final{j}, Universal{i}));
    end
    display(['Primer' num2str(i) ' found ' num2str(N) ' times']);
end
        
%% check final output secondary usage
Secondary{1} = 'CGCAACGCTTGGGACGGTTCCAATCGGATC'; %B01
Secondary{2} = 'CGAATGCTCTGGCCTCGAACGAACGATAGC'; %B02
Secondary{3} = 'ACAAATCCGACCAGATCGGACGATCATGGG'; %B03
Secondary{4} = 'CAAGTATGCAGCGCGATTGACCGTCTCGTT'; %B04
Secondary{5} = 'AAGTCGTACGCCGATGCGCAGCAATTCACT'; %B06
Secondary{6} = 'CGAAACATCGGCCACGGTCCCGTTGAACTT'; %B07
Secondary{7} = 'ACGAATCCACCGTCCAGCGCGTCAAACAGA'; %B08
Secondary{8} = 'CGCGAAATCCCCGTAACGAGCGTCCCTTGC'; %B09
Secondary{9} = 'GCATGAGTTGCCTGGCGTTGCGACGACTAA'; %B10
Secondary{10} = 'CCGTCGTCTCCGGTCCACCGTTGCGCTTAC'; %B11
Secondary{11} = 'GGCCAATGGCCCAGGTCCGTCACGCAATTT'; %B12
Secondary{12} = 'TTGATCGAATCGGAGCGTAGCGGAATCTGC'; %B13
Secondary{13} = 'CGCGCGGATCCGCTTGTCGGGAACGGATAC'; %B14
Secondary{14} = 'GCCTCGATTACGACGGATGTAATTCGGCCG'; %B15
Secondary{15} = 'GCCCGTATTCCCGCTTGCGAGTAGGGCAAT'; %B16
Secondary{16} = 'GCGGGAAGCACGTGGATTAGGGCATCGACC'; %B17
Secondary{17} = 'ATTTGCGTGCCGTGCTAGCCGTTGTTATGG'; %B18
Secondary{18} = 'AGGGTCATCGCCGTAAGGTGGGACCGAGGG'; %B16b
Secondary{19} = 'TTGTGTATCCCGCCGGATCTTTGAATCAAC'; %B17b
Secondary{20} = 'TGCTAGTTCGATCGCGCAATTGCGTAGTTC'; %B18b
Secondary{21} = 'GGACACGGGATCGACGGTAGTGGATCGATT'; %B19
Secondary{22} = 'CGACCTTAGGTTCCGCGTCATGTACCGGTT'; %B20
Secondary{23} = 'TGTTTACGACGTGGGCTGCTGCGATTTCAC'; %B21
Secondary{24} = 'GGGAAACGGTTGTCGCTACCGGCTTTGCTA'; %B22
Secondary{25} = 'GATGGTCGACTGGCGGTCTTAATATGCCCA'; %B23
Secondary{26} = 'ATCCATATGACCGGCGGCCTTTTCTCGGAC'; %B24
Secondary{27} = 'ATGATCCACGACCGAGCAGGTTAGTTGACG'; %B25
Secondary{28} = 'TAGACGCACCACGCTCGACAAGAACAGGAC'; %B26
Secondary{29} = 'ACTCGTTTAACGGCCGGTTGGTCTACGGAT'; %B27
Secondary{30} = 'GGGTACTCGCGTCTGGAACGACGGATTCAG'; %B28
Secondary{31} = 'AACATCGGATCGGTGCGGTGGGATGGATAA'; %B29
Secondary{32} = 'AGACGACGCACGTTCGTACCGCGTACTTCG'; %B30
Secondary{33} = 'TTTGCTCGCAAGTGCGCACGAGTTGAACTG'; %B31
Secondary{34} = 'CCAATGTACCTCGCCGCGTTTAGACGGGCT'; %B32
Secondary{35} = 'AGTTTCCATACGCGGCGTGAATATCGCGGC'; %B33
Secondary{36} = 'GCTACAGCGTTACGGGCCCAGACGTTTCAT'; %B34
Secondary{37} = 'TTTATCGTGCGTGTCCGCCAGTACCGTGAG'; %B35
Secondary{38} = 'TTAGGTCCGGCGATTAGCGCTCGTGCGCGA'; %B33b
Secondary{39} = 'CGTGCGGGAACCGTATCCCTGGCGCGGACT'; %B34b
Secondary{40} = 'AATCCGGCGTACGTAAGGCAGCTTGCGTTA'; %B35b
Secondary{41} = 'GGGCGTATAACCGTCGCCACGCGGACGCAA'; %B36
Secondary{42} = 'GCGGGATTCGTACGAGCCCTCTTGGACGGG'; %B37
Secondary{43} = 'AGAAGATCGCACGCGCCTTTTACTTAATCG'; %B38
Secondary{44} = 'CTTTGTTCGGCTCGGAGCGTTACTGCGGGC'; %B39
Secondary{45} = 'TAATTCCGGTATCGGGCCCTTTTGTCTGAC'; %B40
Secondary{46} = 'CGTGAGAATGCGTCGCGATACTGGTGTAAG'; %B41
Secondary{47} = 'ATCGGAACGGTGACTCGGCTCAGTCGCGGC'; %B42
Secondary{48} = 'TCTCATGGTCGCCGGACCGTGATGCCGTGT'; %B43
Secondary{49} = 'TTACGAAGGTCGGCGTCGGTAGGCCTTCGC'; %B44
Secondary{50} = 'GCCATGGTACGACGGCAAGAGAGCGTGCGT'; %B45
Secondary{51} = 'CGGATTGGTCGTCCCGGAAGCACGGGCGAC'; %B46
Secondary{52} = 'GCACCGGTCGGGATTCCGTAGGCACGCCGA'; %B47
Secondary{53} = 'ACACCCGATACGTCGTGGGACGTGGACCGT'; %B48
Secondary{54} = 'CGACGATGATCGCAATCGGAGAACTACACC'; %B49
Secondary{55} = 'CTTTACGCGGATCGCCTCAATAAAGGCGAC'; %B50
Secondary{56} = 'TGACATCGATAAGCGGGCGCACCCGCGCGC'; %B51
Secondary{57} = 'GATCGACCGGCGTAGCTCACCCGGTTAGCG'; %B52
Secondary{58} = 'GGCGGGACACCGTATGAGGACGCGTCAATG'; %B53
Secondary{59} = 'GGGCGACGGGACTCTATCGGCATGGAGGTA'; %B54
Secondary{60} = 'AGTCTGGGTCGTCCGTAGGCAAAGGGTCCG'; %B55 
Secondary{61} = 'GAGCTATTGCGTCGACGGAAGTGCGTACCG'; %used to label WGA
Secondary{62} = 'TGATTTCGCGTGGAGGCGTCGGTTAGCAAC';
Secondary{63} = 'AAGATTATTGTCGCGCCGGGGACTATCGGC';
Secondary{64} = 'AGGAAACGGCGCGAACTGAGAGTATGGTTA';
Secondary{65} = 'AGAATGGTTGCGCACGATCATTTCGTCGTA';
Secondary{66} = 'TCGGCAATGTAGCGTCTCGTGGTCAATAAT';
Secondary{67} = 'AAGCGGTCCCGTCCGAGGTATAATGTCGGC';
Secondary{68} = 'GTGCGATGCTAAACGCTGCATGTGAATGCG';
Secondary{69} = 'GATCGTTCACCGCGCGTTGAGCGTGAACTA';
Secondary{70} = 'GTAGAGACGACGCGCATCCGGAGATACGCG';
Secondary{71} = 'CTTAGTACGCGGCGGTCGTGAATCGCGATG';
Secondary{72} = 'TTCGGATACCGCCACCGTCCTAAGCGAATA';
Secondary{73} = 'GCAAATCGTGTCTCGCCTTGAGCGTACTGA';
Secondary{74} = 'ATAAGACTCGCCCGATGCCCTATTCGCGGT';
Secondary{75} = 'GTGGTCGCTTCGACCCTTCATGATACCGGA';
Secondary{76} = 'GGGTTCAACGTCCGACGGTTCAGTGCCGGT';
Secondary{77} = 'TGGACTTAACCGCGAAGGGCCAACGACGAC';
Secondary{78} = 'CTCAGTTTGGCGCGTCGACTGTCACATATG';
Secondary{79} = 'CGGTACATTGCCGCGTTAGCCATTCTAGCT';
Secondary{80} = 'GAGCTGTCTTGCGGCGCTATGTAGTACGAG';
Secondary{81} = 'AAGCCGAGGTATGCCGAATGGATTGCCGTC';
Secondary{82} = 'GACGGTTCGTGGCGCCTAGAACTGACACGT';
Secondary{83} = 'GGAAGGGTCGTCACGTTCGAATTCACCGCA';
Secondary{84} = 'TGGCTTAGTGACCGCGGGATTTACGGGACG';
Secondary{85} = 'CTAAGTCCGCCCGACACGTGCATAACCGGC';
Secondary{86} = 'CGTGTTTAATCGCGCGACAGCGTCGCGTTC'; 
Secondary{87} = 'TAGCGCTCCGGGAATTCGAGTATTGCGTCT';
Secondary{88} = 'TGCCGTATAGACGCCGGCTTTTCCTATGCG';
Secondary{89} = 'CGCGTTCTAACGACCTCGCTTGTAAACTCG';
Secondary{90} = 'CGAAGCGGTGCGAGCTTCAGTTAGTGGCAC';
Secondary{91} = 'AGGAATGCGCATCGTGCTTGGCGCTTCGGT';
for i = 1:length(Secondary)
    N = 0;
    for j = 1:length(Final)
        N = N+length(strfind(Final{j}, Secondary{i}));
    end
    display(['Secondary ' num2str(i) ' found ' num2str(N) ' times']);
end
clear Secondary

%% check final output 20nt secondary usage
Secondary{1} = 'ATCCTCCTTCAATACATCCC'; %FB1
Secondary{2} = 'ACACTACCACCATTTCCTAT'; %FB2
Secondary{3} = 'ACTCCACTACTACTCACTCT'; %FB3
Secondary{4} = 'ACCCTCTAACTTCCATCACA'; %FB4
Secondary{5} = 'ACCACAACCCATTCCTTTCA'; %FB5
Secondary{6} = 'TTTCTACCACTAATCAACCC'; %FB6
Secondary{7} = 'ACCCTTTACAAACACACCCT'; %FB7
Secondary{8} = 'TCCTATTCTCAACCTAACCT'; %FB8
Secondary{9} = 'TATCCTTCAATCCCTCCACA'; %FB9
Secondary{10} = 'ACATTACACCTCATTCTCCC'; %FB10
Secondary{11} = 'TTTACTCCCTACACCTCCAA'; %FB11
Secondary{12} = 'TTCTCCCTCTATCAACTCTA'; %FB12
Secondary{13} = 'ACCCTTACTACTACATCATC'; %FB13
Secondary{14} = 'TCCTAACAACCAACTACTCC'; %FB14
Secondary{15} = 'TCTATCATTACCCTCCTCCT'; %FB15
Secondary{16} = 'TATTCACCTTACAAACCCTC'; %FB16

Secondary{17} = 'AAACACACACTAAACCACCC'; %FB17
Secondary{18} = 'AACTCATCTCAATCCTCCCA'; %FB18
Secondary{19} = 'TATCTCATCAATCCCACACT'; %FB19
Secondary{20} = 'TCTATCATCTCCAAACCACA'; %FB20

for i = 1:length(Secondary)
    N = 0;
    for j = 1:length(Final)
        N = N+length(strfind(Final{j}, Secondary{i}));
    end
    display(['20nt Secondary ' num2str(i) ' found ' num2str(N) ' times']);
end

