clear all
close all


Universal_l = 'ATTATTGGTCGACGCCGCGA'; %ab20_315
Universal_r = 'CTTGCGAGATTACGCGGCAC'; %ab20_314

Secondary{1} = 'ATCCTCCTTCAATACATCCC'; %FB1
Secondary{2} = 'ACACTACCACCATTTCCTAT'; %FB2
Secondary{3} = 'ACTCCACTACTACTCACTCT'; %FB3
Secondary{4} = 'ACCCTCTAACTTCCATCACA'; %FB4
Secondary{5} = 'ACCACAACCCATTCCTTTCA'; %FB5
Secondary{6} = 'TTTCTACCACTAATCAACCC'; %FB6
Secondary{7} = 'ACCCTTTACAAACACACCCT'; %FB7
Secondary{8} = 'TCCTATTCTCAACCTAACCT'; %FB8
Secondary{9} = 'TATCCTTCAATCCCTCCACA'; %FB9
Secondary{10} = 'ACATTACACCTCATTCTCCC'; %FB10
Secondary{11} = 'TTTACTCCCTACACCTCCAA'; %FB11
Secondary{12} = 'TTCTCCCTCTATCAACTCTA'; %FB12
Secondary{13} = 'ACCCTTACTACTACATCATC'; %FB13
Secondary{14} = 'TCCTAACAACCAACTACTCC'; %FB14
Secondary{15} = 'TCTATCATTACCCTCCTCCT'; %FB15
Secondary{16} = 'TATTCACCTTACAAACCCTC'; %FB16
Secondary{17} = 'AAACACACACTAAACCACCC'; %FB17
Secondary{18} = 'AACTCATCTCAATCCTCCCA'; %FB18
Secondary{19} = 'TATCTCATCAATCCCACACT'; %FB19
Secondary{20} = 'TCTATCATCTCCAAACCACA'; %FB20

[Head_C75, Seq_C75] = fastaread('Matched_Oligos_After_Blast_C57_Dio3_downstream_111000001_112000000.fasta');
[Head_CAST, Seq_CAST] = fastaread('Matched_Oligos_After_Blast_CAST_Dio3_downstream_111000001_112000000.fasta');
Final_Oligo_C75 = {};
Final_Oligo_CAST = {};
Final_Head_C75 = {};
Final_Head_CAST = {};

n = 0;
for i = 1:length(Head_C75)
        n = n+1;
        Final_Oligo_C75{i} =[Universal_l Secondary{7} Secondary{7} Seq_C75{i} Secondary{7} Secondary{7} Universal_r];
        Final_Head_C75{i} = [Head_C75{i} '_C75'];
        Final_Oligo_CAST{i} =[Universal_l Secondary{8} Secondary{8} Seq_CAST{i} Secondary{8} Secondary{8} Universal_r];
        Final_Head_CAST{i} = [Head_CAST{i} '_CAST'];
end


fastawrite('Final_Oligos_C57_Dio3_downstream_111000001_112000000_FB7.fasta', Final_Head_C75, Final_Oligo_C75);
fastawrite('Final_Oligos_CAST_Dio3_downstream_111000001_112000000_FB8.fasta', Final_Head_CAST, Final_Oligo_CAST);

AllOligosToOrder.Sequence = [Final_Oligo_C75 Final_Oligo_CAST];
AllOligosToOrder.Header = [Final_Head_C75 Final_Head_CAST];


for kk=1:length(AllOligosToOrder.Sequence)
    B{kk,1}=AllOligosToOrder.Header{kk};
    B{kk,2}=AllOligosToOrder.Sequence{kk};
end

writecell(B,'Final_Oligos_Dio3_downstream_111000001_112000000_C57FB7_CASTFB8_315314.xls','UseExcel',true)


