clear all
close all

%% OligoArrayOutputFile = 'oligos1.txt';
GenomeBLASTDatabase = 'C:\Users\WangLab\Desktop\09132023_200Loci_New\hg19';

%% BLAST against genome
Score_Cutoff = 39;
oligoFile = 'FinalOligo_Last_Blast_Input.fasta';
oligoPool = fastaread(oligoFile);
out = 'GoodProbe_BLASTGenome_Short_LAST.txt';
system(['blastn -query ' oligoFile ' -task blastn-short -db ' GenomeBLASTDatabase ' -out ' out ' -outfmt 10 -max_target_seqs 3 -num_threads 12']);



Blast_File = readtable(out);

[OligoList,ia1,ic1] = unique(Blast_File.Var1,'stable');
Bad_Oligo_Index = [];
Counter = 0;
for i = 1:length(OligoList)
 
    Sub_Blast_File = Blast_File(ic1==i,:);
    Sub_Blast_File_Sorted = Sub_Blast_File(Sub_Blast_File.Var12>Score_Cutoff,:);
       
    if size(Sub_Blast_File_Sorted,1) > 1
        Bad_Oligo_Index = [Bad_Oligo_Index i];
    else
        continue
    end
 
end

OligosInitial_Table = struct2table(oligoPool);
NO_Hit_Index = matches(OligosInitial_Table.Header,OligoList);
Oligos_WO_No_Hit = oligoPool(NO_Hit_Index);


BadOligoList = OligoList(Bad_Oligo_Index);
OligosInitial_Table = struct2table(Oligos_WO_No_Hit);
BadOligoGenome_Index = matches(OligosInitial_Table.Header,BadOligoList);


BadOligoGenome = Oligos_WO_No_Hit(BadOligoGenome_Index);
Oligos_WO_No_Hit_Copy = Oligos_WO_No_Hit;
Oligos_WO_No_Hit(BadOligoGenome_Index) = [];
GoodOligoGenome = Oligos_WO_No_Hit;




 
if exist('GoodProbes_BLASTGen_Short_NewRegions_12052023Updated.fasta')
     delete('GoodProbes_BLASTGen_Short_NewRegions_12052023Updated.fasta');
end
 fastawrite('GoodProbes_BLASTGen_Short_NewRegions_12052023Updated.fasta', GoodOligoGenome);

save('GoodProbes_BLASTGen_Short_NewRegions_12052023Updated.mat','GoodOligoGenome');

