clear all
close all

load('FinalOligo_CombinedRegions_4Mbp_12032023Updated.mat')
FinalOligo = Combined_Oligo_Pool;
Master = readtable('Final_Table_CodeArranged_Combined_4Mbp_12032023Updated.xls');
SecondaryTable = readtable('AdapterBindingSequences.xlsx');
Secondary = SecondaryTable.Sequence;

[ProbeList1,ia1, ic1] = unique({FinalOligo.GeneShortName},'stable');

Universal_l = 'GTGGTAAAGCTCCGCGGCTT';%ab20_423
Universal_r = 'GATTGGTCAATGCGGAACGA';%ab20_433

OS10 = 'CCGTCGTCTCCGGTCCACCGTTGCGCTTAC';

Secondary_Used = [Secondary(1:18);Secondary(25:42)];
save('Secondary_Used.mat', 'Secondary_Used');


AllOligosToOrder = [];
n = 0;
for i = 1:length(ProbeList1)
        n = n+1;
        TF = matches(Master.GeneName,ProbeList1{i});
        OneBits = findstr(cell2mat(Master(TF,:).Code), '1');
        NumProbesPerGene = length(find(ic1==i));
        FinalOligo_Temp = FinalOligo(ic1==i);
        for j = 1:NumProbesPerGene
            
                OligosToOrder(j).Header = FinalOligo_Temp(j).Header;
                OligosToOrder(j).Sequence = [Universal_l  Secondary_Used{OneBits(2)} FinalOligo_Temp(j).Sequence ...
                     Secondary_Used{OneBits(1)} OS10 Universal_r];
            
       end
        AllOligosToOrder = [AllOligosToOrder OligosToOrder];
        clear OligosToOrder
end

 fastawrite('Final_Probe_NewRegions_34bits_423_433_12032023Updated.fasta', AllOligosToOrder);
 
 for kk=1:length(AllOligosToOrder)
     B{kk,1}=AllOligosToOrder(kk).Header;
     B{kk,2}=AllOligosToOrder(kk).Sequence;
 end
 
 writecell(B,'Final_Probe__NewRegions_34bits_423_433_12032023Updated.xlsx','UseExcel',true)


