clear all
close all

load('MH2_2in36.mat');
Master = readtable('Final_Table_CodeArranged_4Mbp_12052023Updated_FinalCodeCorrected.xls');
Bit_Usage = zeros(36,1);
Used_codes = Master.Code;

[Unique_Code,ia1_code, ic1_code] = unique(Codes,'stable');
[Unique_Code_used,ia1_code_used, ic1_code_used] = unique(Used_codes,'stable');

display(['Total ' num2str(length(Unique_Code_used)) ' unique codes']);
Counter = 0;

for i = 1: length(Unique_Code_used)
    
    TF = matches(Codes,Unique_Code_used(i));
    Counter = Counter + length(find(TF==1));
    
end


display(['Total ' num2str(Counter) ' matched codes']);

for i = 1:length(Master.Code)
    Bit_Usage(find(Master.Code{i}=='1')) = Bit_Usage(find(Master.Code{i}=='1'))+1;
end


