clear all
close all

load('MH2_2in36.mat');
Master = readtable('Final_Good_Probes_Regions_25Kbto35Kb_4Mbp_12052023Updated.xls');
Master_New = sortrows(Master,{'Chromosome_scaffoldName','GeneStart_bp_'},{'ascend','ascend'});
Fragment_size = 12;
Code_length = 36;
NumBits = 2;
Code_diff = 5;
Code_diff_list=[];


[ChrList,ia1_Chr, ic1_Chr] = unique(Master_New.Chromosome_scaffoldName,'stable');
[N,edges,bin] = histcounts(ic1_Chr);
Chr_frequency =[];
for i = 1:length(N)
    ind_frequency = find(bin ==i);
    Chr_frequency(ind_frequency,1) = N(i);
end
Master_New.ChrFrequency = Chr_frequency;
Master_New = sortrows(Master_New,{'ChrFrequency','Chromosome_scaffoldName','GeneStart_bp_'},{'descend','ascend','ascend'});
[ChrList,ia1_Chr, ic1_Chr] = unique(Master_New.Chromosome_scaffoldName,'stable');

flag = 0;
while flag == 0
    
    Rand = randperm(length(Codes));
    New_Codes = Codes(Rand);
    Bit_Usage = zeros(Code_length,1);
    
    for i = 1:length(ChrList)
        Master_ind = find(ic1_Chr == i);
        %    Master_Temp = Master_New(Master_ind == i,:);
        N_Loci = length(Master_ind);
        
        if N_Loci ==1
            
            Master_New.Code(Master_ind) = New_Codes(1);
            New_Codes(1) = [];
            continue
            
        elseif N_Loci <=Fragment_size
            
            Code_ind = zeros(length(New_Codes),NumBits);
            for ii = 1:length(New_Codes)
                Code_ind(ii,:) = find(New_Codes{ii}=='1');
            end
            
            Grouped_code = {};
            Grouped_code{1,1} =1;
            Counter = 1;
            
            for ii = 2:size(Code_ind,1)
                Used_Bits = Code_ind(Grouped_code{1},:);
                Used_Bits = reshape(Used_Bits',1,[]);
                ind_new = setdiff(Code_ind(ii,:),Used_Bits);
                if length(ind_new)==NumBits && Counter < N_Loci
                    Grouped_code{1,1} = [Grouped_code{1,1} ii];
                    Counter = Counter + 1;
                elseif ii == length(Code_ind)
                    display('Not enough code');
                    finish
                end
                
                if Counter == N_Loci
                    break
                end
                
            end
            
            Master_New.Code(Master_ind) = New_Codes(Grouped_code{1,1});
            New_Codes(Grouped_code{1,1}) = [];
            
            
        elseif N_Loci>Fragment_size
            
            for ii = 1:N_Loci-1
                if ii > N_Loci-Fragment_size+1
                    break
                end
                
                Code_ind = zeros(length(New_Codes),NumBits);
                for iii = 1:length(New_Codes)
                    Code_ind(iii,:) = find(New_Codes{iii}=='1');
                end
                
                if ii == 1
                    Grouped_code = {};
                    Grouped_code{1,1} =1;
                    Counter = 1;
                    
                    for iii = 2:size(Code_ind,1)
                        Used_Bits = Code_ind(Grouped_code{1},:);
                        Used_Bits = reshape(Used_Bits',1,[]);
                        ind_new = setdiff(Code_ind(iii,:),Used_Bits);
                        if length(ind_new)==NumBits && Counter < Fragment_size
                            Grouped_code{1,1} = [Grouped_code{1,1} iii];
                            Counter = Counter + 1;
                        elseif iii == length(Code_ind)
                            display('Not enough code');
                            finish
                        end
                        
                        if Counter == Fragment_size
                            Master_New.Code(Master_ind(1:Fragment_size)) = New_Codes(Grouped_code{1,1});
                            Used_Bits = Code_ind(Grouped_code{1}(2:end),:);
                            Used_Bits = reshape(Used_Bits',1,[]);
                            New_Codes(Grouped_code{1,1}) = [];
                            break
                        end
                        
                    end
                    
                    
                elseif ii <= N_Loci-Fragment_size+1
                    
                    for iii = 1:size(Code_ind,1)
                        ind_new = setdiff(Code_ind(iii,:),Used_Bits);
                        if length(ind_new)==NumBits
                            Master_New.Code(Master_ind(ii+Fragment_size-1)) = New_Codes(iii);
                            Used_Bits = [Used_Bits(NumBits+1:end) Code_ind(iii,:)];
                            New_Codes(iii) = [];
                            break
                        elseif iii == length(Code_ind)
                            display('Not enough code');
                            finish
                        end
                        
                    end
                    
                    
                end
                
            end
            
            
            
        end
        
        
    end
    
    for i = 1:length(Master_New.Code)
        Bit_Usage(find(Master_New.Code{i}=='1')) = Bit_Usage(find(Master_New.Code{i}=='1'))+1;
    end
    
    Code_diff_list = [Code_diff_list (max(Bit_Usage) - min(Bit_Usage))];
    if (max(Bit_Usage) - min(Bit_Usage)) <= Code_diff
        flag=1;
    else
        Master_New.Code=[];
    end
end

writetable(Master_New,'Final_Table_CodeArranged_Combined_4Mbp_12072023Updated.xls');
