clear all
close all

%% OligoArrayOutputFile = 'oligos1.txt';
RepetitiveBLASTDatabase = 'E:\09132023_200Loci\humanREP';
GenomeBLASTDatabase = 'E:\09132023_200Loci\hg19';

%% BLAST against repetitive sequence database

load('GoodOligos_preBLAST_NewRegions.mat');

OligosInitial = GoodOligos_preBLAST;
clear GoodOligos_preBLAST;

oligoFile = 'GoodOligos_preBLAST_NewRegions.fasta';
out = 'BLAST_output_NewRegions_Repetitive_ShortBlast.txt';
system(['blastn -query ' oligoFile ' -task blastn-short -db ' RepetitiveBLASTDatabase ' -out ' out ' -outfmt 10 -max_target_seqs 5 -num_threads 12']);

% go through the blast_output file and find good oligos
fid = fopen(out, 'r');
tline = fgetl(fid);

getNewOligoHeader = false;
getNewLine = false;
oligoNum = 1; %oligo number

OligoHits = zeros(length(OligosInitial),1);


AboveThresholdCount = 0;


while ischar(tline)
    if strfind(tline, OligosInitial(oligoNum).Header)

        C = strsplit(tline,',');
        
        if (str2num(C{12}) >= 33)
            OligoHits(oligoNum) = OligoHits(oligoNum)+1;
            
            AboveThresholdCount = AboveThresholdCount+1;
            AboveThresh(AboveThresholdCount).Header = OligosInitial(oligoNum).Header;
            AboveThresh(AboveThresholdCount).Score = str2num(C{12});
        end

        getNewLine = true;
    else
        getNewOligoHeader = true;
    end

    if getNewOligoHeader
        oligoNum = oligoNum+1;
        getNewOligoHeader = false;
    end
    if getNewLine
        tline = fgetl(fid);
        getNewLine = false;
    end
end
fclose(fid);

GoodOligoRep = 0;
BadOligoRep = 0;
clear GoodOligo_BLASTRep BadOligo_BLASTRep
for ii = 1:length(OligosInitial)
    if OligoHits(ii) == 0
        GoodOligoRep = GoodOligoRep+1;
        GoodOligo_BLASTRep(GoodOligoRep) = OligosInitial(ii);
    else
        BadOligoRep = BadOligoRep+1;
        BadOligo_BLASTRep(BadOligoRep) = OligosInitial(ii);
    end
end

if exist('GoodOligos_BLASTRep_Short_NewRegions_12052023Updated.fasta')
    delete('GoodOligos_BLASTRep_Short_NewRegions_12052023Updated.fasta');
end
fastawrite('GoodOligos_BLASTRep_Short_NewRegions_12052023Updated.fasta', GoodOligo_BLASTRep);

if exist('BadOligos_BLASTRep_Short_NewRegions_12052023Updated.fasta')
    delete('BadOligos_BLASTRep_Short_NewRegions_12052023Updated.fasta');
end
fastawrite('BadOligos_BLASTRep_Short_NewRegions_12052023Updated.fasta', BadOligo_BLASTRep);

