clear all
close all

%% Generate secondary list 
SecondaryTable = readtable('AdapterBindingSequences.xlsx');
Secondary = SecondaryTable.Sequence;
for i = 1:length(Secondary)  
    SecondaryOld = Secondary{i};
    ind = find(~isspace(Secondary{i}));
    SecondaryNew = SecondaryOld(ind);
    NewSecondary{i} = SecondaryNew(1:20);
end

%% check final output oligo number
Final = readcell('Final_Probe_36bits_3Primers_12112023Updated.xlsx','TextType','string');
Final = Final(:,2);
display(['number of oligos = ' num2str(length(Final))])
n = 0;
for i = 1:length(Final)
    if strlength(Final{i}) == 140
        n = n+1;
    end
end
display(['number of oligos that are 140 base long = ' num2str(n)])

%% check final output primer usage

Universal{1} = 'GTGGTAAAGCTCCGCGGCTT';%ab20_423
Universal{2} = 'GATTGGTCAATGCGGAACGA';%ab20_433

Universal{3} = 'CCCGCGTTAACCATACACCG';%ab20_583
Universal{4} = 'GGTAGCCACACGCTTCGATG';%ab20_858

Universal{5} = 'GCGTCGTTATGGTGCAACGT'; %ab20_135
Universal{6} = 'CGACACCGAACGTGCGACAA'; %ab20_34

Universal{7} = 'ATTATTGGTCGACGCCGCGA'; %ab20_315
Universal{8} = 'CTTGCGAGATTACGCGGCAC'; %ab20_314

Universal{9} = 'CAATCGACTGCGAGGTACGG';%ab20_29085
Universal{10} = 'GCGAACGGAATCACGGACGT';%ab20_29124

Universal{11} = 'TAGGCATGCGAGCGACGGTT'; %ab20_29183
Universal{12} = 'AGGGCATCGTTACGCGGCAA'; %ab20_29231

Universal{13} = 'TGGATACGCCAGTCGGCCTT'; %ab20_29285
Universal{14} = 'GTCAATCGAAGTGTTGCGCA'; %ab20_29324

Universal_l{15} = 'TCTCGTCACCGATAGCGGAG'; %ab20_2133
Universal_r{16} = 'GTCGTAGCGCACAACTCGCT'; %ab20_2993

Universal_l{17} = 'GACAGATACCGCGCCGCTCC'; %ab20_3663
Universal_r{18} = 'ATTTCGCGTCGGTCTGAGGC'; %ab20_3800

Universal_l{19} = 'GACAATTTCGCGTGACGTCA'; %ab20_1063
Universal_r{20} = 'ATCTGCCTAGCGACGATGGC'; %ab20_1095

Universal_l{21} = 'CCGCATGCGAAGTCCCGATA'; %ab20_5291
Universal_r{22} = 'CTCGCCGAGACGGACTTCTC'; %ab20_2257


for i = 1:length(Universal)
    N = 0;
    for j = 1:length(Final)
        N = N+length(strfind(Final{j}, Universal{i}));
    end
    display(['Primer' num2str(i) ' found ' num2str(N) ' times']);
end
        
%% check final output secondary usage

for i = 1:length(NewSecondary)
    N = 0;
    for j = 1:length(Final)
        N = N+length(strfind(Final{j}, NewSecondary{i}));
    end
    display(['Secondary ' num2str(i) ' found ' num2str(N) ' times']);
end
