clear all
close all

Master = readtable('Final_Table_CodeArranged_4Mbp_12052023Updated_FinalFinal.xls');
Probe = readtable('Final_Probe_36bits_423_433_12052023Updated.xlsx');


Genes = Master.GeneName;

for i = 1:size(Probe,1)
    String = Probe{i,1};
    DashPos = strfind(String,'|');
    GoodOligoGenome(i).GeneShortName = String{1}(DashPos{1}(1)+1:DashPos{1}(2)-1);
end


[Unique_Probe_Gene,ia1_Probe, ic1_Probe] = unique({GoodOligoGenome.GeneShortName},'stable');
Good_ind = 0;
Bad_ind = 0;
[C_diff,ia_diff] =setdiff(Unique_Probe_Gene,Genes,'stable');



display(['Total ' num2str(length(Unique_Code_used)) ' unique codes']);
Counter = 0;

for i = 1: length(Unique_Code_used)
    
    TF = matches(Codes,Unique_Code_used(i));
    Counter = Counter + length(find(TF==1));
    
end


display(['Total ' num2str(Counter) ' matched codes']);