clear all
close all

load('FinalOligo_NewRegions_WholeProbeFiltered_12032023Updated.mat');
Master = readtable('Final_Table_CodeArranged_4Mbp_12052023Updated_FinalCodeCorrected_PrimerUpdated.xls');

Universal{1} = 'GCGTCGTTATGGTGCAACGT'; %ab20_135
Universal{2} = 'CGACACCGAACGTGCGACAA'; %ab20_34

Universal{3} = 'ATTATTGGTCGACGCCGCGA'; %ab20_315
Universal{4} = 'CTTGCGAGATTACGCGGCAC'; %ab20_314


[GeneList,ia1, ic1] = unique({FinalOligo.GeneShortName},'stable');

Good_Final_Oligo = [];

for i = 1: length(GeneList)
    
     TF = matches(Master.GeneName,GeneList{i});
     Sub_Master = Master(TF,:);
     Primer_Ind = Sub_Master.Primer;
     Sub_FinalOligo = FinalOligo(ic1==i);
      
     if Primer_Ind == 423

         Good_Final_Oligo = [Good_Final_Oligo;Sub_FinalOligo];
         continue
         
     else
         
         for ii = 1:size(Sub_FinalOligo,1)
             
             Core_Sequence = Sub_FinalOligo(ii).Sequence(21: 120);
             
             if Primer_Ind == 135
                
                 New_Sequence = [Universal{1} Core_Sequence Universal{2}];
                 
             elseif Primer_Ind == 315
                 
                 New_Sequence = [Universal{3} Core_Sequence Universal{4}];
             
             end
             
             Sub_FinalOligo(ii).Sequence = New_Sequence;
            
         end
         
         Good_Final_Oligo = [Good_Final_Oligo;Sub_FinalOligo];
     end

end


 fastawrite('Final_Probe_36bits_3Primers_12112023Updated.fasta', Good_Final_Oligo);
 
 for kk=1:length(Good_Final_Oligo)
     B{kk,1}=Good_Final_Oligo(kk).Header;
     B{kk,2}=Good_Final_Oligo(kk).Sequence;
 end
 
 writecell(B,'Final_Probe_36bits_3Primers_12112023Updated.xlsx','UseExcel',true)