clear all
close all

load('GoodProbes_BLASTGen_Short_NewRegions_12052023Updated.mat');
Master = readtable('Final_Table_CodeArranged_4Mbp_12052023Updated.xls');
Master_Updated = Master;

ind=[];
FinalOligo =[];
Oligo_Num_Cutoff =390;

for i = 1:length(GoodOligoGenome)
    String = GoodOligoGenome(i).Header;
    DashPos = strfind(String,'|');
    GoodOligoGenome(i).GeneShortName = String(DashPos(1)+1:DashPos(2)-1);
    GoodOligoGenome(i).chromosome = String(DashPos(2)+1:DashPos(3)-1);
end

[GeneList,ia1, ic1] = unique({GoodOligoGenome.GeneShortName},'stable');

Gene_Num = length(GeneList);
Oligo_Count=[];

for i = 1:Gene_Num
   
   ind=[];
   SubOligo=[];
   ind = find(ic1==i);
   SubOligo = GoodOligoGenome(ind);
   if length(ind) >= Oligo_Num_Cutoff
       
       FinalOligo =[FinalOligo ;SubOligo];
       Oligo_Count=[Oligo_Count length(ind)];

   end
  
   
end


[GeneList_check,ia1_check, ic1_check] = unique({FinalOligo.GeneShortName},'stable');
[C_diff,ia_diff] =setdiff(GeneList,GeneList_check,'stable');



for i = 1:length(C_diff)
    
      Location_ind = matches(Master_Updated.GeneName, C_diff{i});
      Master_Updated(Location_ind,:) = [];
 
end

writetable(Master_Updated,'Final_Table_CodeArranged_4Mbp_12052023Updated_FinalFinal.xls');
save('FinalOligo_NewRegions_WholeProbeFiltered_12032023Updated.mat', 'FinalOligo');

for kk=1:length(FinalOligo)
    B{kk,1}=FinalOligo(kk).Header;
    B{kk,2}=FinalOligo(kk).Sequence;
end

writecell(B,'Final_Probe__NewRegions_36bits_423_433_12052023Updated.xlsx','UseExcel',true)