clear all
close all

NFOV = 2;
NumLoci = 34;
UmPerPxl = 0.108; % Pixel size in the unit of um 
StepSize = 0.2; % Z stack step size in the unit of um 

%% load in chromosome traces
nC57 = 0;
nCast = 0;

reject = 0;

for jj = 0:NFOV-1    
%     if exist(['TracingResultsMeg3\TraceArray' num2str(jj) '.mat'])==2 
%         load(['TracingResultsMeg3\TraceArray' num2str(jj) '.mat']);
    if exist(['TracingResultsMeg3\TraceArrayCombinedMaxAtLocus' num2str(jj) '_Spatial.mat'])==2 
        load(['TracingResultsMeg3\TraceArrayCombinedMaxAtLocus' num2str(jj) '_Spatial.mat']);
        
        TraceArray = TraceArrayCombined;
        
        for i = 1:length(TraceArray)            
            
            if size(TraceArray{i},2) < 14 || isnan(TraceArray{i}(1,14)) || isnan(TraceArray{i}(1,15)) || isnan(TraceArray{i}(1,16))
                reject = reject+1;
                continue
            end
            
            if TraceArray{i}(1,12) >= 0.1 && TraceArray{i}(1,13) <= 0.07
                nC57 = nC57+1;
                ChrC57(nC57).x = NaN(NumLoci,1);
                ChrC57(nC57).y = NaN(NumLoci,1);
                ChrC57(nC57).z = NaN(NumLoci,1);
                ChrC57(nC57).r = zeros(NumLoci,1);
                ChrC57(nC57).x(TraceArray{i}(:,11)) = TraceArray{i}(:,1);
                ChrC57(nC57).y(TraceArray{i}(:,11)) = TraceArray{i}(:,2);
                ChrC57(nC57).z(TraceArray{i}(:,11)) = TraceArray{i}(:,3);
                ChrC57(nC57).r(TraceArray{i}(:,11)) = 1;
                ChrC57(nC57).FOV = jj;
                ChrC57(nC57).PHR = TraceArray{i}(1,14);
                ChrC57(nC57).BoundaryDist = TraceArray{i}(1,15);
                ChrC57(nC57).CentroidDist = TraceArray{i}(1,16);
                ChrC57(nC57).CellID = TraceArray{i}(1,17);
            elseif TraceArray{i}(1,13) >= 0.1 && TraceArray{i}(1,12) <= 0.07
                nCast = nCast+1;
                ChrCast(nCast).x = NaN(NumLoci,1);
                ChrCast(nCast).y = NaN(NumLoci,1);
                ChrCast(nCast).z = NaN(NumLoci,1);
                ChrCast(nCast).r = zeros(NumLoci,1);
                ChrCast(nCast).x(TraceArray{i}(:,11)) = TraceArray{i}(:,1);
                ChrCast(nCast).y(TraceArray{i}(:,11)) = TraceArray{i}(:,2);
                ChrCast(nCast).z(TraceArray{i}(:,11)) = TraceArray{i}(:,3);
                ChrCast(nCast).r(TraceArray{i}(:,11)) = 1;
                ChrCast(nCast).FOV = jj;
                ChrCast(nCast).PHR = TraceArray{i}(1,14);
                ChrCast(nCast).BoundaryDist = TraceArray{i}(1,15);
                ChrCast(nCast).CentroidDist = TraceArray{i}(1,16);
                ChrCast(nCast).CellID = TraceArray{i}(1,17);
            else
                reject = reject+1;
            end
        end
    end
end


%% nuclear periphery distance

C57BoundaryDist = [ChrC57.BoundaryDist];
CastBoundaryDist = [ChrCast.BoundaryDist];
C57BoundaryDist = C57BoundaryDist';
CastBoundaryDist = CastBoundaryDist';

indC57Contact = find(C57BoundaryDist <= 0.2);
indCastContact = find(CastBoundaryDist <= 0.2);
C57freqContact = length(indC57Contact)/length(C57BoundaryDist);
CastfreqContact = length(indCastContact)/length(CastBoundaryDist);


BoundaryDist.C57 = C57BoundaryDist;
BoundaryDist.Cast = CastBoundaryDist;
[h, p] = ttest2(C57BoundaryDist,CastBoundaryDist);
figure(11)
violins = violinplot(BoundaryDist, ['1','2'], 'ViolinAlpha', 0.5, 'ViolinColor', [0.5,0.5,1], 'ShowData', true, 'ShowMean', true);
ylabel('Distance to nuclear periphery (um)')
title(['p = ' num2str(round(p,18))])

%% statistics for nuclear periphery association rate
contingencyTable = [length(indC57Contact), length(C57BoundaryDist)-length(indC57Contact); length(indCastContact), length(CastBoundaryDist)-length(indCastContact)];
[~, pContactFreq, stats] = fishertest(contingencyTable);


%% Single-cell EpiPHR analysis

C57PHR = [ChrC57.PHR];
CastPHR = [ChrCast.PHR];
C57PHR = C57PHR';
CastPHR = CastPHR';

C57CellID = [ChrC57.CellID];
CastCellID = [ChrCast.CellID];
SCPHRRatio = [];
for i = 1:length(C57CellID)
    if isnan(C57CellID)
        continue
    end
    
    indC57 = find(C57CellID == C57CellID(i));
    indCast = find(CastCellID == C57CellID(i));
    
    if isempty(indCast)
        continue
    end
    
    SCPHRRatio(end+1) = mean(C57PHR(indC57))/mean(CastPHR(indCast));
    
    C57CellID(indC57) = nan;
    CastCellID(indCast) = nan;
end
SCPHRRatio = SCPHRRatio';

PHRRatio.Ratio = SCPHRRatio;
figure(14)
violins = violinplot(PHRRatio, ['1'], 'ViolinAlpha', 0.5, 'ViolinColor', [0.5,0.5,1], 'ShowData', true, 'ShowMean', true);
ylabel('Pat/Mat PHR Ratio')
