clear all
close all

load('medianC57.mat')
load('medianCast.mat')

boundaryRange = 5;
numLoci = 34;

%%
nBoundaries = 0;
for i = 1+boundaryRange:numLoci-boundaryRange-1
    
    nBoundaries = nBoundaries+1;
    boundaryC57(nBoundaries,1) = i+0.5;
    
    % calculation
    botLeft = MedianC57(i+1+1:i+1+boundaryRange,i); % botLeft
    botRight = MedianC57(i+1+1:i+1+boundaryRange,i+1); % botRight
    
    topLeft = MedianC57(i-boundaryRange:i-1,i);
    topRight = MedianC57(i-boundaryRange:i-1,i+1);
    
%     botLeft = MeanC57(i+1:i+boundaryRange,i); % botLeft
%     botRight = MeanC57(i+1+1:i+1+boundaryRange,i+1); % botRight
%     
%     topLeft = MeanC57(i-boundaryRange:i-1,i);
%     topRight = MeanC57(i+1-boundaryRange:i+1-1,i+1);
    
    boundaryC57(nBoundaries,2) = 1/mean([topLeft./topRight; botRight./botLeft]);
    
end

%%
nBoundaries = 0;
for i = 1+boundaryRange:numLoci-boundaryRange-1
    
    nBoundaries = nBoundaries+1;
    boundaryCAST(nBoundaries,1) = i+0.5;
    
    % calculation
    botLeft = MedianCast(i+1+1:i+1+boundaryRange,i); % botLeft
    botRight = MedianCast(i+1+1:i+1+boundaryRange,i+1); % botRight
    
    topLeft = MedianCast(i-boundaryRange:i-1,i);
    topRight = MedianCast(i-boundaryRange:i-1,i+1);
    
    boundaryCAST(nBoundaries,2) = 1/mean([topLeft./topRight; botRight./botLeft]);
end

figure(4)
hold on
plot(boundaryC57(:,1),boundaryC57(:,2),'.-b')
xlim([0.5 34.5])

figure(4)
hold on
plot(boundaryCAST(:,1),boundaryCAST(:,2),'.-r')
xlim([0.5 34.5])
ylim([1 1.25])
ylabel('Boundary strength')
xlabel('ID# of imaged locus')
saveas(gcf, 'boundaryStrengthStevenSquare.jpg')



for i = 1:numLoci
    ratio(i) = 1./mean(MedianCast(:,i)./MedianC57(:,i),'omitnan'); % this automatically removes the diagonal
end

figure(6)
hold on
plot(1:34,ratio,'.-k')
yline(1,'r')
xlim([0.5 34.5])
ylim([0.8 1.2])
ylabel('Maternal inter-locus contact bias')
xlabel('ID# of imaged locus')
saveas(gcf, 'isolationScore.jpg')

for i = 1:numLoci
    ratio2(i) = sum(MedianCast(:,i)./MedianC57(:,i)-1,'omitnan');
end

figure(7)
hold on
plot(1:34,ratio2,'-k')
yline(1,'r')
xlim([0.5 34.5])
