clear all
close all

NFOV = 2;
NumLoci = 34;
UmPerPxl = 0.108; % Pixel size in the unit of um 
StepSize = 0.2; % Z stack step size in the unit of um 

%% load in chromosome traces
n = 0;
nC57 = 0;
nCast = 0;

SNPFISH = [];


for jj = 0:NFOV-1    
%     if exist(['TracingResultsMeg3\TraceArray' num2str(jj) '.mat'])==2 
%         load(['TracingResultsMeg3\TraceArray' num2str(jj) '.mat']);
    if exist(['TracingResultsMeg3\TraceArrayCombinedMaxAtLocus' num2str(jj) '_Spatial.mat'])==2 
        load(['TracingResultsMeg3\TraceArrayCombinedMaxAtLocus' num2str(jj) '_Spatial.mat']);
        
        TraceArray = TraceArrayCombined;
        
        for i = 1:length(TraceArray)            
            n = n+1;
            Chr(n).x = NaN(NumLoci,1);
            Chr(n).y = NaN(NumLoci,1);
            Chr(n).z = NaN(NumLoci,1);
            Chr(n).r = zeros(NumLoci,1);
            Chr(n).x(TraceArray{i}(:,11)) = TraceArray{i}(:,1);
            Chr(n).y(TraceArray{i}(:,11)) = TraceArray{i}(:,2);
            Chr(n).z(TraceArray{i}(:,11)) = TraceArray{i}(:,3);
            Chr(n).r(TraceArray{i}(:,11)) = 1;
            Chr(n).FOV = jj;
            
            SNPFISH(n,1) = TraceArray{i}(1,12);
            SNPFISH(n,2) = TraceArray{i}(1,13);
            
            if size(TraceArray{i},2) < 14 || isnan(TraceArray{i}(1,14))
                continue
            end
            
            if TraceArray{i}(1,12) >= 0.1 && TraceArray{i}(1,13) <= 0.07
                nC57 = nC57+1;
                ChrC57(nC57).x = NaN(NumLoci,1);
                ChrC57(nC57).y = NaN(NumLoci,1);
                ChrC57(nC57).z = NaN(NumLoci,1);
                ChrC57(nC57).r = zeros(NumLoci,1);
                ChrC57(nC57).x(TraceArray{i}(:,11)) = TraceArray{i}(:,1);
                ChrC57(nC57).y(TraceArray{i}(:,11)) = TraceArray{i}(:,2);
                ChrC57(nC57).z(TraceArray{i}(:,11)) = TraceArray{i}(:,3);
                ChrC57(nC57).r(TraceArray{i}(:,11)) = 1;
                ChrC57(nC57).FOV = jj;
                ChrC57(nC57).PHR = TraceArray{i}(1,14);
            elseif TraceArray{i}(1,13) >= 0.1 && TraceArray{i}(1,12) <= 0.07
                nCast = nCast+1;
                ChrCast(nCast).x = NaN(NumLoci,1);
                ChrCast(nCast).y = NaN(NumLoci,1);
                ChrCast(nCast).z = NaN(NumLoci,1);
                ChrCast(nCast).r = zeros(NumLoci,1);
                ChrCast(nCast).x(TraceArray{i}(:,11)) = TraceArray{i}(:,1);
                ChrCast(nCast).y(TraceArray{i}(:,11)) = TraceArray{i}(:,2);
                ChrCast(nCast).z(TraceArray{i}(:,11)) = TraceArray{i}(:,3);
                ChrCast(nCast).r(TraceArray{i}(:,11)) = 1;
                ChrCast(nCast).FOV = jj;
                ChrCast(nCast).PHR = TraceArray{i}(1,14);
            end
        end
    end
end
save('TracingResultsMeg3\ChrList.mat','Chr') 
save('TracingResultsMeg3\ChrC57List.mat','ChrC57') 
save('TracingResultsMeg3\ChrCastList.mat','ChrCast') 


%% Plot mean spatial distance matrix

for i = 1:NumLoci 
    for j = 1:NumLoci 
        DisList = [];
        for k = 1:length(Chr)
            if Chr(k).r(i) == 1 && Chr(k).r(j) == 1
                DisList = [DisList ((Chr(k).x(i)-Chr(k).x(j))^2+(Chr(k).y(i)-Chr(k).y(j))^2+(Chr(k).z(i)-Chr(k).z(j))^2)^0.5];
            end
        end
        MedianALL(i,j) = median(DisList);
        Std(i,j) = std(DisList);
        SEM(i,j) = std(DisList)/(length(DisList))^0.5;
        NofData(i,j) = length(DisList);
        DisListAll{i,j} = DisList;
    end
end

for i = 1:NumLoci 
    for j = 1:NumLoci 
        DisListC57 = [];
        for k = 1:length(ChrC57)
            if ChrC57(k).r(i) == 1 && ChrC57(k).r(j) == 1
                DisListC57 = [DisListC57 ((ChrC57(k).x(i)-ChrC57(k).x(j))^2+(ChrC57(k).y(i)-ChrC57(k).y(j))^2+(ChrC57(k).z(i)-ChrC57(k).z(j))^2)^0.5];
            end
        end
        MedianC57(i,j) = median(DisListC57);
        StdC57(i,j) = std(DisListC57);
        SEMC57(i,j) = std(DisListC57)/(length(DisListC57))^0.5;
        NofDataC57(i,j) = length(DisListC57);
        DisListAllC57{i,j} = DisListC57;
    end
end

for i = 1:NumLoci 
    for j = 1:NumLoci 
        DisListCast = [];
        for k = 1:length(ChrCast)
            if ChrCast(k).r(i) == 1 && ChrCast(k).r(j) == 1
                DisListCast = [DisListCast ((ChrCast(k).x(i)-ChrCast(k).x(j))^2+(ChrCast(k).y(i)-ChrCast(k).y(j))^2+(ChrCast(k).z(i)-ChrCast(k).z(j))^2)^0.5];
            end
        end
        MedianCast(i,j) = median(DisListCast);
        StdCast(i,j) = std(DisListCast);
        SEMCast(i,j) = std(DisListCast)/(length(DisListCast))^0.5;
        NofDataCast(i,j) = length(DisListCast);
        DisListAllCast{i,j} = DisListCast;
    end
end
save('TracingResultsMeg3\medianAll.mat','MedianALL')
save('TracingResultsMeg3\medianC57.mat','MedianC57')
save('TracingResultsMeg3\medianCast.mat','MedianCast')



%%
maxDist = max([max(MedianALL,[],'all'), max(MedianC57,[],'all'), max(MedianCast,[],'all')]);


figure(1)
imagesc(MedianALL)
colorbar
title(['Median spatial distance, n=' num2str(length(Chr))]);
xlabel('ID # of imaged genomic locus','FontSize',11);
ylabel('ID # of imaged genomic locus','FontSize',11);
ColorMap = load('RedBlue.txt');
colormap(ColorMap/255);
a = colorbar;
a.Label.String = 'Median spatial distance (m)';
a.Label.FontSize = 11;
axis square
caxis([0 maxDist])
saveas(gcf, 'TracingResultsMeg3\Median spatial distance.jpg')
% savefig(['Mean spatial distance.fig']);



figure(2)
imagesc(MedianC57)
colorbar
title(['Median spatial distance, n=' num2str(length(ChrC57))]);
xlabel('ID # of imaged genomic locus','FontSize',11);
ylabel('ID # of imaged genomic locus','FontSize',11);
ColorMap = load('CustomColormap.txt');
% ColorMap = load('RedBlue.txt');
ColorMap = flipud(ColorMap);
colormap(ColorMap/255);
a = colorbar;
a.Label.String = 'Median spatial distance (m)';
a.Label.FontSize = 11;
axis square
caxis([0 0.53])

print('C57_HighRes_MedDistMat.tiff', '-dtiff', ['-r', num2str(500)]);


figure(3)
imagesc(MedianCast)
colorbar
title(['Median spatial distance, n=' num2str(length(ChrCast))]);
xlabel('ID # of imaged genomic locus','FontSize',11);
ylabel('ID # of imaged genomic locus','FontSize',11);

ColorMap = load('CustomColormap.txt');
% ColorMap = load('RedBlue.txt');
ColorMap = flipud(ColorMap);
colormap(ColorMap/255);

a = colorbar;
a.Label.String = 'Median spatial distance (m)';
a.Label.FontSize = 11;
axis square
caxis([0 0.53])

print('CAST_HighRes_MedDistMat.tiff', '-dtiff', ['-r', num2str(500)]);




figure(4)
foldChange = MedianC57./MedianCast;
imagesc(foldChange)
colorbar
title(['Median spatial distance fold change (C57/Cast)']);
xlabel('ID # of imaged genomic locus','FontSize',11);
ylabel('ID # of imaged genomic locus','FontSize',11);
BlueRed

% ColorMap = load('RedBlue.txt');
% colormap(ColorMap/255);

a = colorbar;
a.Label.String = 'Fold change';
a.Label.FontSize = 11;
axis square
maxDistFC = max(abs(foldChange),[],'all')-1;
caxis([1-maxDistFC 1+maxDistFC])
saveas(gcf, 'TracingResultsMeg3\Fold change.jpg')
% savefig(['TracingResultsMeg3\Mean spatial distance.fig']);

%% looking at distances that have significantly changed between parents
for i = 1:length(DisListAllC57)
    for ii = 1:length(DisListAllCast)
        DistsForTTEST.C57 = [DisListAllC57{i,ii}];
        DistsForTTEST.CAST = [DisListAllCast{i,ii}];
        [~,p] = ttest2([DistsForTTEST.C57],[DistsForTTEST.CAST]);
        pValues(i,ii) = p;
    end
end

pValuesMin = ones(size(pValues));
pValuesMin(:,:) = 0.5;
pValuesMin = pValuesMin./pValues;
pValuesMin = log10(pValuesMin);

pValuesBinary = double(imbinarize(pValues,0.05));
pValuesBinary(pValuesBinary == 1) = 0.5;
pValuesBinary(pValuesBinary == 0) = 1;
pValuesBinary(pValuesBinary == 0.5) = 0;

figure(5)
imagesc(pValuesBinary)
colormap gray
axis image



PHR.C57 = [ChrC57.PHR];
PHR.CAST = [ChrCast.PHR];
save('TracingResultsMeg3\PHR.mat','PHR')

[h,p] = ttest2([ChrC57.PHR],[ChrCast.PHR]);

figure(11)
violins = violinplot(PHR, ['1','2'], 'ViolinAlpha', 0.5, 'ViolinColor', [0.5,0.5,1], 'ShowData', false, 'ShowMean', true);
ylabel('PHR signal (AtLocus,Max/MedDonut)','FontSize',11);
title(['p = ' num2str(round(p,36))])
% ylim([0.5, inf])
% yline(1)
saveas(gcf, ['TracingResultsMeg3\PHR.jpg'])
axis square


%% plotting SNP FISH


figure(12)
plot(SNPFISH(:,1),SNPFISH(:,2),'.b')
axis square

SNPFISHStruct.C57 = SNPFISH(:,1);
SNPFISHStruct.CAST = SNPFISH(:,2);
save('TracingResultsMeg3\SNPFISH.mat','SNPFISHStruct')

