clear all
close all

NFOV = 48;
UmPerPxl = 0.108; % Pixel size in the unit of um 
StepSize = 0.2; % Z stack step size in the unit of um

TARTGET_LOCUS = 9;

datasetModifierID = 2000000; % a number that is added to the cell ID to ensure the ID is unique between datasets, should be an integer*1M

% load('FOVTranslator.mat')

saveDir = 'DAPI_Grad';

for jj = 0:NFOV-1
    if exist(['TracingResultsMeg3\TraceArrayPhaseInfo' num2str(jj) '_MaxAtLocus_DONUT.mat'])==2 
        load(['TracingResultsMeg3\TraceArrayPhaseInfo' num2str(jj) '_MaxAtLocus_DONUT.mat']);
        
        load(['PHRDriftParams/DriftParams' num2str(jj) '.mat']);
        
        if ~exist([saveDir '\DAPI_Crop_' num2str(jj) '.png'],'file')
            continue
        end
        
        BW = imread([saveDir '\DAPI_Crop_' num2str(jj) '.png']);
        BW = BW(:,:,1);
        BW = BW./max(BW,[],'all');
        
%         figure(1)
%         imagesc(BW)
%         axis image
        
        BW2_forDAPI = imtranslate(BW,[-Xdrift, -Ydrift],'FillValues',0,'method','nearest');
        BW2_forBoundary = imtranslate(BW,[-Xdrift, -Ydrift],'FillValues',1,'method','nearest');
        
        
        Boundaries = BW2_forBoundary;
        Boundaries(BW2_forBoundary == 1) = 0;
        Boundaries(BW2_forBoundary == 0) = 1;
        
        
        BW3 = imbinarize(BW2_forDAPI);
        BW4 = bwareaopen(BW3, 100000);
        
        indBW3 = BW3 == 1;
        indBW4 = BW4 == 0;
        indDAPI = indBW3 == indBW4;
        
        DAPI = zeros(size(BW4));
        DAPI(indDAPI) = 1;
        DAPI = bwareaopen(DAPI, 500);
        DAPI = double(DAPI);
        
        cc = bwconncomp(DAPI);
        cc2 = regionprops(cc,'Centroid','PixelList');        
        
        % processing traces
        
        BoundariesInd = find(Boundaries == 1);
        [Boundary1,Boundary2] = ind2sub([1536, 1536],BoundariesInd);
        
        clear BoundaryPix
        BoundaryPix(:,1) = Boundary1;
        BoundaryPix(:,2) = Boundary2;
        
        C57Location = zeros(size(DAPI));
        CastLocation = zeros(size(DAPI));
        
        
        for i = 1:length(TraceArray)
            fitFoci = TraceArray{i}(:,11);
            indLocus = find(fitFoci == TARTGET_LOCUS);
            
            if isempty(indLocus)
                TraceArray{i}(1,15) = nan;
                TraceArray{i}(1,16) = nan;
                TraceArray{i}(1,17) = nan;
                continue
            end
            
            median2 = round(median(TraceArray{i}(indLocus,1))/UmPerPxl);
            median1 = round(median(TraceArray{i}(indLocus,2))/UmPerPxl);
            
%             figure(10)
%             hold on
%             imagesc(DAPI)
%             colormap gray
%             axis image
            if TraceArray{i}(1,12) >= 0.1 && TraceArray{i}(1,13) <= 0.07
                C57Location(median1,median2) = 1;
            elseif TraceArray{i}(1,13) >= 0.1 && TraceArray{i}(1,12) <= 0.07
                CastLocation(median1,median2) = 1;
            end
            
            D = pdist2(BoundaryPix, [median1,median2], 'euclidean');
            minDist = min(D);
            
            TraceArray{i}(1,15) = minDist*UmPerPxl;
            
            DAPIDists = [];
            for ii = 1:length(cc2)
                clear cellPix
                cellPix(:,1) = cc2(ii).PixelList(:,2);
                cellPix(:,2) = cc2(ii).PixelList(:,1);

                D = pdist2(cellPix, [median1,median2], 'euclidean');
                minDist = min(D);
                DAPIDists(end+1) = minDist;
            end
            
            DAPIInd = find(DAPIDists == 0);
            if ~isempty(DAPIInd)
                D = pdist2([cc2(DAPIInd).Centroid(2), cc2(DAPIInd).Centroid(1)], [median1,median2], 'euclidean');
                TraceArray{i}(1,16) = D*UmPerPxl;
                TraceArray{i}(1,17) = round(DAPIInd+cc2(DAPIInd).Centroid(2)+cc2(DAPIInd).Centroid(1)+(jj*10000))+datasetModifierID;
            elseif TraceArray{i}(1,15) == 0 % case where it is on the boundary
                [~,DAPIInd] = min(DAPIDists);
                D = pdist2([cc2(DAPIInd).Centroid(2), cc2(DAPIInd).Centroid(1)], [median1,median2], 'euclidean');
                TraceArray{i}(1,16) = D*UmPerPxl;
                TraceArray{i}(1,17) = round(DAPIInd+cc2(DAPIInd).Centroid(2)+cc2(DAPIInd).Centroid(1)+(jj*10000))+datasetModifierID;
            else
                TraceArray{i}(1,16) = nan;
                TraceArray{i}(1,17) = nan;
            end
        end
        
        save(['TracingResultsMeg3\TraceArrayPhaseInfo' num2str(jj) '_MaxAtLocus_DONUT_Spatial.mat'],'TraceArray');
                
%         C57Location = imdilate(C57Location,[1,1,1;1,1,1;1,1,1]);
%         CastLocation = imdilate(CastLocation,[1,1,1;1,1,1;1,1,1]);
%         
%         RGB = zeros(1536,1536,3);
%         RGB(:,:,1) = CastLocation;
%         RGB(:,:,2) = C57Location;
%         RGB(:,:,3) = DAPI;
%         
% 
%         figure(10)
%         imagesc(RGB)
%         % colormap gray
%         axis image
%         
%         saveas(gcf, ['TracingResultsMeg3\FociDistribution_' num2str(jj) '.jpg'])
%         close all
        
%         figure(1)
%         imagesc(BW)
%         axis image
%         
%         figure(2)
%         imagesc(BW2_forDAPI)
%         axis image
%         
%         figure(3)
%         imagesc(Boundaries)
%         axis image
%         
%         figure(4)
%         imagesc(DAPI)
%         axis image
    end
end


