clear all
close all

NFOV = 23;
UmPerPxl = 0.108; % Pixel size in the unit of um 
StepSize = 0.2; % Z stack step size in the unit of um

TARTGET_LOCUS = 9;

% phasing image details
NumImage = 701; % Number of images in each z stack 
ImageSize = 1536; % Number of pxls along each axis of image
ImageDepth = 70;
FramesToWait = 5; % Frames to wait at each z height for each channel 
TotalNumChannels = 2; % Total number of channels in the z stack 
PHR = 1;

% load('FOVTranslator.mat')

ImageLocationPHR = ['E:\Example\Directory\EpiPHRImages\'];

load('ColorShift647560/DeltaZ.mat');
load('ColorShift647560/tform.mat');
DeltaZ647560 = DeltaZ;
tform647560 = tform;

%% load in chromosome traces
nTraces = 0;
AllPHRIntensities = [];

mkdir('PHRImages')

for jj = 0:NFOV-1
    if exist(['TracingResultsMeg3\TraceArrayPhaseInfo' num2str(jj) '.mat'])==2 
        load(['TracingResultsMeg3\TraceArrayPhaseInfo' num2str(jj) '.mat']);
        
        load(['PHRDriftParams/DriftParams' num2str(jj) '.mat']);
                
        for ii = 1
            
            % jjUse = FOVTranslator{jj+1}(1)-1;
            jjUse = jj;
            
            if NFOV<=100
                if jjUse<10
                    FOVid = ['0' num2str(jjUse)];
                else
                    FOVid = [num2str(jjUse)];
                end
            elseif NFOV>100
                if jjUse<10
                    FOVid = ['00' num2str(jjUse)];
                elseif jjUse<100
                    FOVid = ['0' num2str(jjUse)];
                else
                    FOVid = [num2str(jjUse)];
                end
            end
                    
            FileName = [ImageLocationPHR 'PHR_' FOVid];
            if ~exist([FileName '.dax'],'file')
                FileName = [ImageLocationPHR 'PHR_0' FOVid];
            end  

            [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName,701,ImageSize,FramesToWait,TotalNumChannels,PHR,3,5);
            
%             % Here warp the Cy5 image into the Cy3 channel, to get it
%             closer
%             for j = 1:size(ImageStack,3)
%                 ImageStack(:,:,j) = imtransform(ImageStack(:,:,j), tform, 'XData', [1 ImageSize], 'Ydata', [1 ImageSize]);
%             end
            
            imageClean = ImageStack;

%             imageMax = max(imageClean,[],3);
%             figure(ii)
%             imagesc(imageMax)
%             colormap gray
%             axis image
            
            %% get coordinates of traces
            for i = 1:length(TraceArray)
                
                % Meg3 is at locus 9
                
                fitFoci = TraceArray{i}(:,11);
                indLocus = find(fitFoci == TARTGET_LOCUS);
                if isempty(indLocus)
                    PHRIntensity = nan;
                    TraceArray{i}(1,14) = PHRIntensity;
                    continue
                end
                                
                medianX = (median(TraceArray{i}(indLocus,1))/UmPerPxl + Xdrift(ii));
                medianY = (median(TraceArray{i}(indLocus,2))/UmPerPxl + Ydrift(ii));
                medianZ = (median(TraceArray{i}(indLocus,3))/StepSize + Zdrift(ii)); %  + DeltaZ);
                
%                 medianX = (median(TraceArray{i}(:,1))/UmPerPxl + Xdrift(ii));
%                 medianY = (median(TraceArray{i}(:,2))/UmPerPxl + Ydrift(ii));
%                 medianZ = (median(TraceArray{i}(:,3))/StepSize + Zdrift(ii) + DeltaZ);
%                 
%                 figure(ii)
%                 hold on
%                 plot(medianX,medianY,'rx')

                xyRangePHR = 1;
                zRangePHR = 0;
                
                xStart = max([1,round(medianX-xyRangePHR)]);
                xEnd = min([ImageSize,round(medianX+xyRangePHR)]);
                yStart = max([1,round(medianY-xyRangePHR)]);
                yEnd = min([ImageSize,round(medianY+xyRangePHR)]);
                zStart = max([1,round(medianZ-zRangePHR)]);
                zEnd = min([ImageDepth,round(medianZ+zRangePHR)]);
                
                imageCrop = imageClean(yStart:yEnd,xStart:xEnd,zStart:zEnd);
                
                xyRange = 11;
                zRange = 1;
                centerXY = xyRange + 1;
                centerZ = zRange + 1;
                
                xStart = max([1,round(medianX-xyRange)]);
                xEnd = min([ImageSize,round(medianX+xyRange)]);
                yStart = max([1,round(medianY-xyRange)]);
                yEnd = min([ImageSize,round(medianY+xyRange)]);
                zStart = max([1,round(medianZ-zRange)]);
                zEnd = min([ImageDepth,round(medianZ+zRange)]);
                
                imageCropBackground = imageClean(yStart:yEnd,xStart:xEnd,zStart:zEnd);
                imageCropBackground(centerXY-xyRangePHR:centerXY+xyRangePHR,centerXY-xyRangePHR:centerXY+xyRangePHR,centerZ-zRange:centerZ+zRange) = nan;
%                 maxCrop = max(imageCrop,[],3);
%                 figure(2)
%                 imagesc(maxCrop)
%                 axis image
%                 colormap gray
                if isempty(imageCrop)
                    PHRIntensity = nan;
                else
                    PHRIntensity = max(imageCrop,[],'all')./median(imageCropBackground,'all','omitnan');
                end
                
                TraceArray{i}(1,14) = PHRIntensity;
                
            end
        end
    else
        continue
    end
    
    save(['TracingResultsMeg3\TraceArrayPhaseInfo' num2str(jj) '_MaxAtLocus_DONUT.mat'],'TraceArray');

end


