clear all
close all

NFOV = 23;
UmPerPxl = 0.108; % Pixel size in the unit of um 
StepSize = 0.2; % Z stack step size in the unit of um 

% phasing image details
NumImage = 701; % Number of images in each z stack 
ImageSize = 1536; % Number of pxls along each axis of image
ImageDepth = 70;
FramesToWait = 5; % Frames to wait at each z height for each channel 
TotalNumChannels = 2; % Total number of channels in the z stack
PhaseChannel = 1;

% load('FOVTranslator.mat')

ImageLocationC57Cast = ['E:\Example\Directory\SNPFISHImages\'];
ImageLocationC57CastRehyb = ['E:\Example\Directory\SNPFISHImages\'];

usedPhases = [3,4];
load('ColorShift750647/DeltaZ.mat');
load('ColorShift750647/tform.mat');

%% load in chromosome traces
nTraces = 0;
AllPhaseIntensities = [];
for jj = 0:NFOV-1
    disp(num2str(jj));
    if exist(['TracingResultsMeg3\TraceArray' num2str(jj) '.mat'])==2 
        load(['TracingResultsMeg3\TraceArray' num2str(jj) '.mat']);
        
        load(['C57CastDriftParams/DriftParams' num2str(jj) '.mat']);
        
        for ii = usedPhases
            
            jjUse = jj; % FOVTranslator{jj+1}(1)-1;
            
            if NFOV<=100
                if jjUse<10
                    FOVid = ['0' num2str(jjUse)];
                else
                    FOVid = [num2str(jjUse)];
                end
            elseif NFOV>100 
                if jjUse<10
                    FOVid = ['00' num2str(jjUse)];
                elseif jjUse<100
                    FOVid = ['0' num2str(jjUse)];
                else
                    FOVid = [num2str(jjUse)];
                end
            end
            
            HybNumString = [num2str(ii-1)];
        
            if ii == 1
                FileName = [ImageLocationC57CastRehyb 'C57Cast_' HybNumString '_' FOVid];
            else
                FileName = [ImageLocationC57Cast 'C57Cast_' HybNumString '_' FOVid];
            end

            [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName,NumImage,ImageSize,FramesToWait,TotalNumChannels,PhaseChannel,3,5);
            
            % Here warp the Cy7 image into the Cy5 channel.
            for j = 1:size(ImageStack,3)
                ImageStack(:,:,j) = imtransform(ImageStack(:,:,j), tform, 'XData', [1 ImageSize], 'Ydata', [1 ImageSize]);
            end
            
            imageClean = ImageStack;
            for j = 1:size(ImageStack,3)
%                 imageMax = max(ImageStack,[],3);
    %             figure(1)
    %             imagesc(imageMax)
    %             colormap gray
    %             axis image

                se = strel('disk',11);
                background = imopen(ImageStack(:,:,j),se);
    %             figure(2)
    %             imagesc(background)
    %             colormap gray
    %             axis image

                imageClean(:,:,j) = ImageStack(:,:,j) - background;
                imageClean(imageClean < 0) = 0;

%                 figure(3)
%                 imagesc(imageClean)
%                 colormap gray
%                 axis image
            end
            
%             imageMax = max(imageClean,[],3);
%             figure(ii)
%             imagesc(imageMax)
%             colormap gray
%             axis image
            
            %% get coordinates of traces
            for i = 1:length(TraceArray)
                medianX = (median(TraceArray{i}(:,1))/UmPerPxl + Xdrift(ii));
                medianY = (median(TraceArray{i}(:,2))/UmPerPxl + Ydrift(ii));
                medianZ = (median(TraceArray{i}(:,3))/StepSize + Zdrift(ii) + DeltaZ);
                
%                 figure(ii)
%                 hold on
%                 plot(medianX,medianY,'rx')

                xyRange = 6;
                zRange = 3;
                
                xStart = max([1,round(medianX-xyRange)]);
                xEnd = min([ImageSize,round(medianX+xyRange)]);
                yStart = max([1,round(medianY-xyRange)]);
                yEnd = min([ImageSize,round(medianY+xyRange)]);
                zStart = max([1,round(medianZ-zRange)]);
                zEnd = min([ImageDepth,round(medianZ+zRange)]);
                
                imageCrop = imageClean(yStart:yEnd,xStart:xEnd,zStart:zEnd);
%                 maxCrop = max(imageCrop,[],3);
%                 figure(2)
%                 imagesc(maxCrop)
%                 axis image
%                 colormap gray
                
                if isempty(imageCrop)
                    TraceArray{i}(1,12) = nan;
                    TraceArray{i}(1,13) = nan;
                    continue
                end
                
                phaseIntensity = max(imageCrop,[],'all');
                
                if ii == usedPhases(1)
                    TraceArray{i}(1,12) = phaseIntensity;
                elseif ii == usedPhases(2)
                    TraceArray{i}(1,13) = phaseIntensity;
                end
                
            end
            
        end
    else
        continue
    end
    
    nTraces = 0;
    clear PhaseIntensities
    for i = 1:length(TraceArray)
        nTraces = nTraces+1;
        PhaseIntensities(nTraces,1:2) = TraceArray{i}(1,12:13);
    end
    
    norm1 = max(PhaseIntensities(:,1));
    norm2 = max(PhaseIntensities(:,2));
    
    PhaseIntensities(:,1) = PhaseIntensities(:,1)/norm1;
    PhaseIntensities(:,2) = PhaseIntensities(:,2)/norm2;
    
    AllPhaseIntensities = [AllPhaseIntensities; PhaseIntensities];
    
    for i = 1:length(TraceArray)
        TraceArray{i}(1,12) = TraceArray{i}(1,12)/norm1;
        TraceArray{i}(1,13) = TraceArray{i}(1,13)/norm2;
    end
    
    save(['TracingResultsMeg3\TraceArrayPhaseInfo' num2str(jj) '.mat'],'TraceArray');


end

save('TracingResultsMeg3\AllPhaseIntensities.mat','AllPhaseIntensities');
figure(1)
plot(AllPhaseIntensities(:,1),AllPhaseIntensities(:,2),'b.');
savefig(['TracingResultsMeg3\AllPhaseIntensities.fig']);


