clear all
close all

NFOV = 23; % Number of fields of views

NumImage = 1051; % Number of images in each z stack 
ImageSize = 1536; % Number of pxls along each axis of image
FramesToWait = 5; % Frames to wait at each z height for each channel 
TotalNumChannels = 3; % Total number of channels in the z stack 

InitialLocalMaxThresh_tracing = 50; % Initial brightness threshold for DNA foci identification 
MaxNumFociToFit = 150; % Maxium number of DNA foci to fit per FOV 
NumLoci = 34; % Number of traced genomic loci in chromatin tracing 

Hyb0IsBit1 = 1;

AdjrsquareThreshold = 0.7;
FociAreaThreshold = 20; % this threshold elimiates large patches of fluorescence

% load('FOVTranslator.mat')

ImageLocation1 = ['E:\Example\Directory\TracingImages\'];
ImageLocation2 = ['E:\Example\Directory\TracingImagesRehyb\'];
%% 
mkdir('TracingResultsMeg3')
for jj = 0:NFOV-1    
    if exist(['TracingDriftParams/DriftParams' num2str(jj) '.mat'])==2
        load(['TracingDriftParams/DriftParams' num2str(jj) '.mat']);
        
        for i = 1:NumLoci
            if isnan(Xdrift(i))
                XfitList{i} = [];
                YfitList{i} = [];
                ZfitList{i} = [];
                XgofList{i} = [];
                YgofList{i} = [];
                ZgofList{i} = [];
                IntensityList{i} = [];
                XwidthList{i} = []; 
                YwidthList{i} = []; 
                ZwidthList{i} = [];
                continue
            end
            
            ii = i;
            iiUse = i;
            if ii == 0
                iiUse = ii; % set rehyb ii here
                ImageLocationUSE = ImageLocation2;
                imageBaseName = 'STORMCy5Cy3488_Rehyb_';
            else
                ImageLocationUSE = ImageLocation1;
                imageBaseName = 'STORMCy5Cy3488_';
            end
            
            jjUse = jj;
            
            % utilize FOVTranslator here if needed
%             if i <= 6
%                 jjUse = FOVTranslator{jj+1}(1)-1;
%                 ImageLocationUSE = ImageLocation1;
%             elseif i <= 16
%                 jjUse = FOVTranslator{jj+1}(2)-1;
%                 ImageLocationUSE = ImageLocation2;
%             elseif i <= 34
%                 jjUse = FOVTranslator{jj+1}(3)-1;
%                 ImageLocationUSE = ImageLocation3;
%             end
            
            if NFOV<=100
                if jjUse<10
                    FOVid = ['0' num2str(jjUse)];
                else
                    FOVid = [num2str(jjUse)];
                end
            elseif NFOV>100 
                if jjUse<10
                    FOVid = ['00' num2str(jjUse)];
                elseif jjUse<100
                    FOVid = ['0' num2str(jjUse)];
                else
                    FOVid = [num2str(jjUse)];
                end
            end
            
            if i <= NumLoci
                if Hyb0IsBit1 == 1
                    if iiUse-1<10
                        HybNumString = ['0' num2str(iiUse-1)];
                    elseif iiUse-1 < 100
                        HybNumString = [num2str(iiUse-1)];
                    end
                end
                
                FileName = [ImageLocationUSE imageBaseName HybNumString '_' FOVid];
%                 if ~exist([FileName '.dax'],'file')
%                     FileName = [ImageLocationUSE imageBaseName num2str(iiUse-1) '_' FOVid]; % in some cases, this is useful to correct for missing zeros at the start of the hyb number
%                 end
                
                [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName,NumImage,ImageSize,FramesToWait,TotalNumChannels,1,3,5);
            end            
            
            % use adaptive thresholding to try to get MaxNumFociToFit foci
            LocalMaxThresh = InitialLocalMaxThresh_tracing;
            ImageMax = medfilt2(max(ImageStack, [],3)); 
            background = imopen(ImageMax, strel('disk', 4));
            ImageMax = ImageMax-background;
            ImageMax(find(ImageMax<0)) = 0;
            BW = imextendedmax(ImageMax,LocalMaxThresh);
            CC = bwconncomp(BW, 8);
            S = regionprops(CC, 'Area');
            Ind = find([S.Area]<FociAreaThreshold);
            S = S(Ind);
            while length(S)<MaxNumFociToFit && LocalMaxThresh>15
                LocalMaxThresh = LocalMaxThresh-10;
                BW = imextendedmax(ImageMax,LocalMaxThresh);
                CC = bwconncomp(BW, 8);
                S = regionprops(CC, 'Area');
                Ind = find([S.Area]<FociAreaThreshold);
                S = S(Ind);
            end
            
%             % Here warp the Cy5 image into the Cy3 channel.
%             if i <= 14
%                 for j = 1:size(ImageStack,3)
%                     ImageStack(:,:,j) = imtransform(ImageStack(:,:,j), tform, 'XData', [1 ImageSize], 'Ydata', [1 ImageSize]);
%                 end
%             end
            
            [Xfit, Yfit, Zfit, Xgof, Ygof, Zgof, Intensity, Xwidth, Ywidth, Zwidth] = fitMultipleFoci(ImageStack,LocalMaxThresh,MaxNumFociToFit);
            if ~isempty(Xfit)
                Ind = find([Xgof.adjrsquare]>AdjrsquareThreshold & ...
                    [Ygof.adjrsquare]>AdjrsquareThreshold & ...
                    [Zgof.adjrsquare]>AdjrsquareThreshold);
                
                XfitList{i} = Xfit(Ind)- Xdrift(i);
                YfitList{i} = Yfit(Ind)- Ydrift(i);
                ZfitList{i} = Zfit(Ind)- Zdrift(i);

%                 if i <= 14
%                     ZfitList{i} = ZfitList{i}-DeltaZ; % cancel the color shift in Z
%                 end
                
                XgofList{i} = Xgof(Ind);
                YgofList{i} = Ygof(Ind);
                ZgofList{i} = Zgof(Ind);
                IntensityList{i} = Intensity(Ind);
                XwidthList{i} = Xwidth(Ind); 
                YwidthList{i} = Ywidth(Ind); 
                ZwidthList{i} = Zwidth(Ind);
            else
                XfitList{i} = [];
                YfitList{i} = [];
                ZfitList{i} = [];
                XgofList{i} = [];
                YgofList{i} = [];
                ZgofList{i} = [];
                IntensityList{i} = [];
                XwidthList{i} = []; 
                YwidthList{i} = []; 
                ZwidthList{i} = [];
            end
            display(['Successfully fit ' num2str(length(XfitList{i})) ' foci.'])
        end
        save(['TracingResultsMeg3/result' num2str(jj) '.mat'], 'XfitList', 'YfitList', 'ZfitList', 'XgofList', 'YgofList', 'ZgofList','IntensityList','XwidthList','YwidthList','ZwidthList');
    end
end

    

