clear all
close all

NFOV = 23; % Number of fields of views 
NumImage = 1051; % Number of images in each z stack containing the fiducial beads
ImageSize = 1536; % Number of pxls along each axis of image
FramesToWait = 5; % Frames to wait at each z height for each channel 

TotalNumChannels = 3; % Total number of channels in the z stack contining the fiducial beads 
BeadChannelID = 3; % Channel ID in the z stack for fiducial beads 
InitialLocalMaxThresh = 100; % Initial brightness threshold for bead identification 
RoundsOfHybs_tracing = 34; % Number of secondary hybs in chromatin tracing after hyb0
AdjrsquareThreshold = 0.9;
MaxNumBeadsToFit = 100;
Hyb0IsBit1 = 1;

% load('FOVTranslator.mat')

ImageLocation1 = ['E:\Example\Directory\TracingImages\'];
ImageLocation2 = ['F:\Example\Directory\TracingImagesRehybs\'];

%%

mkdir('TracingDriftParams')
for jj = 0:NFOV-1
    Xdrift = [];
    Ydrift = [];
    Zdrift = [];
    
    jjUse = jj; % FOVTranslator{jj+1}(1)-1;
    
    if NFOV<=100
        if jjUse<10
            FOVid = ['0' num2str(jjUse)];
        else
            FOVid = [num2str(jjUse)];
        end
    elseif NFOV>100 
        if jjUse<10
            FOVid = ['00' num2str(jjUse)];
        elseif jjUse<100
            FOVid = ['0' num2str(jjUse)];
        else
            FOVid = [num2str(jjUse)];
        end
    end
    
    FileName = [ImageLocation1 'STORMCy5Cy3488_00_' FOVid];
    [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName,NumImage,ImageSize,FramesToWait,TotalNumChannels,BeadChannelID,3,5);
    Image1 = mean(ImageStack,3);
    
    LocalMaxThresh = InitialLocalMaxThresh;
    [Xfit1, Yfit1, Zfit1, Xgof1, Ygof1, Zgof1, Intensity1, Xwidth, Ywidth, Zwidth] = fitMultipleFoci(ImageStack,LocalMaxThresh,MaxNumBeadsToFit);
    Ind = find([Xgof1.adjrsquare]>AdjrsquareThreshold & ...
            [Ygof1.adjrsquare]>AdjrsquareThreshold & ...
            [Zgof1.adjrsquare]>AdjrsquareThreshold);
    Xfit1 = Xfit1(Ind);
    Yfit1 = Yfit1(Ind);
    Zfit1 = Zfit1(Ind);
    NumLandMarks = length(Xfit1);
    while NumLandMarks<10 && LocalMaxThresh>15
        LocalMaxThresh = LocalMaxThresh-10;
        [Xfit1, Yfit1, Zfit1, Xgof1, Ygof1, Zgof1, Intensity1, Xwidth, Ywidth, Zwidth] = fitMultipleFoci(ImageStack,LocalMaxThresh,MaxNumBeadsToFit);
        Ind = find([Xgof1.adjrsquare]>AdjrsquareThreshold & ...
            [Ygof1.adjrsquare]>AdjrsquareThreshold & ...
            [Zgof1.adjrsquare]>AdjrsquareThreshold);
        Xfit1 = Xfit1(Ind);
        Yfit1 = Yfit1(Ind);
        Zfit1 = Zfit1(Ind);
        NumLandMarks = length(Xfit1);
    end
    display([num2str(NumLandMarks) ' beads identified.']);

    if NumLandMarks<2
        display('NumLandMarks<2')
        continue
    end
    
    % find the minimum 2D distance to each bead (from all other beads): MinDisArray
	MinDisMatrix = ones(NumLandMarks,NumLandMarks)*ImageSize;
	for i = 1:NumLandMarks
		for j = 1:NumLandMarks
            if i~=j
    			MinDisMatrix(i,j) = ((Xfit1(i)-Xfit1(j))^2+(Yfit1(i)-Yfit1(j))^2)^0.5;
            end
		end
    end
    
    % This contains the minimum value of each column.
	MinDisArray = min(MinDisMatrix);
    
    for ii = 1:RoundsOfHybs_tracing
        
        iiUse = ii;
        
        if ii == 0 % rehyb numbers here
            iiUse = ii-31; % adjust ii as required
            ImageLocationUSE = ImageLocation2;
            imageBaseName = 'STORMCy5Cy3488_Rehyb_';
        else
            ImageLocationUSE = ImageLocation1;
            imageBaseName = 'STORMCy5Cy3488_';
        end
        
        if Hyb0IsBit1 == 1
            if iiUse-1<10
                HybNumString = ['0' num2str(iiUse-1)];
            elseif iiUse-1 < 100
                HybNumString = [num2str(iiUse-1)];
            end
        end
        
        FileName = [ImageLocationUSE imageBaseName HybNumString '_' FOVid];
        if ~exist([FileName '.dax'],'file')
            FileName = [ImageLocationUSE imageBaseName num2str(iiUse-1) '_' FOVid];
        end
        
        try
            [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName,NumImage,ImageSize,FramesToWait,TotalNumChannels,BeadChannelID,3,5);        
        catch
            Xdrift(ii) = nan;
            Ydrift(ii) = nan;
            Zdrift(ii) = nan;
            continue
        end
        
        Image2 = mean(ImageStack,3);
%         figure(3)
%         imagesc(Image2)
%         hold on
%         colormap gray
%         axis equal
        LocalMaxThresh = InitialLocalMaxThresh;
        [Xfit2, Yfit2, Zfit2, Xgof2, Ygof2, Zgof2, Intensity2, Xwidth, Ywidth, Zwidth] = fitMultipleFoci(ImageStack,LocalMaxThresh,MaxNumBeadsToFit);
        
        % added for second replicate, also removed breaks when beads are
        % not found, to allow for missing rounds, instead of removing
        % the whole FOV
        if isempty(Xfit2)
            Xdrift(ii) = nan;
            Ydrift(ii) = nan;
            Zdrift(ii) = nan;
            continue
        end
        
        
        Ind = find([Xgof2.adjrsquare]>AdjrsquareThreshold & ...
            [Ygof2.adjrsquare]>AdjrsquareThreshold & ...
            [Zgof2.adjrsquare]>AdjrsquareThreshold);
        Xfit2 = Xfit2(Ind);
        Yfit2 = Yfit2(Ind);
        Zfit2 = Zfit2(Ind);
        NumLandMarks2 = length(Xfit2);
        while NumLandMarks2<10 && LocalMaxThresh>15
            LocalMaxThresh = LocalMaxThresh-10;
            [Xfit2, Yfit2, Zfit2, Xgof2, Ygof2, Zgof2, Intensity2, Xwidth, Ywidth, Zwidth] = fitMultipleFoci(ImageStack,LocalMaxThresh,MaxNumBeadsToFit);
            Ind = find([Xgof2.adjrsquare]>AdjrsquareThreshold & ...
                [Ygof2.adjrsquare]>AdjrsquareThreshold & ...
                [Zgof2.adjrsquare]>AdjrsquareThreshold);
            Xfit2 = Xfit2(Ind);
            Yfit2 = Yfit2(Ind);
            Zfit2 = Zfit2(Ind);
            NumLandMarks2 = length(Xfit2);
        end
        display([num2str(NumLandMarks2) ' beads identified.']);
        
%         figure(3)
%         plot(Xfit2,Yfit2,'x');
%         figure(2)
%         plot(Xfit2,Yfit2,'x');
        
        NumLandMarks2 = length(Xfit2);
        if NumLandMarks2<2
            display('NumLandMarks2<2')
            Xdrift(ii) = nan;
            Ydrift(ii) = nan;
            Zdrift(ii) = nan;
            continue
            % break
        end 
        
        % find the minimum 2D distance to each bead (from all other beads): MinDisArray
        MinDisMatrix2 = ones(NumLandMarks2,NumLandMarks2)*ImageSize;
        for i = 1:NumLandMarks2
            for j = 1:NumLandMarks2
                if i~=j
                    MinDisMatrix2(i,j) = ((Xfit2(i)-Xfit2(j))^2+(Yfit2(i)-Yfit2(j))^2)^0.5;
                end
            end
        end
        MinDisArray2 = min(MinDisMatrix2);
        
        %match molecules from Image1 and Image2 first in 2D and then in 3D
        Xfit1_match = [];
        Yfit1_match = [];
        Zfit1_match = [];
        Xfit2_match = [];
        Yfit2_match = [];
        Zfit2_match = [];
        N = 0;
        for i = 1:NumLandMarks
            Xfit1_new = Xfit1(i);
            Yfit1_new = Yfit1(i);
            [m, Ind] = min(((Xfit2-Xfit1_new).^2+(Yfit2-Yfit1_new).^2).^0.5);
            if ~isempty(m)
                if m<MinDisArray(i)/2 && m<MinDisArray2(Ind)/2 && m<60
                    N = N+1;
                    % The fitting for beads in hyb 0 is not changed, but
                    % the fitting in later hybs are those that have the
                    % shorted drifting.
                    Xfit1_match(N) = Xfit1(i);
                    Yfit1_match(N) = Yfit1(i);
                    Zfit1_match(N) = Zfit1(i);
                    Xfit2_match(N) = Xfit2(Ind);
                    Yfit2_match(N) = Yfit2(Ind);
                    Zfit2_match(N) = Zfit2(Ind);
                end
            end
        end
        
        if N>=2
            MeanDriftX = mean(Xfit2_match-Xfit1_match);
            MeanDriftY = mean(Yfit2_match-Yfit1_match);
            MeanDriftZ = mean(Zfit2_match-Zfit1_match);
            x_new = Xfit2_match-MeanDriftX;
            y_new = Yfit2_match-MeanDriftY;
            z_new = Zfit2_match-MeanDriftZ;
            MedianErrorX = median(Xfit1_match-x_new);
            MedianErrorY = median(Yfit1_match-y_new);
            MedianErrorZ = median(Zfit1_match-z_new);
            Ind = find(abs(Xfit1_match-x_new-MedianErrorX)<1 & abs(Yfit1_match-y_new-MedianErrorY)<1 ...
                & abs(Zfit1_match-z_new-MedianErrorZ)<1);
            if length(Ind)>=2
                Xfit1_match = Xfit1_match(Ind);
                Yfit1_match = Yfit1_match(Ind);
                Zfit1_match = Zfit1_match(Ind);
                Xfit2_match = Xfit2_match(Ind);
                Yfit2_match = Yfit2_match(Ind);
                Zfit2_match = Zfit2_match(Ind);
                MeanDriftX = mean(Xfit2_match-Xfit1_match);
                MeanDriftY = mean(Yfit2_match-Yfit1_match);
                MeanDriftZ = mean(Zfit2_match-Zfit1_match);
                x_new = Xfit2_match-MeanDriftX;
                y_new = Yfit2_match-MeanDriftY;
                z_new = Zfit2_match-MeanDriftZ;

                Ind = find(abs(Xfit1_match-x_new)<1 & abs(Yfit1_match-y_new)<1 & abs(Zfit1_match-z_new)<1);
                if length(Ind)>=2
                    Xfit1_match = Xfit1_match(Ind);
                    Yfit1_match = Yfit1_match(Ind);
                    Zfit1_match = Zfit1_match(Ind);
                    Xfit2_match = Xfit2_match(Ind);
                    Yfit2_match = Yfit2_match(Ind);
                    Zfit2_match = Zfit2_match(Ind);
                    MeanDriftX = mean(Xfit2_match-Xfit1_match);
                    MeanDriftY = mean(Yfit2_match-Yfit1_match);
                    MeanDriftZ = mean(Zfit2_match-Zfit1_match);
                    x_new = Xfit2_match-MeanDriftX;
                    y_new = Yfit2_match-MeanDriftY;
                    z_new = Zfit2_match-MeanDriftZ;
%                     figure(2)
%                     plot(Xfit1_match,Yfit1_match,'.');
%                     plot(x_new,y_new,'o');
                else
                    display('less than 2 beads with final error less than 1')
                    Xdrift(ii) = nan;
                    Ydrift(ii) = nan;
                    Zdrift(ii) = nan;
                    continue
                    % break
                end
            else 
                display('less than 2 beads left after restricting error of error to less than 1')
                Xdrift(ii) = nan;
                Ydrift(ii) = nan;
                Zdrift(ii) = nan;
                continue
                % break
            end  
        else
            display('less than 2 beads matched in 2D')
            Xdrift(ii) = nan;
            Ydrift(ii) = nan;
            Zdrift(ii) = nan;
            continue
            % break
        end

        Xdrift(ii) = MeanDriftX;
        Ydrift(ii) = MeanDriftY;
        Zdrift(ii) = MeanDriftZ;

    end
    % output
    if length(Xdrift) == RoundsOfHybs_tracing
        save(['TracingDriftParams\DriftParams' num2str(jj) '.mat'], 'Xdrift', 'Ydrift', 'Zdrift');
%         figure(2)
%         savefig(['beadfigs/figs2_' FOVid '.fig']);
    end
end
    



    
