clear all
close all

NFOV = 23;
UmPerPxl = 0.108; % Pixel size in the unit of um 
StepSize = 0.2; % Z stack step size in the unit of um

% phasing image details
NumImage = 351; % Number of images in each z stack containing the fiducial beads
ImageSize = 1536; % Number of pxls along each axis of image (Should be changed to 2048 for hydraYCGA)
ImageDepth = 70;
FramesToWait = 5; % Frames to wait at each z height for each channel 
TotalNumChannels = 2; % Total number of channels in the z stack contining the fiducial beads
PHR = 1;

% load('FOVTranslator.mat')

ImageLocationPHR = ['E:\Example\DAPIImageLocation\'];

saveDir = 'DAPI_Grad';
mkdir(saveDir)


for jj = 0:NFOV-1
    if exist(['TracingResultsMeg3\TraceArrayPhaseInfo' num2str(jj) '.mat'])==2 
        load(['TracingResultsMeg3\TraceArrayPhaseInfo' num2str(jj) '.mat']);
        
        load(['PHRDriftParams/DriftParams' num2str(jj) '.mat']);
        
        disp(num2str(jj));
        
        for ii = 1
            
            % jjUse = FOVTranslator{jj+1}(1)-1;
            jjUse = jj;
            
            if NFOV<=100
                if jjUse<10
                    FOVid = ['0' num2str(jjUse)];
                else
                    FOVid = [num2str(jjUse)];
                end
            elseif NFOV>100
                if jjUse<10
                    FOVid = ['00' num2str(jjUse)];
                elseif jjUse<100
                    FOVid = ['0' num2str(jjUse)];
                else
                    FOVid = [num2str(jjUse)];
                end
            end
                    
            FileName = [ImageLocationPHR 'DAPI_' FOVid];
            if ~exist([FileName '.dax'],'file')
                FileName = [ImageLocationPHR 'PHR_0' FOVid];
            end  

            [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName,NumImage,ImageSize,FramesToWait,1,1,3,5);
            ImageStackMax = max(ImageStack,[],3);
            
            for i = 1:size(ImageStack,3)
                ImageStackMed(:,:,i) = medfilt2(ImageStack(:,:,i),[3 3]);
            end
            
            for i = 1:size(ImageStack,3)
                ImageStackGrad(:,:,i) = imgradient(ImageStackMed(:,:,i));
            end
            ImageStackGradMax = max(ImageStackGrad,[],3);
            ImageStackGradMaxNorm = ImageStackGradMax./max(ImageStackGradMax,[],'all');
            ImageStackGradMaxNorm = uint8(255 * mat2gray(ImageStackGradMaxNorm));

            % Save the DAPI Gradient Image
            imwrite(ImageStackGradMaxNorm, [saveDir '\DAPI_Gradient_' num2str(jj) '.png']);

        end
    end
end