clear all
close all

NFOV = 64; % number of fields of views
ImageSize = 1536; % number of pxls
UmPerPxl = 0.108;
StepSize = 0.2; %um

minimumTraceLength = 1;

nHyb = 30;

TraceFileLocation = 'Traces_SmallScale_2_0';
saveLocation = 'DataFigures_2_0';
mkdir(saveLocation)

TraceArrayCombined = {};
for jj = 0:NFOV-1
    if NFOV<=10
        FOVid = num2str(jj);
    elseif NFOV>10 && NFOV<=100
        if jj<10
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    elseif NFOV>100
        if jj<10
            FOVid = ['00' num2str(jj)];
        elseif jj<100
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    end
    clear TraceArray
    if exist([TraceFileLocation '/TraceArray' FOVid '.mat'])
        load([TraceFileLocation '/TraceArray' FOVid '.mat']);
    else
        continue
    end
    for i = 1:length(TraceArray)
        TraceArrayCombined{end+1} = TraceArray{i};
    end
end

MedianDist = zeros(30,30);
STDev = zeros(30,30);

% calculating for group1
for i = 1:nHyb
    for ii = 1:nHyb
        DisList = [];
        for k = 1:size(TraceArrayCombined,2)
%             if size(TraceArrayCombined{k},1) < 5
%                 continue
%             end
            for z = 1:size(TraceArrayCombined{k},1)
                for zz = 1:size(TraceArrayCombined{k},1)
%                     if (TraceArrayCombined{k}(z,8) == 16) || (TraceArrayCombined{k}(zz,8) == 16)
%                         % disp('error')
%                     end
                    if (TraceArrayCombined{k}(z,8) == i) && (TraceArrayCombined{k}(zz,8) == ii)
                        DisList = [DisList ((TraceArrayCombined{k}(z,1)-TraceArrayCombined{k}(zz,1))^2+(TraceArrayCombined{k}(z,2)-TraceArrayCombined{k}(zz,2))^2+(TraceArrayCombined{k}(z,3)-TraceArrayCombined{k}(zz,3))^2)^0.5];
                    end
                end
            end
        end
        if ~isempty(DisList)
            DisList_ALL_1{i,ii} = DisList;
            % Mean(i,ii) = mean(DisList);
            MedianDist(i,ii) = median(DisList); % for making publication figures 2024.06.04
            STDev(i,ii) = std(DisList);
        end
    end
end
save([saveLocation '\MeanPairDistanceMatrix.mat'], 'Mean');


figure(1)
MeanUse = MedianDist(:,:);
imagesc(MeanUse)
colorbar
% caxis([min(Mean(Mean > 0))-((max(Mean,[],'all')-min(Mean(Mean > 0)))/10) max(Mean,[],'all')])
caxis([0 max(MedianDist,[],'all')])
title('Mean spatial distance');
ColorMap = load('RedBlue.txt');
colormap(ColorMap/255);
PlotProp
axis square
ylabel('Locus ID')
xlabel('Locus ID')
a = colorbar;
a.Label.String = 'Mean pairwise distance (um)';
savefig([saveLocation '\Mean spatial distance.fig']);
saveas(gcf, [saveLocation '\Mean spatial distance.jpg']);

figure(2)
STDevUSE = STDev(:,:);
imagesc(STDevUSE)
colorbar
% caxis([min(STDev(STDev > 0))-((max(STDev,[],'all')-min(STDev(STDev > 0)))/10) max(STDev,[],'all')])
caxis([0 max(STDev,[],'all')])
title('Spatial distance standard deviation');
ColorMap = load('RedBlue.txt');
colormap(ColorMap/255);
PlotProp
axis square
ylabel('Locus ID')
xlabel('Locus ID')
a = colorbar;
a.Label.String = 'Std. dev. of mean pairwise distance (um)';
savefig([saveLocation '\Standard Deviation of Mean.fig']);
saveas(gcf, [saveLocation '\Standard Deviation of Mean.jpg']);

% calculating number of values in matrix
SampleSize1 = zeros(30,30);
for i = 1:length(DisList_ALL_1)
    for ii = 1:length(DisList_ALL_1)
        SampleSize1(i,ii) = length(DisList_ALL_1{i,ii});
    end
end

figure(3)
imagesc(SampleSize1)
colorbar
caxis([0 max(SampleSize1,[],'all')])
title('Data size');
ColorMap = load('RedBlue.txt');
colormap(ColorMap/255);
PlotProp
axis square
ylabel('Locus ID')
xlabel('Locus ID')
a = colorbar;
a.Label.String = 'Number of pairwise distance calculations';
savefig([saveLocation '\DataSize1.fig']);
saveas(gcf, [saveLocation '\DataSize1.jpg']);

%% preparing data for figures

% newMedianMatrix = zeros(28,28);
% newMedianMatrix(1:15,1:15) = Mean(1:15,1:15);
% newMedianMatrix(15:28,:) = Mean(16:29,:);
% newMedianMatrix(:,15:28) = Mean(:,16:29);

newMedianMatrix = MedianDist;
newMedianMatrix(16:29,:) = newMedianMatrix(17:30,:);
newMedianMatrix(:,16:29) = newMedianMatrix(:,17:30);
newMedianMatrix = newMedianMatrix(1:28,1:28);

sampleSizeCropped = SampleSize1;
sampleSizeCropped(16:29,:) = sampleSizeCropped(17:30,:);
sampleSizeCropped(:,16:29) = sampleSizeCropped(:,17:30);
sampleSizeCropped = sampleSizeCropped(1:28,1:28);

% figure(4)
% imagesc(newMedianMatrix)
% axis square
% colormap gray

for i = 1:28
    detectionCount(i) = sampleSizeCropped(i,i);
end
detectionEfficiency = detectionCount./length(TraceArrayCombined);

MedianDist = newMedianMatrix;
% save('DetectionEfficiencyCropped.mat','detectionEfficiency');




