clear all
close all


NFOV = 64; % number of fields of views
NumHybs = 28;
WidthThreshMax = 4; % this threshold removes fitted "foci" that are too wide.
WidthThreshMin = 1; % this threshold removes fitted "foci" that are too narrow.
AdjrsquareThreshold = 0.7;
ImageSize = 1536; % number of pxls
UmPerPxl = 0.108;
StepSize = 0.2; %um

NearestNeighborThreshold = 2.0; %um, distance threshold between new focus and the average position of all previous foci in the trace


TraceLengthThreshold = 5; % remove traces that are shorter than this length
%%
% the algorithm: Define each focus in hyb1 as the initiation point of one
% trace. For each focus in hyb1, find the closest focus in hyb2,
% check if the chozen hyb1 focus is the closest to the chozen hyb2 focus,
% if so, and if the two foci are close enough, link these two focus into
% one trace. If not, do not grow the trace, move on to the next focus in
% hyb1 (next trace). Finally, if there are remaining foci in hyb2, define
% them as the initiation points of additional traces.

saveLocation = 'Traces_SmallScale_2_0';
mkdir(saveLocation)
FociCount = zeros(30,1); % initial foci count
FinalFociCount = zeros(30,1); % final count of foci in the traces

for jj = 0:NFOV-1
%     if jj == 26
%         continue
%     end

    if NFOV<=10
        FOVid = num2str(jj);
    elseif NFOV>10 && NFOV<=100
        if jj<10
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    elseif NFOV>100
        if jj<10
            FOVid = ['00' num2str(jj)];
        elseif jj<100
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    end
        
    if exist(['Foci_Fit_Tracing/FinalFoci_Cy3_' FOVid '.mat'])==2
        disp(num2str(jj))
        load(['Foci_Fit_Tracing/FinalFoci_Cy3_' FOVid '.mat']);
%         figure(1)
        for i = 1:NumHybs
            if ~isempty(XfitList_Final{i})
                Ind = find(XwidthList_Final{i}<WidthThreshMax & YwidthList_Final{i}<WidthThreshMax ...
                    & XwidthList_Final{i}>WidthThreshMin & YwidthList_Final{i}>WidthThreshMin); % ...
                    % & [XgofList{i}.adjrsquare]>AdjrsquareThreshold ...
                    % & [YgofList{i}.adjrsquare]>AdjrsquareThreshold ...
                    % & [ZgofList{i}.adjrsquare]>AdjrsquareThreshold);

                XfitList_Final{i} = XfitList_Final{i}(Ind);
                YfitList_Final{i} = YfitList_Final{i}(Ind);
                ZfitList_Final{i} = ZfitList_Final{i}(Ind);
                IntensityList_Final{i} = IntensityList_Final{i}(Ind);
                XwidthList_Final{i} = XwidthList_Final{i}(Ind);
                YwidthList_Final{i} = YwidthList_Final{i}(Ind);
                ZwidthList_Final{i} = ZwidthList_Final{i}(Ind);
                % XgofList{i} = XgofList{i}(Ind);
                % YgofList{i} = YgofList{i}(Ind);
                % ZgofList{i} = ZgofList{i}(Ind);
%                scatter(XfitList{i},YfitList{i},'.')
%                hold on
            end
        end
%         hold off
%         axis equal
%         axis ij
        for i = 1:NumHybs
            FociCount(i) = FociCount(i)+length(XfitList_Final{i});
        end
        for i = 1:NumHybs
            if ~isempty(XfitList_Final{i})
                P1 = [XfitList_Final{i}'*UmPerPxl, YfitList_Final{i}'*UmPerPxl, ZfitList_Final{i}'*StepSize, ...
                    IntensityList_Final{i}', XwidthList_Final{i}', YwidthList_Final{i}', ZwidthList_Final{i}']; % , ...
                    % [XgofList{i}.adjrsquare]', [YgofList{i}.adjrsquare]', [ZgofList{i}.adjrsquare]'];
                if i == 1 % define initial traces
                    for j = 1:size(P1,1)
                        TraceArray{j} = [P1(j,:), i]; 
                        %TraceArray: x(um),y(um),z(um), Intensity, Xwidth(pxl), 
                        %Ywidth(pxl), Zwidth(pxl), Xgof, Ygof, Zgof, hybNo
                    end
                else % match to existing traces and define new traces
                    P0 = [];
                    for j = 1:length(TraceArray)
                        % this following line was modified on 191106 to
                        % calculate the average position of all foci in each
                        % trace and add to P0
                        P0 = [P0; mean(TraceArray{j}(:,1:3),1)]; % build the list of average foci positions in all traces
    %                     P0 = [P0; TraceArray{j}(end,1:3)]; % build the list of end foci in all traces
                    end
                    D = pdist2(P0, P1(:,1:3), 'euclidean');
                    for j = 1:size(P0,1)
                        [M, Ind] = min(D(j,:));
                        M2 = min(D(:,Ind));
                        if M<NearestNeighborThreshold && M==M2 && ~isnan(P1(Ind,1))
                            % add to existing trace
                            TraceArray{j}(end+1,:) = [P1(Ind,:),i];
                            % mark linked foci in P1
                            P1(Ind,1:3) = [NaN, NaN, NaN];
                        end
                    end
                    % find remaining foci in P1 and define new traces
                    for j = 1:size(P1,1)
                        if ~isnan(P1(j,1))
                            TraceArray{end+1} = [P1(j,:), i]; % x,y,z,hybNo
                        end
                    end
                end
            end
        end
        
        for j = 1:length(TraceArray)
            for i = 1:size(TraceArray{j},1)
                if TraceArray{j}(i,8) >= 16
                    TraceArray{j}(i,8) = TraceArray{j}(i,8)+1;
                end
            end
        end
        
        n = 0;
        for j = 1:length(TraceArray)
            if size(TraceArray{j},1) >= TraceLengthThreshold
                n = n+1;
                TraceArrayNew{n} = TraceArray{j};
            end
        end
        
        if exist('TraceArrayNew','var')
            TraceArray = TraceArrayNew;
        else
            clear TraceArrayNew
            clear TraceArray
            continue
        end
        clear TraceArrayNew
        
        figure(2)
        for j = 1:length(TraceArray)
            plot(TraceArray{j}(:,1), TraceArray{j}(:,2),'.-');
            hold on
            FinalFociCount(TraceArray{j}(:,end)) = FinalFociCount(TraceArray{j}(:,end))+1;
        end
        hold off
        axis equal
        axis ij
        xlabel('x (um)');
        ylabel('y (um)');
        savefig([saveLocation '\Traces_' FOVid '.fig']);
        save([saveLocation '\TraceArray' FOVid '.mat'],'TraceArray');
        clear TraceArray
    end
end
for i = 28:-1:16
    FociCount(i+1) = FociCount(i);
end
FociCount(16) = 0;


figure(3)
bar(FociCount)
xlabel('Hyb number')
ylabel('Initially identified foci count')
savefig([saveLocation '\TracingFociCount_initial_SmallScale.fig']);
figure(4)
bar(FinalFociCount)
xlabel('Hyb number')
ylabel('Foci count after linking traces')
savefig([saveLocation '\TracingFociCount_middle_SmallScale.fig']);