clear all
close all

NFOV = 64; % number of fields of views
NumImage = 361; % Number of images in each dax
FramesToWait = 5; % frames to wait at each height for each channel
ImageSize = 1536; % number of pxls
AdjrsquareThreshold = 0.7;
NumHybs_d1 = 1; % number of Cy5 hyb;
NumHybs_d2 = 28; % number of Cy3 secondary hybs.
InitialLocalMaxThresh = 200; % brightness threshold for foci identification
FociAreaThreshold = 20; % this threshold elimiates large patches of fluorescence
Hyb0IsBit1 = 1; % change this to 1 if hyb0 is bit1.
NumChr = 20;
Epxpected_Foci = 4;

TotalNumChannels = 2; % total number of channels in the multi-channel z stack

%%
mkdir('Foci_Fit_Tracing')
load('ColorShift/DeltaZ.mat');
load('ColorShift/tform.mat');

for jj = 0:NFOV-1
%     if jj == 26
%         continue
%     end
    if NFOV<10
        FOVid = num2str(jj);
    elseif NFOV>=10 && NFOV<=100
        if jj<10
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    elseif NFOV>100 
        if jj<10
            FOVid = ['00' num2str(jj)];
        elseif jj<100
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    end
    
    load(['DAPI_Registration\CellList' FOVid '.mat']);
    
    
%     MaxNumFociToFit = round(length(fieldnames(CellList))*2);
    
    if exist(['TracingDriftParams_Tracing/DriftParams' FOVid '.mat'])==2
        load(['TracingDriftParams_Tracing/DriftParams' FOVid '.mat']);
    else
        continue
    end
    
    Clean_FISH_Foci_Count =0;
    for i = 1:NumHybs_d2
        if Hyb0IsBit1 == 1
            if i-1<10
                HybNumString = ['0' num2str(i-1)];
            elseif i-1 < 100
                HybNumString = [num2str(i-1)];
            end
        end
        
        if i <= 6
            FileName = ['E:\Example\Directory\TracingImage' HybNumString FOVid];
            NumImage = 751; % Number of images in each dax 
            FramesToWait = 5; % frames to wait at each height for each channel
            TotalNumChannels = 3;
            [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName,NumImage,ImageSize,FramesToWait,TotalNumChannels,1,3,5);

        elseif i >= 7
            FileName = ['E:\Example\Directory\TracingImage' HybNumString FOVid];
            NumImage = 501; % Number of images in each dax 
            FramesToWait = 5; % frames to wait at each height for each channel
            TotalNumChannels = 2;
            [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName,NumImage,ImageSize,FramesToWait,TotalNumChannels,1,3,5);
        end
        
        
        
        
        jjj = i;
        for gg = 1:length(fieldnames(CellList))
            if Xdrift(jjj) == 1000
                continue
            end
            
            CellName = ['cell' [num2str(gg)]];
            CellMatrix = cell2mat(CellList.(CellName));
            if isempty(find(CellMatrix(:,2)>= (size(ImageStack,1)-20)))==0 || isempty(find(CellMatrix(:,1)>=(size(ImageStack,1)-20)))==0 || isempty(find(CellMatrix(:,1)<=20))==0 || isempty(find(CellMatrix(:,2)<=20))==0 
                continue
            end
            
            x1 = floor(min(CellMatrix(:,2)+Xdrift(jjj)));
            x2 = ceil(max(CellMatrix(:,2)+Xdrift(jjj)));
            y1 = floor(min(CellMatrix(:,1)+Ydrift(jjj)));
            y2 = ceil(max(CellMatrix(:,1)+Ydrift(jjj)));
            
            CropedImage = ImageStack(y1:y2, x1:x2,:);
            figure(1)
            imagesc(mean(CropedImage,3));
            colormap gray
            axis equal
            hold on
            
            % use adaptive thresholding to try to get MaxNumFociToFit foci
            LocalMaxThresh = InitialLocalMaxThresh;
            ImageMax = medfilt2(max(CropedImage, [],3));
            background = imopen(ImageMax, strel('disk', 4));
            ImageMax = ImageMax-background;
            ImageMax(find(ImageMax<0)) = 0;
            BW = imextendedmax(ImageMax,LocalMaxThresh);
            CC = bwconncomp(BW, 8 );
            S = regionprops(CC, 'Area');
            SS = regionprops(CC,'Centroid');
            
%             for kk = 1:length(SS)
%                 SS(kk).Centroid(1) = round(SS(kk).Centroid(1)- Xdrift(jjj));  
%                 SS(kk).Centroid(2) = round(SS(kk).Centroid(2)- Ydrift(jjj));
%             end
            
            Ind = find([S.Area]<FociAreaThreshold);
            SS = SS(Ind);
            
            Insider = 0;
            Insider = length(Ind);
%             for ff = 1:length(SS)
%                 Xindex = find(SS(ff).Centroid(1)==CellMatrix(:,2));
%                 Yindex = find(SS(ff).Centroid(2)==CellMatrix(:,1));
%                 if max(ismember(Xindex, Yindex)) == 1
%                     Insider = Insider+1;
%                 end
%             end
%             
            if Insider > Epxpected_Foci
                while Insider > Epxpected_Foci && LocalMaxThresh<2000
                    LocalMaxThresh = LocalMaxThresh+10;
                    BW = imextendedmax(ImageMax,LocalMaxThresh);
                    CC = bwconncomp(BW, 8);
                    S = regionprops(CC, 'Area');
                    SS = regionprops(CC,'Centroid');
%                     for kk = 1:length(SS)
%                         SS(kk).Centroid(1) = round(SS(kk).Centroid(1)- Xdrift(jjj));
%                         SS(kk).Centroid(2) = round(SS(kk).Centroid(2)- Ydrift(jjj));
%                     end
                    Ind = find([S.Area]<FociAreaThreshold);
                    SS = SS(Ind);
                    Insider = 0;
                    Insider = length(Ind);
%                     for ff = 1:length(SS)
%                         Xindex = find(SS(ff).Centroid(1)==CellMatrix(:,2));
%                         Yindex = find(SS(ff).Centroid(2)==CellMatrix(:,1));
%                         
%                         if max(ismember(Xindex, Yindex)) == 1
%                             Insider = Insider+1;
%                         end
%                     end
                    
                end
            else
                while Insider < Epxpected_Foci && LocalMaxThresh>50 
                    LocalMaxThresh = LocalMaxThresh-10;
                    BW = imextendedmax(ImageMax,LocalMaxThresh);
                    CC = bwconncomp(BW, 8);
                    S = regionprops(CC, 'Area');
                    SS = regionprops(CC,'Centroid');
%                     for kk = 1:length(SS)
%                         SS(kk).Centroid(1) = round(SS(kk).Centroid(1)- Xdrift(jjj));
%                         SS(kk).Centroid(2) = round(SS(kk).Centroid(2)- Ydrift(jjj));
%                     end
                    Ind = find([S.Area]<FociAreaThreshold);
                    SS = SS(Ind);
                    Insider = 0;
                    Insider = length(Ind);
%                     for ff = 1:length(SS)
%                         Xindex = find(SS(ff).Centroid(1)==CellMatrix(:,2));
%                         Yindex = find(SS(ff).Centroid(2)==CellMatrix(:,1));
%                         if max(ismember(Xindex, Yindex)) == 1
%                             Insider = Insider+1;
%                         end
%                     end
                    
                end
                
            end
            [Xfit, Yfit, Zfit, Xgof, Ygof, Zgof, Intensity, Xwidth, Ywidth, Zwidth,Fig] = fitMultipleFoci_Fig(CropedImage,LocalMaxThresh,length(SS),FociAreaThreshold);
            saveas(Fig,['Foci_Fit_Tracing\FOV_' FOVid '_Cell_' num2str(gg) '_hyb_' num2str(i) '.png']);
            if length(Xfit)>0
                Ind = find([Xgof.adjrsquare]>AdjrsquareThreshold & ...
                    [Ygof.adjrsquare]>AdjrsquareThreshold & ...
                    [Zgof.adjrsquare]>AdjrsquareThreshold);
                XfitList{i} = Xfit(Ind)+ x1-1 - Xdrift(jjj);
                YfitList{i} = Yfit(Ind)+ y1-1 - Ydrift(jjj);
                ZfitList{i} = Zfit(Ind)- Zdrift(jjj);
                XgofList{i} = Xgof(Ind);
                YgofList{i} = Ygof(Ind);
                ZgofList{i} = Zgof(Ind);
                IntensityList{i} = Intensity(Ind);
                XwidthList{i} = Xwidth(Ind);
                YwidthList{i} = Ywidth(Ind);
                ZwidthList{i} = Zwidth(Ind);
                %                 figure(200)
                %                 plot(XfitList{i},YfitList{i},'.');
                if i-1 < 12
                    FociList_Cy3 = struct('Xfit',Xfit(Ind)+x1-1-Xdrift(jjj),'XfitRound',round(Xfit(Ind)+x1-1-Xdrift(jjj)),...
                        'Yfit', Yfit(Ind)+y1-1-Ydrift(jjj),'YfitRound',round(Yfit(Ind)+y1-1-Ydrift(jjj)),...
                        'Zfit',Zfit(Ind)-Zdrift(jjj),...
                        'Intensity',Intensity(Ind),'XwidthList',Xwidth(Ind), 'YwidthList',Ywidth(Ind),'ZwidthList',Zwidth(Ind),...
                        'FociID',zeros(1,length(Xfit(Ind))),'Colocalization', zeros(1,length(Xfit(Ind))),'hyb',zeros(1,length(Xfit(Ind))));
                else
                    FociList_Cy3 = struct('Xfit',Xfit(Ind)+x1-1- Xdrift(jjj),'XfitRound',round(Xfit(Ind)+x1-1- Xdrift(jjj)),...
                        'Yfit', Yfit(Ind)+y1-1-Ydrift(jjj),'YfitRound',round(Yfit(Ind)+y1-1-Ydrift(jjj)),...
                        'Zfit',Zfit(Ind)-Zdrift(jjj),...
                        'Intensity',Intensity(Ind),'XwidthList',Xwidth(Ind), 'YwidthList',Ywidth(Ind),'ZwidthList',Zwidth(Ind),...
                        'FociID',zeros(1,length(Xfit(Ind))),'Colocalization', zeros(1,length(Xfit(Ind))),'hyb',zeros(1,length(Xfit(Ind))));
                end
                for ff = 1:length([FociList_Cy3.FociID])
                    Xindex = find(FociList_Cy3.XfitRound(ff)==CellMatrix(:,2));
                    Yindex = find(FociList_Cy3.YfitRound(ff)==CellMatrix(:,1));
                    if  max(ismember(Xindex, Yindex)) == 1
                        FociList_Cy3.FociID(ff) = gg;
                    end
                end
                
                if gg == 1 && length(cell2mat(struct2cell(subsetstruct(FociList_Cy3,FociList_Cy3.FociID == gg))).') ~= 0
                    CleanFociList_Cy3 = cell2mat(struct2cell(subsetstruct(FociList_Cy3,FociList_Cy3.FociID == gg))).';
                    FinalCleanFociList_Cy3 = CleanFociList_Cy3;%Detele Foci outside nucleus
                elseif gg == 1 && length(cell2mat(struct2cell(subsetstruct(FociList_Cy3,FociList_Cy3.FociID == gg))).') == 0
                    FinalCleanFociList_Cy3 = [];
                elseif length(cell2mat(struct2cell(subsetstruct(FociList_Cy3,FociList_Cy3.FociID == gg))).') ~= 0
                    if exist('FinalCleanFociList_Cy3')
                        CleanFociList_Cy3 = cell2mat(struct2cell(subsetstruct(FociList_Cy3,FociList_Cy3.FociID == gg))).';
                        FinalCleanFociList_Cy3 = cat(1, FinalCleanFociList_Cy3,CleanFociList_Cy3);
                    else
                        CleanFociList_Cy3 = cell2mat(struct2cell(subsetstruct(FociList_Cy3,FociList_Cy3.FociID == gg))).';
                        FinalCleanFociList_Cy3 = CleanFociList_Cy3;
                    end
                else
                    if exist('FinalCleanFociList_Cy3')
                        FinalCleanFociList_Cy3 = FinalCleanFociList_Cy3;
                    else
                        FinalCleanFociList_Cy3 = [];
                    end
                end
                display(['Successfully fit ' num2str(length(XfitList{i})) ' foci.'])
                if exist('CleanFociList_Cy3')
                    display(['Successfully fit ' num2str(size(CleanFociList_Cy3,1)) ' insider foci.'])
                    clear CleanFociList_Cy3;
                else
                    display('Successfully fit 0 insider foci.')
                end
            else
                XfitList{i} = [];
                YfitList{i} = [];
                ZfitList{i} = [];
                XgofList{i} = [];
                YgofList{i} = [];
                ZgofList{i} = [];
                IntensityList{i} = [];
                XwidthList{i} = [];
                YwidthList{i} = [];
                ZwidthList{i} = [];
            end
            figure(200)
            imagesc(BW)
            colormap gray
            axis square
            hold off
        end
        if exist('FinalCleanFociList_Cy3')
            
            XfitList_Final{i} = FinalCleanFociList_Cy3(:,1).';
            YfitList_Final{i} = FinalCleanFociList_Cy3(:,3).';
            ZfitList_Final{i} = FinalCleanFociList_Cy3(:,5).';
            IntensityList_Final{i} = FinalCleanFociList_Cy3(:,6).';
            XwidthList_Final{i} = FinalCleanFociList_Cy3(:,7).';
            YwidthList_Final{i} = FinalCleanFociList_Cy3(:,8).';
            ZwidthList_Final{i} = FinalCleanFociList_Cy3(:,9).';
            clear FinalCleanFociList_Cy3;
        else
            XfitList_Final{i} =  [];
            YfitList_Final{i} = [];
            ZfitList_Final{i} = [];
            IntensityList_Final{i} = [];
            XwidthList_Final{i} = [];
            YwidthList_Final{i} = [];
            ZwidthList_Final{i} = [];
        end
    end
    
    save(['Foci_Fit_Tracing\FinalFoci_Cy3_' FOVid '.mat'],'XfitList_Final', 'YfitList_Final', 'ZfitList_Final', 'IntensityList_Final','XwidthList_Final','YwidthList_Final','ZwidthList_Final');    
    close all
end

% figure(100)
% imagesc(BW)
% colormap gray
% axis square
% hold on


