clear all
close all

NFOV = 64;
NuclearNumImage = 231; % Number of images in nuclear stack
FramesToWait = 5; % frames to wait at each height
TotalCellCount = 0;

mkdir('DAPI_Registration')

for jj = 0:NFOV-1
%     if jj == 13 
%         continue
%     end
    if NFOV<10
        FOVid = num2str(jj);
    elseif NFOV>=10 && NFOV<=100
        if jj<10
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    elseif NFOV>100
        if jj<10
            FOVid = ['00' num2str(jj)];
        elseif jj<100
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    end
        FileName = ['E:\Example\Directory\DAPIImage' FOVid];
        [ImageStack_moving, InfoFile_moving] = ReadZStack(FileName,NuclearNumImage,FramesToWait);

        
        ImageMax = max(ImageStack_moving,[],3);
        ImageMax = ImageMax./max(ImageMax,[],'all');
        
        BW = imbinarize(ImageMax,'adaptive','Sensitivity', 0.4);
        BW = imfill(BW,'holes');
        BW = bwareaopen(BW,5000,4);
        

        BW = imdilate(BW,strel('disk',2));
        BW = medfilt2(BW,[7,7]);
        BW = imfill(BW,'holes');
        
        CC_Props = regionprops(BW, 'Circularity','PixelIdxList');
        for i = 1:length(CC_Props)
            if CC_Props(i).Circularity < 0.5
                BW(CC_Props(i).PixelIdxList) = 0;
            end
        end
        

        figure(1)
        imagesc(ImageMax)
        hold on
        axis image
        colormap gray
        boundaries = bwboundaries(BW);
        numberOfBoundaries = size(boundaries,1);
        for i = 1:numberOfBoundaries
            boundary = boundaries{i};
            plot(boundary(:,2),boundary(:,1),'r','LineWidth',1);
        end
        saveas(gcf, ['DAPI_Registration/DAPI_Clean_' [num2str(jj)] '.jpg']);

          
        [L,CellNumber] = bwlabel(BW);
        TotalCellCount = TotalCellCount + CellNumber;
        
       for iii = 1:CellNumber
           CellListName = ['cell' [num2str(iii)]];
           [y,x] = find(L==iii);
           Coordinate = {[y,x]};
           CellList.(CellListName) = Coordinate;
       end     
        
       save(['DAPI_Registration/CellList' FOVid '.mat'], 'CellList');
       clear CellList;
       
       DAPI = BW;
      save(['DAPI_Registration/DAPI_' FOVid '.mat'], 'DAPI');

end






