clear all
close all

NFOV = 37;
NumLoci = 30;
UmPerPxl = 0.108; % Pixel size in the unit of um 
StepSize = 0.2; % Z stack step size in the unit of um 

%% load in chromosome traces
n = 0;

for jj = 0:NFOV-1

    if jj < 10
        FOVid = ['0' num2str(jj)];
    else
        FOVid = num2str(jj);
    end

    if exist(['Traces_SmallScale\TraceArray' FOVid '.mat'])==2 
        load(['Traces_SmallScale\TraceArray' FOVid '.mat']);
        
        for i = 1:length(TraceArray)            
            n = n+1;
            Chr(n).x = NaN(NumLoci,1);
            Chr(n).y = NaN(NumLoci,1);
            Chr(n).z = NaN(NumLoci,1);
            Chr(n).r = zeros(NumLoci,1);
            Chr(n).x(TraceArray{i}(:,8)) = TraceArray{i}(:,1);
            Chr(n).y(TraceArray{i}(:,8)) = TraceArray{i}(:,2);
            Chr(n).z(TraceArray{i}(:,8)) = TraceArray{i}(:,3);
            Chr(n).r(TraceArray{i}(:,8)) = 1;
            Chr(n).FOV = jj;  
        end
    end
end

%% Plot mean spatial distance matrix

for i = 1:NumLoci 
    for j = 1:NumLoci 
        DisList = [];
        for k = 1:length(Chr)
            if Chr(k).r(i) == 1 && Chr(k).r(j) == 1
                DisList = [DisList ((Chr(k).x(i)-Chr(k).x(j))^2+(Chr(k).y(i)-Chr(k).y(j))^2+(Chr(k).z(i)-Chr(k).z(j))^2)^0.5];
            end
        end
        MedianDist(i,j) = median(DisList);
        Std(i,j) = std(DisList);
        SEM(i,j) = std(DisList)/(length(DisList))^0.5;
        NofData(i,j) = length(DisList);
        DisListAll{i,j} = DisList;
    end
end

figure(1)
imagesc(MedianDist)
colorbar
title(['Median spatial distance, n=' num2str(length(Chr))]);
xlabel('ID # of imaged genomic locus','FontSize',11);
ylabel('ID # of imaged genomic locus','FontSize',11);
ColorMap = load('RedBlue.txt');
colormap(ColorMap/255);
a = colorbar;
a.Label.String = 'Median spatial distance (m)';
a.Label.FontSize = 11;
axis square
% caxis([0 maxDist])
saveas(gcf, 'Traces_SmallScale\Median spatial distance.jpg')
% savefig(['Mean spatial distance.fig']);
save('Traces_SmallScale\medianPairwiseDist.mat','Median')

MeanSize = zeros(size(DisListAll));
for i = 1:size(DisListAll,1)
    for ii = 1:size(DisListAll,2)
        MeanSize(i,ii) = length(DisListAll{i,ii});
    end
end

figure(2)
imagesc(MeanSize)
colorbar
ColorMap = load('RedBlue.txt');
colormap(ColorMap/255);
a = colorbar;
a.Label.String = 'Median spatial distance (m)';
a.Label.FontSize = 11;
axis square
caxis([0 inf])
saveas(gcf, 'Traces_SmallScale\Count.jpg')
% savefig(['Mean spatial distance.fig']);

for i = 1:30
    detectionCount(i) = MeanSize(i,i);
end
detectionEfficiency = detectionCount./length(Chr);
