clear all
close all

NFOV = 37;
NuclearNumImage = 351; % Number of images in nuclear stack
FramesToWait = 5; % frames to wait at each height
TotalCellCount = 0;
ImageSize = 1536;

areaThreshold = 8000;
edgeLimit = 10;

mkdir('DAPI_Registration')

for jj = 0:NFOV-1
%     if jj == 13 
%         continue
%     end
    if NFOV<10
        FOVid = num2str(jj);
    elseif NFOV>=10 && NFOV<=100
        if jj<10
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    elseif NFOV>100
        if jj<10
            FOVid = ['00' num2str(jj)];
        elseif jj<100
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    end
        FileName = ['E:\Example\Directory\DAPIImage' FOVid];
        [ImageStack,~] = ReadZStack_MultiChannel_Optimized(FileName,351,ImageSize,FramesToWait,1,1,3,5);
        
        ImageMax = max(ImageStack,[],3);
        ImageMax = ImageMax./max(ImageMax,[],'all');
                

        
        BW_Init = imbinarize(ImageMax, 'adaptive','Sensitivity',0.5);
        BW = BW_Init;
        cc = bwconncomp(BW,4);
        s = regionprops(cc,'Area','PixelIdxList');
        Ind = find([s.Area]<areaThreshold);
        for i = 1:length(Ind)
            BW(s(Ind(i)).PixelIdxList) = 0;
        end
        
        % - eliminate DAPI too close to the edge
        cc = bwconncomp(BW,4);
        s = regionprops(cc,'PixelIdxList');
        for i = 1:length(s)
            for z = 1:length(s(i).PixelIdxList)
                [I_coord,Z_coord] = ind2sub(size(BW),s(i).PixelIdxList(z));
                if I_coord < edgeLimit ...
                        || Z_coord < edgeLimit ...
                        || I_coord > (size(BW,1)-edgeLimit) ...
                        || Z_coord > (size(BW,2)-edgeLimit)
                    BW(s(i).PixelIdxList) = 0;
                    break
                end
            end
        end
        
        BW = imfill(BW,'holes');
        se = strel('disk',2);
        BW_Dialate = imdilate(BW,se);
        BW_Medfilt = medfilt2(BW_Dialate);
        BW_Dialate = imdilate(BW_Medfilt,se);
        
%         figure(1)
%         subplot(1,3,1)
%         imagesc(ImageMax)
%         axis image
%         colormap gray
%         
%         subplot(1,3,2)
%         imagesc(BW_Dialate)
%         axis image
%         colormap gray
%         
%         subplot(1,3,3)
%         imagesc(BW_Medfilt)
%         axis image
%         colormap gray
        
        figure(2)
        hold on
        imagesc(ImageMax);
        colormap gray
        axis image
        title('DAPI');
        boundaries = bwboundaries(BW_Dialate);
        numberOfBoundaries = size(boundaries,1);
        for i = 1:numberOfBoundaries
            boundary = boundaries{i};
            plot(boundary(:,2),boundary(:,1),'r','LineWidth',1);
        end
        set(gca, 'YDir','reverse')
        hold off
        saveas(gcf, ['DAPI_Registration/DAPI_Clean_' [num2str(jj)] '.jpg']);
        close all

        BW5 = BW_Dialate;
        
        [L,CellNumber] = bwlabel(BW5);
        TotalCellCount = TotalCellCount + CellNumber;
        
       for iii = 1:CellNumber
           CellListName = ['cell' [num2str(iii)]];
           [y,x] = find(L==iii);
           Coordinate = {[y,x]};
           CellList.(CellListName) = Coordinate;
       end     
        
       save(['DAPI_Registration/CellList' FOVid '.mat'], 'CellList');
       clear CellList;

end









