clear all
close all

NFOV = 45; % number of fields of views
Master = readtable('DNA_Decoded_1Filter_LowPassIntensityFilter1.5_2pixel/Decode_Table.xls');
load('Gene.mat');
Combined_PHR_List = [];
Signal_Filter = 1.5;
Foci_Filter = 50;

for jj = 0:NFOV-1
 
    if NFOV<10
        FOVid = num2str(jj);
    elseif NFOV>=10 && NFOV<=100
        if jj<10
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    elseif NFOV>100
        if jj<10
            FOVid = ['00' num2str(jj)];
        elseif jj<100
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    end
    
    load(['F:/02132024_2Marks_200Loci_PolIIS5P_H3K27me3/Data_DNA_mFISH/PHR_IF_TroubleShooting_CleanedFoci_1Filter_LowPass1.5and2pixel_Local/FinalFoci_Cy3_' FOVid '.mat']);
    Combined_PHR_List = [Combined_PHR_List; FinalCleanFociList_Cy3];
      
end

 gmdist = fitgmdist([Combined_PHR_List{:,12}].',2);
 [gmmu,Ind] = max(gmdist.mu);
 gmsigma = gmdist.Sigma;
 gmwt = gmdist.ComponentProportion;
 Cy5_Filter = gmmu;
 
 gmdist_2 = fitgmdist([Combined_PHR_List{:,13}].',2);
 [gmmu_2,Ind_2] = max(gmdist_2.mu);
 gmsigma_2 = gmdist_2.Sigma;
 gmwt_2 = gmdist_2.ComponentProportion;
 Cy3_Filter = gmmu_2;
 


PHR_GeneName = cat(1,Combined_PHR_List{:,9});
RNA_SeqName = {Gene.ShortName};;
PHR_Intensity_H3K36me3 = NaN(size(Master,1),1,'single');
PHR_Intensity_Median_H3K36me3 = NaN(size(Master,1),1,'single');
PHR_Signal_Rate_H3K36me3 = NaN(size(Master,1),1,'single');
PHR_Intensity_H3K27me3 = NaN(size(Master,1),1,'single');
PHR_Intensity_Median_H3K27me3 = NaN(size(Master,1),1,'single');
PHR_Signal_Rate_H3K27me3 = NaN(size(Master,1),1,'single');
PHR_Co_occurrence = NaN(size(Master,1),1,'single');
RNA_Seq = NaN(size(Master,1),1,'single');
Gro_Seq =  NaN(size(Master,1),1,'single');

Master_New = addvars(Master,PHR_Intensity_H3K36me3,PHR_Intensity_Median_H3K36me3,PHR_Signal_Rate_H3K36me3,PHR_Intensity_H3K27me3,PHR_Intensity_Median_H3K27me3,PHR_Signal_Rate_H3K27me3,PHR_Co_occurrence,RNA_Seq,Gro_Seq);


for i= 1:size(Master_New,1)
    PHR_Mean = 0;
    GeneName_Master = Master_New.GeneName{i};
    TF = matches(PHR_GeneName,GeneName_Master); 
    if length(find(TF==1)) < Foci_Filter
           continue 
    end
    
    PHR_Mean = mean([Combined_PHR_List{TF,12}],'omitnan');
    PHR_Median = median([Combined_PHR_List{TF,12}],'omitnan');
    Num_Good_PHR = length(find([Combined_PHR_List{TF,12}]>Cy5_Filter));

    
  
    PHR_Mean_2 = mean([Combined_PHR_List{TF,13}],'omitnan');
    PHR_Median_2 = median([Combined_PHR_List{TF,13}],'omitnan');
    Num_Good_PHR_2 = length(find([Combined_PHR_List{TF,13}]>Cy3_Filter));
    
    
    Master_New.PHR_Intensity_H3K36me3(i) = PHR_Mean;
    Master_New.PHR_Intensity_Median_H3K36me3(i) = PHR_Median;
    Master_New.PHR_Signal_Rate_H3K36me3(i) = Num_Good_PHR/length(find(TF==1));
    
    
    Master_New.PHR_Intensity_H3K27me3(i) = PHR_Mean_2;
    Master_New.PHR_Intensity_Median_H3K27me3(i) = PHR_Median_2;
    Master_New.PHR_Signal_Rate_H3K27me3(i) = Num_Good_PHR_2/length(find(TF==1));
    
     Co_occur_List = [[Combined_PHR_List{TF,12}].' [Combined_PHR_List{TF,13}].'];
     Counter = 0;
     for ii = 1:size(Co_occur_List,1)
         if Co_occur_List(ii,1) > Cy5_Filter && Co_occur_List(ii,2) > Cy3_Filter
             Counter = Counter+1;
         end
     end
     Master_New.PHR_Co_occurrence(i) = Counter/size(Co_occur_List,1);
       
    
    TF_New = matches(RNA_SeqName,GeneName_Master);
    if isempty(find(TF_New==1))
       continue        
    end
    
    RNA_FPKM = Gene(TF_New).FPKM;
    RNA_RPK = Gene(TF_New).RPK;
    Master_New.RNA_Seq(i) = RNA_FPKM;
    Master_New.Gro_Seq(i) = RNA_RPK;      
end


