clear all
close all
NFOV = 45; % number of fields of views
hyb = 1;
NumImage = 721; % Number of images in each dax
TotalNumChannels = 3; % total number of channels in the multi-channel z stack
ImageSize = 1536; % number of pxls
StepInterval = 5; % frames to wait at each height for each channel
NumberOfFramesPerZ = 3;
FirstCenterFrameIndex = 5;
Intensity = [];

mkdir('PHR_IF_TroubleShooting_CleanedFoci_1Filter_LowPass1.5and2pixel_Local')
load('ColorShift/DeltaZ.mat');
load('ColorShift/tform.mat');
for jj = 0:NFOV-1
    
    Delete_Ind =[];

    if NFOV<10
        FOVid = num2str(jj);
    elseif NFOV>=10 && NFOV<=100
        if jj<10
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    elseif NFOV>100
        if jj<10
            FOVid = ['00' num2str(jj)];
        elseif jj<100
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    end
    
    load(['E:/02132024_2Marks_200Loci_PolIIS2P_H3K27me3/Data_DNA_mFISH/DNA_Decoded_1Filter_LowPassIntensityFilter1.5_2pixel/Decoded_Cy3_' FOVid '.mat']);
    FinalCleanFociList_Cy3 = RNA_Cy3;
    load(['E:/02132024_2Marks_200Loci_PolIIS2P_H3K27me3/Data_DNA_mFISH/DAPI/CellList' FOVid '.mat']);
    FileName = ['E:/02132024_2Marks_200Loci_PolIIS2P_H3K27me3/PHR_DAPI/STORMCy5_0_' FOVid];
    [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName, NumImage, ImageSize, StepInterval, TotalNumChannels, 1, NumberOfFramesPerZ, FirstCenterFrameIndex);
    [ImageStack_2, InfoFile_2] = ReadZStack_MultiChannel_Optimized(FileName, NumImage, ImageSize, StepInterval, TotalNumChannels, 2, NumberOfFramesPerZ, FirstCenterFrameIndex);
    for j = 1:size(ImageStack,3)
        ImageStack(:,:,j) = imtransform(ImageStack(:,:,j), tform, 'XData', [1 ImageSize], 'YData',[1 ImageSize]);
    end
   
    for i=1:size(FinalCleanFociList_Cy3,1)

        Z = round(FinalCleanFociList_Cy3{i,5}+DeltaZ);
        if Z>=48
            Delete_Ind =[Delete_Ind i];
            continue
        end
        Y = FinalCleanFociList_Cy3{i,4};
        Y_Range = ceil(FinalCleanFociList_Cy3{i,11});
        X = FinalCleanFociList_Cy3{i,2};
        X_Range = ceil(FinalCleanFociList_Cy3{i,10});
        Background_Value = [];
        Background_Value_2 = [];
        Singal_Value = [];
        Singal_Value_2 = [];
               
       for ii = 1:7
            if Z>=48
                break
            elseif Z<=3 && Z>1
                Z_Slice = ImageStack(:,:,ii);
                Z_Slice_2 = ImageStack_2(:,:,ii);
            elseif Z>=45 && Z<48
                Z_Slice = ImageStack(:,:,41+ii);
                Z_Slice_2 = ImageStack_2(:,:,41+ii);
            else
                Z_Slice = ImageStack(:,:,Z-4+ii);
                Z_Slice_2 = ImageStack_2(:,:,Z-4+ii);
            end
            new_Z_Slice = Z_Slice(Y-(Y_Range*1):Y+(Y_Range*1),X-(X_Range*1):X+(X_Range*1));
            new_Z_Slice_2 = Z_Slice_2(Y-(Y_Range*1):Y+(Y_Range*1),X-(X_Range*1):X+(X_Range*1));
            Y_mid = (Y_Range*1)+1;
            X_mid = (X_Range*1)+1;
         
            Signal =  new_Z_Slice(Y_mid-1:Y_mid+1,X_mid-1:X_mid+1);
            Signal_2 =  new_Z_Slice_2(Y_mid-1:Y_mid+1,X_mid-1:X_mid+1);
            Signal = max(max(Signal));
            Signal_2 = max(max(Signal_2));

            new_Z_Slice(Y_mid-1:Y_mid+1,X_mid-1:X_mid+1) = NaN(length(Y_mid-1:Y_mid+1),length(X_mid-1:X_mid+1));
            new_Z_Slice_2(Y_mid-1:Y_mid+1,X_mid-1:X_mid+1) = NaN(length(Y_mid-1:Y_mid+1),length(X_mid-1:X_mid+1));
                       
            Singal_Value = [Singal_Value Signal];
            Singal_Value_2 = [Singal_Value_2 Signal_2];         
            Background_Value = [Background_Value mean(new_Z_Slice,'all','omitnan')];
            Background_Value_2 = [Background_Value_2 mean(new_Z_Slice_2,'all','omitnan')];

        end
        mean_value = max(Singal_Value)/mean(Background_Value);
        mean_value_2 = max(Singal_Value_2)/mean(Background_Value_2);
        FinalCleanFociList_Cy3(i,12) = {mean_value};
        FinalCleanFociList_Cy3(i,13) = {mean_value_2};

        
    end
    FinalCleanFociList_Cy3(Delete_Ind,:) = [];
    save(['PHR_IF_TroubleShooting_CleanedFoci_1Filter_LowPass1.5and2pixel_Local/FinalFoci_Cy3_' FOVid '.mat'], 'FinalCleanFociList_Cy3');

end

