close all
clear all

NFOV = 45;
Hyb = 36; 
blankcode = ['000000000000000000000000000000000000'];
Master = readtable('Final_Table_CodeArranged_4Mbp_12052023Updated_FinalCodeCorrected_PrimerUpdated.xls');
Foci_Counts = zeros(size(Master,1),1);
Master_New = addvars(Master,Foci_Counts);
[CodeList1,ia1, ic1] = unique(Master.Code,'stable');
mkdir('DNA_Decoded_1Filter_LowPassIntensityFilter1.5_2pixel')
Total_Cell_Count = 0;

for jj =0:NFOV-1
    
    RNA_Cy3 ={};
    Final_Cy3={};

    if NFOV<10
        FOVid = num2str(jj);
    elseif NFOV>=10 && NFOV<=100
        if jj<10
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    elseif NFOV>100
        if jj<10
            FOVid = ['00' num2str(jj)];
        elseif jj<100
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    end
    load(['E:/02132024_2Marks_200Loci_PolIIS2P_H3K27me3/Data_DNA_mFISH/Cleaned_Foci_With_LowPassFilter1.5/FinalFoci_Cy3_' FOVid '.mat']);
    Split_Cy3 = FinalCleanFociList_Cy3_New;
    Total_Cell_Count = Total_Cell_Count + max(Split_Cy3(:,8));

    while isempty(Split_Cy3)==0
        
        X = Split_Cy3(1,1);
        Y = Split_Cy3(1,3);
        Z = Split_Cy3(1,5);
        RNA_New=[];
        RNA_Final ={};
        Bit = [];
        NewCode = blankcode;
        FinalCode =[];
        [row,col] = find(abs(Split_Cy3(:,1)-X)< 2 & abs(Split_Cy3(:,3)-Y)< 2 & abs(Split_Cy3(:,5)-Z)< 2);

       if length(row)~=2 
           Split_Cy3(row,:) =[]; 
           continue
       else
           RNA_New = Split_Cy3(row,:);
           RNA_Final{1,1} = mean(RNA_New(:,1));
           RNA_Final{1,2} = mean(RNA_New(:,2));
           RNA_Final{1,3} = mean(RNA_New(:,3));
           RNA_Final{1,4} = mean(RNA_New(:,4));
           RNA_Final{1,5} = mean(RNA_New(:,5));
           RNA_Final{1,6} = mean(RNA_New(:,8));
           Bit = Split_Cy3(row,10);
           NewCode(Bit)='1'; 
           FinalCode = NewCode;
           RNA_Final{1,7} = FinalCode;
           TF = matches(CodeList1,FinalCode); 
           if isempty(Master(TF,:).Chromosome_scaffoldName)==0
               Master_New(TF,:).Foci_Counts = Master_New(TF,:).Foci_Counts+1;
               RNA_Final{1,8} = Master(TF,:).Chromosome_scaffoldName;
               RNA_Final{1,9} = Master(TF,:).GeneName;
               RNA_Final{1,10} = mean(RNA_New(:,12));
               RNA_Final{1,11} = mean(RNA_New(:,13));
               RNA_Cy3 =[RNA_Cy3;RNA_Final];
               Split_Cy3(row,:) =[];
           else
               Split_Cy3(row,:) =[];
           end
       end
    end
    
    
    

    
    save(['E:/02132024_2Marks_200Loci_PolIIS2P_H3K27me3/Data_DNA_mFISH/DNA_Decoded_1Filter_LowPassIntensityFilter1.5_2pixel/Decoded_Cy3_' FOVid '.mat'], 'RNA_Cy3');
    
  
    
    
end

writetable(Master_New,'DNA_Decoded_1Filter_LowPassIntensityFilter1.5_2pixel/Decode_Table.xls');
