clear all
close all
NFOV = 16; % number of fields of views
hyb = 1;
NumImage = 721; % Number of images in each dax
TotalNumChannels = 3; % total number of channels in the multi-channel z stack
ImageSize = 1536; % number of pxls
StepInterval = 5; % frames to wait at each height for each channel
NumberOfFramesPerZ = 3;
FirstCenterFrameIndex = 5;
Intensity = [];

mkdir('PHR_100Kb_WO_pAb')
load('ColorShift/DeltaZ.mat');
load('ColorShift/tform.mat');
for jj = 1:NFOV

    Delete_Ind =[];

    if NFOV<10
        FOVid = num2str(jj);
    elseif NFOV>=10 && NFOV<=100
        if jj<10
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    elseif NFOV>100
        if jj<10
            FOVid = ['00' num2str(jj)];
        elseif jj<100
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    end
    
    load(['F:/12212023_PHR1_Resolution_65degWash_45FormamideWash/Data_DNA_mFISH/FISH_Foci_Fit_100Kb_WO_pAb/FinalFoci_Cy3_' FOVid '.mat']);
    load(['F:/12212023_PHR1_Resolution_65degWash_45FormamideWash/Data_DNA_mFISH/DAPI_100Kb_WO_pAb/CellList' FOVid '.mat']);
    FileName = ['F:/12212023_PHR1_Resolution_65degWash_45FormamideWash/100Kb_WO_pAb/movie_00' FOVid '_561'];
    [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName, NumImage, ImageSize, StepInterval, TotalNumChannels, 1, NumberOfFramesPerZ, FirstCenterFrameIndex);
    
    for j = 1:size(ImageStack,3)
        ImageStack(:,:,j) = imtransform(ImageStack(:,:,j), tform, 'XData', [1 ImageSize], 'YData',[1 ImageSize]);
    end
    
    
    
    
    for i=1:size(FinalCleanFociList_Cy3,1)
        Z = round(FinalCleanFociList_Cy3(i,5)+DeltaZ);
        if Z>=48
            Delete_Ind =[Delete_Ind i];
            continue
        end
        Y = FinalCleanFociList_Cy3(i,4);
        Y_Range = ceil(FinalCleanFociList_Cy3(i,11));
        X = FinalCleanFociList_Cy3(i,2);
        X_Range = ceil(FinalCleanFociList_Cy3(i,10));
        Background_Value = [];
        Singal_Value = [];
        mean_value = 0;
        
       for ii = 1:7
            if Z>=48
                break
            elseif Z<=3 && Z>1
                Z_Slice = ImageStack(:,:,ii);
            elseif Z>=45 && Z<48
                Z_Slice = ImageStack(:,:,41+ii);
            else
                Z_Slice = ImageStack(:,:,Z-4+ii);
            end
            new_Z_Slice = Z_Slice(Y-(Y_Range*4):Y+(Y_Range*4),X-(X_Range*4):X+(X_Range*4));
            Y_mid = (Y_Range*4)+1;
            X_mid = (X_Range*4)+1;
         
            Signal = new_Z_Slice(Y_mid-(Y_Range):Y_mid+(Y_Range),X_mid-(X_Range):X_mid+(X_Range));
            Signal = max(Signal);
            new_Z_Slice(Y_mid-(Y_Range*2):Y_mid+(Y_Range*2),X_mid-(X_Range*2):X_mid+(X_Range*2)) = NaN(size(Y_mid-(Y_Range*2):Y_mid+(Y_Range*2),X_mid-(X_Range*2):X_mid+(X_Range*2)));
            Singal_Value = [Singal_Value Signal];

            Background_Value = [Background_Value mean(new_Z_Slice,'all','omitnan')];
            
        end
        mean_value = max(Singal_Value)/mean(Background_Value);
        FinalCleanFociList_Cy3(i,12) = mean_value;
        Intensity = [Intensity mean_value];

        
    end
    FinalCleanFociList_Cy3(Delete_Ind,:) = [];
    save(['PHR_100Kb_WO_pAb/FinalFoci_Cy3_' FOVid '.mat'], 'FinalCleanFociList_Cy3');

    
    
    
end

 save(['F:/12212023_PHR1_Resolution_65degWash_45FormamideWash/Data_DNA_mFISH/PHR_100Kb_WO_pAb/Intensity.mat'], 'Intensity');
