
clear all
close all
NFOV = 16; % number of fields of views
NumImage = 721; % Number of images in each dax
TotalNumChannels = 3; % total number of channels in the multi-channel z stack
ImageSize = 1536; % number of pxls
StepInterval = 5; % frames to wait at each height for each channel
NumberOfFramesPerZ = 3;
FirstCenterFrameIndex = 5;
AdjrsquareThreshold = 0.7;
NumHybs_d1 = 1; % number of Cy5 hyb;
NumHybs_d2 = 1; % number of Cy3 secondary hybs.
InitialLocalMaxThresh = 200; % brightness threshold for foci identification
MaxNumFociToFit = 0; % maxium number of foci to fit per FOV
FociAreaThreshold = 20; % this threshold elimiates large patches of fluorescence
Hyb0IsBit1 = 1; % change this to 1 if hyb0 is bit1.
NumChr = 20;
ChrCount = zeros(NumHybs_d1,NumChr);
CellCount=0;
Clean_FISH_Foci_Count =0;
Foci_per_Cell =0;
Coloc = zeros(NumHybs_d2,2);
Epxpected_Foci = 8;
Total_Raw_Intensity = [];
Total_Intensity_Ratio = [];

mkdir('FISH_Foci_Fit_100Kb_WO_pAb')
load('ColorShift/DeltaZ.mat');
load('ColorShift/tform.mat');

for jj =1:NFOV

    if NFOV<10
        FOVid = num2str(jj);
    elseif NFOV>=10 && NFOV<=100
        if jj<10
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    elseif NFOV>100
        if jj<10
            FOVid = ['00' num2str(jj)];
        elseif jj<100
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    end
    
    load(['DAPI_100Kb_WO_pAb/CellList' FOVid '.mat']);
    
    
    MaxNumFociToFit = round(length(fieldnames(CellList))*2);
    
    if exist(['New_Drift/DriftParams' FOVid '.mat'])==2
        load(['New_Drift/DriftParams' FOVid '.mat']);
    end
    
    for i = 1:NumHybs_d2

        if Hyb0IsBit1 == 0
            if i<10
                FileName = ['sequential/STORM2_0' num2str(i) '_' FOVid];
            elseif i<21
                FileName = ['sequential/STORM2_' num2str(i) '_' FOVid];
            else 
                FileName = ['sequential/STORM2_' num2str(i) '_' FOVid];
            end
        elseif Hyb0IsBit1 == 1
            if i-1<10
                FileName = ['F:/12212023_PHR1_Resolution_65degWash_45FormamideWash/100Kb_WO_pAb/movie_00' FOVid '_561'];
            elseif i-1<18
                FileName = ['F:/01152024_PHR_H3K36me3_200Loci/DNA_FISH/STORMCy5_' num2str(i-1) '_' FOVid];
            elseif i-1<28
                FileName = ['F:/01152024_PHR_H3K36me3_200Loci/DNA_FISH/STORMCy5_0' num2str(i-19) '_' FOVid];
            elseif i-1<40
                FileName = ['F:/01152024_PHR_H3K36me3_200Loci/DNA_FISH/STORMCy5_' num2str(i-19) '_' FOVid];
            else
                FileName = ['sequential_Cy3/STORMCy3_' num2str(i) '_' FOVid];
            end
        end
        if i<19
            [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName, NumImage, ImageSize, StepInterval, TotalNumChannels, 2, NumberOfFramesPerZ, FirstCenterFrameIndex);
            CurrentDeltaZ = 0;
        else
            [ImageStack, InfoFile] = ReadZStack_MultiChannel_Optimized(FileName, NumImage, ImageSize, StepInterval, TotalNumChannels, 1, NumberOfFramesPerZ, FirstCenterFrameIndex);
            for j = 1:size(ImageStack,3)
                ImageStack(:,:,j) = imtransform(ImageStack(:,:,j), tform, 'XData', [1 ImageSize], 'YData',[1 ImageSize]);
            end
            CurrentDeltaZ = DeltaZ;
        end
        

        % use adaptive thresholding to try to get MaxNumFociToFit foci
        for gg = 1:length(fieldnames(CellList))
            Epxpected_Foci = 2
            CellName = ['cell' [num2str(gg)]];
            CellMatrix = cell2mat(CellList.(CellName));
            
            if isempty(find(CellMatrix(:,2)>= (size(ImageStack,1)-20)))==0 || isempty(find(CellMatrix(:,1)>=(size(ImageStack,1)-20)))==0 || isempty(find(CellMatrix(:,1)<=20))==0 || isempty(find(CellMatrix(:,2)<=20))==0
                continue
            end
            
            CellCount = CellCount+1;
            Xdrift(i) = 0;
            Ydrift(i) = 0;
            Zdrift(i) = 0;

            x1 = floor(min(CellMatrix(:,2)+Xdrift(i)))-7;
            x2 = ceil(max(CellMatrix(:,2)+Xdrift(i)))+7;
            y1 = floor(min(CellMatrix(:,1)+Ydrift(i)))-7;
            y2 = ceil(max(CellMatrix(:,1)+Ydrift(i)))+7;
            
            CropedImage = ImageStack(y1:y2, x1:x2,:);
            figure(1)
            imagesc(mean(CropedImage,3));
            colormap gray
            axis equal
            hold on
            
            LocalMaxThresh = InitialLocalMaxThresh;
            ImageMax = medfilt2(max(CropedImage, [],3));
            background = imopen(ImageMax, strel('disk', 4));
            ImageMax = ImageMax-background;
            ImageMax(find(ImageMax<0)) = 0;
            BW = imextendedmax(ImageMax,LocalMaxThresh);
            CC = bwconncomp(BW, 8 );
            S = regionprops(CC, 'Area');
            SS = regionprops(CC,'Centroid');
            
            for kk = 1:length(SS)
                SS(kk).Centroid(1) = round(SS(kk).Centroid(1)-Xdrift(i));
                SS(kk).Centroid(2) = round(SS(kk).Centroid(2)-Ydrift(i));
            end
            
            Ind = find([S.Area]<FociAreaThreshold);
            SS = SS(Ind);
            
            Insider = 0;
            Insider = length(Ind);

            if Insider > Epxpected_Foci
                while Insider > Epxpected_Foci && LocalMaxThresh<1700
                    LocalMaxThresh = LocalMaxThresh+10;
                    BW = imextendedmax(ImageMax,LocalMaxThresh);
                    CC = bwconncomp(BW, 8);
                    S = regionprops(CC, 'Area');
                    SS = regionprops(CC,'Centroid');

                    Ind = find([S.Area]<FociAreaThreshold);
                    SS = SS(Ind);
                    Insider = 0;
                    Insider = length(Ind);
                    
                end
            else
                while Insider < Epxpected_Foci && LocalMaxThresh>50
                    LocalMaxThresh = LocalMaxThresh-10;
                    BW = imextendedmax(ImageMax,LocalMaxThresh);
                    CC = bwconncomp(BW, 8);
                    S = regionprops(CC, 'Area');
                    SS = regionprops(CC,'Centroid');

                    Ind = find([S.Area]<FociAreaThreshold);
                    SS = SS(Ind);
                    Insider = 0;
                    Insider = length(Ind);
                    
                end
                
            end
            LocalMaxThresh = LocalMaxThresh
            [Xfit, Yfit, Zfit, Xgof, Ygof, Zgof, Raw_Intensity,Intensity_Ratio, Xwidth, Ywidth, Zwidth,Fig] = fitMultipleFoci_Fig_NormalizedIntensity_RawIntensity_S(CropedImage,LocalMaxThresh,length(SS));
            saveas(Fig,['FISH_Foci_Fit_100Kb_WO_pAb/Cy3Cell_' num2str(gg) '_FOV_' FOVid '_hyb_' num2str(i) '.png']);            
            if length(Xfit)>0
               Ind = find([Xgof.adjrsquare]>AdjrsquareThreshold & ...
                    [Ygof.adjrsquare]>AdjrsquareThreshold & ...
                    [Zgof.adjrsquare]>AdjrsquareThreshold &...
                    Xwidth<20& Xwidth > 0  & Ywidth>0 & Ywidth<20 & Zwidth>0 & Zwidth<20);      
                XfitList{i} = Xfit(Ind)+ x1-1- Xdrift(i) ;
                YfitList{i} = Yfit(Ind)+ y1-1- Ydrift(i) ;
                ZfitList{i} = Zfit(Ind)- Zdrift(i);
                ZfitList{i} = ZfitList{i}-CurrentDeltaZ; % cancel the color shift in Z
                XgofList{i} = Xgof(Ind);
                YgofList{i} = Ygof(Ind);
                ZgofList{i} = Zgof(Ind);
                Raw_IntensityList{i} = Raw_Intensity(Ind);
                Intensity_RatioList{i} = Intensity_Ratio(Ind);
                XwidthList{i} = Xwidth(Ind);
                YwidthList{i} = Ywidth(Ind);
                ZwidthList{i} = Zwidth(Ind);
            else
                XfitList{i} = [];
                YfitList{i} = [];
                ZfitList{i} = [];
                XgofList{i} = [];
                YgofList{i} = [];
                ZgofList{i} = [];
                Raw_IntensityList{i} = [];
                IntensityList{i} = [];
                XwidthList{i} = [];
                YwidthList{i} = [];
                ZwidthList{i} = [];
            end
            display(['Successfully fit ' num2str(length(XfitList{i})) ' foci.'])
            
            if length(XfitList{i})>0
                    FociList_Cy3 = struct('Xfit',Xfit(Ind)+ x1-1- Xdrift(i) ,'XfitRound',round(Xfit(Ind)+ x1-1- Xdrift(i) ),...
                    'Yfit', Yfit(Ind)+ y1-1- Ydrift(i) ,'YfitRound',round(Yfit(Ind)+ y1-1- Ydrift(i)),...
                    'Zfit',Zfit(Ind)- Zdrift(i)-CurrentDeltaZ,'Raw_Intensity',Raw_Intensity(Ind) ,'Intensity_Ratio',Intensity_Ratio(Ind),'FociID',zeros(1,length(Xfit(Ind))),...
                    'Colocalization', zeros(1,length(Xfit(Ind))),'hyb',zeros(1,length(Xfit(Ind))),'Xi',zeros(1,length(Xfit(Ind))),...
                    'Xwidth',Xwidth(Ind),'Ywidth',Ywidth(Ind),'Zwidth',Zwidth(Ind));            
            else
                continue
            end
                for ff = 1:length([FociList_Cy3.FociID])
                    Xindex = find(FociList_Cy3.XfitRound(ff)==CellMatrix(:,2));
                    Yindex = find(FociList_Cy3.YfitRound(ff)==CellMatrix(:,1));
                    if  max(ismember(Xindex, Yindex)) == 1
                        FociList_Cy3.FociID(ff) = gg;
                        FociList_Cy3.hyb(ff) = i;
                    end
                end
            
            
            if  length(cell2mat(struct2cell(subsetstruct(FociList_Cy3,FociList_Cy3.FociID == gg))).') ~= 0
                if exist('FinalCleanFociList_Cy3') == 0
                    CleanFociList_Cy3 = cell2mat(struct2cell(subsetstruct(FociList_Cy3,FociList_Cy3.FociID == gg))).';
                    FinalCleanFociList_Cy3 = CleanFociList_Cy3;%Detele Foci outside nucleus
                else
                    CleanFociList_Cy3 = cell2mat(struct2cell(subsetstruct(FociList_Cy3,FociList_Cy3.FociID == gg))).';
                    FinalCleanFociList_Cy3 = cat(1, FinalCleanFociList_Cy3,CleanFociList_Cy3);
                end
            elseif exist('FinalCleanFociList_Cy3') == 0
                continue
            else
                FinalCleanFociList_Cy3 = FinalCleanFociList_Cy3;
            end
            display(['Successfully fit ' num2str(size(CleanFociList_Cy3,1)) 'insider foci.'])

        end
    end
        Total_Raw_Intensity = cat(1,Total_Raw_Intensity, FinalCleanFociList_Cy3(:,6));
        Total_Intensity_Ratio = cat(1,Total_Intensity_Ratio, FinalCleanFociList_Cy3(:,7));
        Clean_FISH_Foci_Count = Clean_FISH_Foci_Count + size(FinalCleanFociList_Cy3,1); 
        save(['FISH_Foci_Fit_100Kb_WO_pAb/FinalFoci_Cy3_' FOVid '.mat'], 'FinalCleanFociList_Cy3');
        display(['Successfully fit ' num2str(length(FinalCleanFociList_Cy3(:,1))) 'insider foci.'])
        
       
        
        clear CleanFociList_Cy3;
        clear FinalCleanFociList_Cy3;
end
Foci_per_Cell = Clean_FISH_Foci_Count/CellCount;
save(['FISH_Foci_Fit_100Kb_WO_pAb/Foci_per_Cell.mat'], 'Foci_per_Cell');
save(['FISH_Foci_Fit_100Kb_WO_pAb/TotalRawIntensity.mat'], 'Total_Raw_Intensity');
save(['FISH_Foci_Fit_100Kb_WO_pAb/TotalIntensityRatio.mat'], 'Total_Intensity_Ratio');


    
